/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.hotrestart.impl.gc.chunk;

import com.hazelcast.internal.hotrestart.KeyHandle;
import com.hazelcast.internal.hotrestart.impl.gc.GcHelper;
import com.hazelcast.internal.hotrestart.impl.gc.chunk.StableValChunk;
import com.hazelcast.internal.hotrestart.impl.gc.chunk.WriteThroughChunk;
import com.hazelcast.internal.hotrestart.impl.gc.record.Record;
import com.hazelcast.internal.hotrestart.impl.gc.record.RecordDataHolder;
import com.hazelcast.internal.hotrestart.impl.gc.record.RecordMap;
import com.hazelcast.internal.hotrestart.impl.io.ChunkFileOut;

public final class SurvivorValChunk
extends WriteThroughChunk {
    public SurvivorValChunk(long seq, RecordMap records, ChunkFileOut out, GcHelper gcHelper) {
        super(seq, ".chunk.survivor", records, out, gcHelper);
    }

    public void add(Record r, KeyHandle kh, RecordDataHolder holder) {
        long prefix = r.keyPrefix(kh);
        this.records.putIfAbsent(prefix, kh, r.liveSeq(), r.size(), false, 0);
        ++this.liveRecordCount;
        this.grow(r.size());
        this.out.writeValueRecord(r, prefix, holder.keyBuffer, holder.valueBuffer);
    }

    @Override
    public void insertOrUpdate(long recordSeq, long keyPrefix, KeyHandle kh, int ignored, int size) {
        throw new UnsupportedOperationException("SurvivorValChunk#insertOrUpdate");
    }

    @Override
    protected int determineSizeLimit() {
        return SurvivorValChunk.valChunkSizeLimit();
    }

    @Override
    public StableValChunk toStableChunk() {
        return new StableValChunk(this.seq, this.records.toStable(), this.liveRecordCount, this.size(), this.garbage, this.needsDismissing());
    }
}

