/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.hotrestart.impl.gc;

import com.hazelcast.internal.hotrestart.KeyHandle;
import com.hazelcast.internal.hotrestart.impl.RestartItem;
import com.hazelcast.internal.hotrestart.impl.SetOfKeyHandle;
import com.hazelcast.internal.hotrestart.impl.di.Inject;
import com.hazelcast.internal.hotrestart.impl.gc.ChunkManager;
import com.hazelcast.internal.hotrestart.impl.gc.GcHelper;
import com.hazelcast.internal.hotrestart.impl.gc.GcLogger;
import com.hazelcast.internal.hotrestart.impl.gc.chunk.Chunk;
import com.hazelcast.internal.hotrestart.impl.gc.chunk.GrowingChunk;
import com.hazelcast.internal.hotrestart.impl.gc.chunk.StableChunk;
import com.hazelcast.internal.hotrestart.impl.gc.chunk.StableTombChunk;
import com.hazelcast.internal.hotrestart.impl.gc.chunk.StableValChunk;
import com.hazelcast.internal.hotrestart.impl.gc.record.Record;
import com.hazelcast.internal.hotrestart.impl.gc.record.RecordMap;
import com.hazelcast.internal.hotrestart.impl.gc.tracker.Tracker;
import com.hazelcast.internal.hotrestart.impl.gc.tracker.TrackerMapBase;
import com.hazelcast.internal.util.collection.HsaHeapMemoryManager;
import com.hazelcast.internal.util.collection.Long2ObjectHashMap;
import com.hazelcast.internal.util.collection.LongSet;
import com.hazelcast.internal.util.collection.LongSetHsa;
import com.hazelcast.internal.util.counters.Counter;
import java.util.Map;

public class Rebuilder {
    private final ChunkManager cm;
    private final GcHelper gcHelper;
    private final GcLogger logger;
    private boolean isLoadingTombstones = true;
    private Counter occupancy;
    private Counter garbage;
    private Map<Long, SetOfKeyHandle> tombKeys;
    private Long2ObjectHashMap<RebuildingChunk> rebuildingChunks = new Long2ObjectHashMap(-1);
    private long maxSeq;
    private long maxChunkSeq;

    @Inject
    Rebuilder(ChunkManager cm, GcHelper gcHelper, GcLogger logger) {
        this.cm = cm;
        this.gcHelper = gcHelper;
        this.logger = logger;
        this.occupancy = cm.tombOccupancy;
        this.garbage = cm.tombGarbage;
    }

    public void setMaxSeq(long maxSeq) {
        this.maxSeq = maxSeq;
    }

    public long maxChunkSeq() {
        return this.maxChunkSeq;
    }

    public void startValuePhase(Map<Long, SetOfKeyHandle> tombKeys) {
        this.closeRebuildingChunks();
        this.rebuildingChunks.clear();
        this.tombKeys = tombKeys;
        this.isLoadingTombstones = false;
        this.occupancy = this.cm.valOccupancy;
        this.garbage = this.cm.valGarbage;
    }

    public void preAccept(long seq, int size) {
        this.occupancy.inc(size);
        if (seq > this.maxSeq) {
            this.maxSeq = seq;
        }
    }

    public void acceptCleared(RestartItem item) {
        RebuildingChunk chunk = this.rebuildingChunk(item.chunkSeq);
        chunk.acceptStale1(item.size);
        chunk.acceptClearedPrefix(item.prefix);
        this.garbage.inc(item.size);
    }

    public boolean accept(RestartItem item) {
        long chunkSeq = item.chunkSeq;
        long prefix = item.prefix;
        KeyHandle kh = item.keyHandle;
        long recordSeq = item.recordSeq;
        int filePos = item.filePos;
        int size = item.size;
        RebuildingChunk chunk = this.rebuildingChunk(chunkSeq);
        Tracker tr = this.cm.trackers.putIfAbsent(kh, chunk.seq, this.isLoadingTombstones);
        if (tr == null) {
            chunk.add(prefix, kh, recordSeq, filePos, size);
            return true;
        }
        Chunk chunkWithStale = this.chunk(tr.chunkSeq());
        Record stale = chunkWithStale.records.get(kh);
        if (recordSeq >= stale.liveSeq()) {
            (stale.isTombstone() ? this.cm.tombGarbage : this.cm.valGarbage).inc(stale.size());
            chunkWithStale.retire(kh, stale);
            chunk.add(prefix, kh, recordSeq, filePos, size);
            tr.newLiveRecord(chunk.seq, this.isLoadingTombstones, this.cm.trackers, true);
            if (!this.isLoadingTombstones) {
                this.removeFromTombKeys(prefix, kh);
            }
            return true;
        }
        this.garbage.inc(size);
        chunk.acceptStale1(size);
        chunk.acceptStale2(tr, prefix, kh, recordSeq, size);
        return false;
    }

    public void done() {
        this.closeRebuildingChunks();
        this.rebuildingChunks = null;
        TrackerMapBase trackerMap = (TrackerMapBase)this.cm.trackers;
        long tombstoneCount = 0L;
        long retiredCount = 0L;
        for (Map.Entry<Long, SetOfKeyHandle> e : this.tombKeys.entrySet()) {
            SetOfKeyHandle.KhCursor cursor = e.getValue().cursor();
            while (cursor.advance()) {
                KeyHandle kh = cursor.asKeyHandle();
                Tracker tr = trackerMap.get(kh);
                assert (tr.isAlive()) : "tr is dead";
                assert (tr.isTombstone()) : "tr is not a tombstone";
                if (tr.garbageCount() > 0L) {
                    ++tombstoneCount;
                    continue;
                }
                StableChunk chunk = this.cm.chunks.get(tr.chunkSeq());
                Record r = chunk.records.get(kh);
                trackerMap.removeLiveTombstone(kh);
                this.cm.tombGarbage.inc(r.size());
                chunk.retire(kh, r);
                ++retiredCount;
            }
        }
        this.logger.fine("Retired %,d tombstones, left %,d live ones. Record seq is %x", retiredCount, tombstoneCount, this.maxSeq);
        assert (tombstoneCount == trackerMap.liveTombstones.get());
        this.cm.updateMaxLive();
        this.gcHelper.initRecordSeq(this.maxSeq);
    }

    private Chunk chunk(long chunkSeq) {
        RebuildingChunk rebuildingChunk = this.rebuildingChunks.get(chunkSeq);
        return rebuildingChunk != null ? rebuildingChunk : (Chunk)this.cm.chunks.get(chunkSeq);
    }

    private RebuildingChunk rebuildingChunk(long chunkSeq) {
        RebuildingChunk chunk = this.rebuildingChunks.get(chunkSeq);
        return chunk != null ? chunk : this.startNewChunk(chunkSeq);
    }

    private RebuildingChunk startNewChunk(long seq) {
        if (seq > this.maxChunkSeq) {
            this.maxChunkSeq = seq;
        }
        RecordMap records = this.gcHelper.newRecordMap(false);
        RebuildingChunk chunk = this.isLoadingTombstones ? new RebuildingTombChunk(seq, records) : new RebuildingValChunk(seq, records);
        this.rebuildingChunks.put(seq, chunk);
        return chunk;
    }

    private void closeRebuildingChunks() {
        for (RebuildingChunk rebuildingChunk : this.rebuildingChunks.values()) {
            StableChunk stable = rebuildingChunk.toStableChunk();
            this.cm.chunks.put(stable.seq, stable);
        }
    }

    private void removeFromTombKeys(long prefix, KeyHandle kh) {
        SetOfKeyHandle khs = this.tombKeys.get(prefix);
        if (khs != null) {
            khs.remove(kh);
        }
    }

    private static final class RebuildingTombChunk
    extends RebuildingChunk {
        RebuildingTombChunk(long seq, RecordMap records) {
            super(seq, records);
        }

        @Override
        StableChunk toStableChunk() {
            return new StableTombChunk(this.seq, this.records, this.liveRecordCount, this.size(), this.garbage);
        }

        @Override
        public void insertOrUpdate(long recordSeq, long keyPrefix, KeyHandle kh, int filePos, int size) {
            this.insertOrUpdateTombstone(recordSeq, keyPrefix, kh, filePos, size);
        }

        @Override
        protected int determineSizeLimit() {
            return RebuildingTombChunk.tombChunkSizeLimit();
        }
    }

    private static final class RebuildingValChunk
    extends RebuildingChunk {
        private final LongSet clearedPrefixes = new LongSetHsa(0L, new HsaHeapMemoryManager());

        RebuildingValChunk(long seq, RecordMap records) {
            super(seq, records);
        }

        @Override
        StableChunk toStableChunk() {
            return new StableValChunk(this.seq, this.records, this.clearedPrefixes, this.liveRecordCount, this.size(), this.garbage, false);
        }

        @Override
        void acceptStale2(Tracker tr, long prefix, KeyHandle kh, long seq, int size) {
            Record sameKeyRecord = this.records.putIfAbsent(prefix, kh, -seq, size, false, 1);
            if (sameKeyRecord != null) {
                sameKeyRecord.incrementGarbageCount();
            }
            tr.incrementGarbageCount();
        }

        @Override
        void acceptClearedPrefix(long prefix) {
            this.clearedPrefixes.add(prefix);
        }

        @Override
        public void insertOrUpdate(long recordSeq, long keyPrefix, KeyHandle kh, int ignored, int size) {
            this.insertOrUpdateValue(recordSeq, keyPrefix, kh, size);
        }

        @Override
        protected int determineSizeLimit() {
            return RebuildingValChunk.valChunkSizeLimit();
        }
    }

    private static abstract class RebuildingChunk
    extends GrowingChunk {
        RebuildingChunk(long seq, RecordMap records) {
            super(seq, records);
        }

        final void add(long prefix, KeyHandle kh, long seq, int filePos, int size) {
            this.grow(size);
            this.addStep2(seq, prefix, kh, filePos, size);
        }

        abstract StableChunk toStableChunk();

        final void acceptStale1(int size) {
            this.grow(size);
            this.garbage += (long)size;
        }

        void acceptStale2(Tracker tr, long prefix, KeyHandle kh, long seq, int size) {
        }

        void acceptClearedPrefix(long prefix) {
        }
    }
}

