/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.hotrestart.impl;

import com.hazelcast.internal.hotrestart.KeyHandle;
import com.hazelcast.internal.hotrestart.RamStore;
import com.hazelcast.internal.hotrestart.impl.SetOfKeyHandle;
import com.hazelcast.internal.hotrestart.impl.io.ChunkFileRecord;

public class RestartItem {
    public static final RestartItem END = new WithSetOfKeyHandle(0L, null);
    private static final long RECORD_SEQ_CLEARED_ITEM = -1L;
    public final long chunkSeq;
    public final long recordSeq;
    public final long prefix;
    public final int filePos;
    public final int size;
    public final byte[] key;
    public final byte[] value;
    public RamStore ramStore;
    public KeyHandle keyHandle;

    RestartItem(ChunkFileRecord rec) {
        this.chunkSeq = rec.chunkSeq();
        this.recordSeq = rec.recordSeq();
        this.prefix = rec.prefix();
        this.filePos = rec.filePos();
        this.size = rec.size();
        this.key = rec.key();
        this.value = rec.value();
    }

    private RestartItem(long chunkSeq, long recordSeq, long prefix, int filePos, int size) {
        this.chunkSeq = chunkSeq;
        this.recordSeq = recordSeq;
        this.prefix = prefix;
        this.filePos = filePos;
        this.size = size;
        this.key = null;
        this.value = null;
    }

    public final boolean isSpecialItem() {
        return this.key == null;
    }

    public final boolean isClearedItem() {
        return this.recordSeq == -1L;
    }

    public static RestartItem clearedItem(ChunkFileRecord rec) {
        return new RestartItem(rec.chunkSeq(), -1L, rec.prefix(), rec.filePos(), rec.size());
    }

    public static class WithSetOfKeyHandle
    extends RestartItem {
        public final SetOfKeyHandle sokh;

        public WithSetOfKeyHandle(long prefix, SetOfKeyHandle sokh) {
            super(0L, 0L, prefix, 0, 0);
            this.sokh = sokh;
        }
    }
}

