/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.hotrestart.cluster;

import com.hazelcast.cluster.Address;
import com.hazelcast.internal.nio.IOUtil;
import java.io.BufferedInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;

abstract class AbstractMetadataReader {
    final File homeDir;

    AbstractMetadataReader(File homeDir) {
        this.homeDir = homeDir;
    }

    final void read() throws IOException {
        File file = new File(this.homeDir, this.getFilename());
        if (!file.exists()) {
            return;
        }
        DataInputStream in = null;
        try {
            in = new DataInputStream(new BufferedInputStream(new FileInputStream(file)));
            this.doRead(in);
            in.close();
        }
        catch (Throwable throwable) {
            IOUtil.closeResource(in);
            throw throwable;
        }
        IOUtil.closeResource(in);
    }

    abstract String getFilename();

    abstract void doRead(DataInput var1) throws IOException;

    static Address readAddress(DataInput in) throws IOException {
        return new Address(in.readUTF(), in.readInt());
    }
}

