/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.dynamicconfig.rewrite;

import com.hazelcast.com.ctc.wstx.stax.WstxInputFactory;
import com.hazelcast.core.HazelcastException;
import com.hazelcast.internal.dynamicconfig.rewrite.RewritePath;
import com.hazelcast.internal.dynamicconfig.rewrite.RewritePositionFinder;
import com.hazelcast.internal.util.XmlUtil;
import java.io.StringReader;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;

class RewritePositionFinderXml
extends RewritePositionFinder {
    private final RewritePath currentPath = new RewritePath();
    private int previousPosition;
    private int currentPosition;
    private boolean previousEventIsCharacters;
    private boolean currentEventIsCharacters;
    private boolean pathFound;
    private boolean getNextPosition;
    private int ignoreNextEndElement;

    RewritePositionFinderXml(String xmlDocumentAsString, RewritePath targetPath) {
        super(xmlDocumentAsString, targetPath);
    }

    @Override
    void setPositions() {
        try {
            this.traverse();
        }
        catch (XMLStreamException e) {
            throw new HazelcastException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void traverse() throws XMLStreamException {
        if (this.documentAsString.trim().length() == 0) {
            this.differencePath = new RewritePath(this.targetPath);
            this.differencePath.removeLastTypeSegment();
            RewritePath.checkPathOnlyContainsTypeSegments(this.differencePath);
            this.shouldTrim = true;
            return;
        }
        XMLInputFactory xmlInputFactory = XmlUtil.getProtectedFactory(new WstxInputFactory());
        try (XMLEventReader reader = null;){
            reader = xmlInputFactory.createXMLEventReader(new StringReader(this.documentAsString));
            while (reader.hasNext()) {
                XMLEvent nextEvent = reader.nextEvent();
                this.previousPosition = this.currentPosition;
                this.currentPosition = nextEvent.getLocation().getCharacterOffset();
                this.previousEventIsCharacters = this.currentEventIsCharacters;
                boolean bl = this.currentEventIsCharacters = nextEvent.getEventType() == 4;
                if (this.getNextPosition) {
                    this.endPosition = this.currentPosition;
                } else {
                    if (nextEvent.isStartElement()) {
                        this.handleStartElement(nextEvent);
                    }
                    if (!nextEvent.isEndElement() || !this.handleEndElement()) continue;
                }
                break;
            }
        }
    }

    private void handleStartElement(XMLEvent nextEvent) {
        StartElement startElement = nextEvent.asStartElement();
        this.currentPath.addTypeSegment(startElement.getName().getLocalPart());
        Attribute nameAttribute = startElement.getAttributeByName(QName.valueOf("name"));
        if (nameAttribute != null) {
            this.currentPath.addNameSegment(nameAttribute.getValue());
        }
        if (!this.targetPath.isChildOf(this.currentPath)) {
            ++this.ignoreNextEndElement;
        }
        if (this.currentPath.equals(this.targetPath)) {
            this.startPosition = this.currentPosition;
            this.shouldTrim = true;
            this.pathFound = true;
        }
    }

    private boolean handleEndElement() {
        boolean breakLoop = false;
        if (this.ignoreNextEndElement > 0) {
            --this.ignoreNextEndElement;
        } else {
            if (this.pathFound) {
                this.getNextPosition = true;
            } else {
                this.endPosition = this.startPosition = this.findPositionIfPathNotFound();
                breakLoop = true;
            }
            this.differencePath = this.targetPath.calculateDifferenceToExtendForXml(this.currentPath);
        }
        this.currentPath.removeLastTypeSegment();
        return breakLoop;
    }

    private int findPositionIfPathNotFound() {
        if (this.previousEventIsCharacters) {
            return this.previousPosition;
        }
        this.shouldTrim = true;
        return this.currentPosition;
    }
}

