/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.dynamicconfig;

import com.hazelcast.config.CacheSimpleConfig;
import com.hazelcast.config.MapConfig;
import com.hazelcast.internal.dynamicconfig.ClusterWideConfigurationService;
import com.hazelcast.internal.dynamicconfig.ConfigCheckMode;
import com.hazelcast.internal.dynamicconfig.DynamicConfigListener;
import com.hazelcast.internal.hotrestart.HotRestartIntegrationService;
import com.hazelcast.internal.hotrestart.LoadedConfigurationListener;

public class HotRestartConfigListener
implements DynamicConfigListener {
    private final HotRestartIntegrationService hotRestartIntegrationService;

    public HotRestartConfigListener(HotRestartIntegrationService hotRestartIntegrationService) {
        this.hotRestartIntegrationService = hotRestartIntegrationService;
    }

    @Override
    public void onServiceInitialized(final ClusterWideConfigurationService configurationService) {
        this.hotRestartIntegrationService.registerLoadedConfigurationListener(new LoadedConfigurationListener(){

            @Override
            public void onConfigurationLoaded(String serviceName, String name, Object config) {
                if ("hz:impl:mapService".equals(serviceName)) {
                    MapConfig mapConfig = (MapConfig)config;
                    configurationService.registerConfigLocally(mapConfig, ConfigCheckMode.WARNING);
                }
            }
        });
    }

    @Override
    public void onConfigRegistered(MapConfig configObject) {
        if (configObject.getHotRestartConfig().isEnabled()) {
            this.hotRestartIntegrationService.ensureHasConfiguration("hz:impl:mapService", configObject.getName(), configObject);
        }
    }

    @Override
    public void onConfigRegistered(CacheSimpleConfig configObject) {
        if (configObject.getHotRestartConfig().isEnabled()) {
            this.hotRestartIntegrationService.ensureHasConfiguration("hz:impl:cacheService", configObject.getName(), configObject);
        }
    }
}

