/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.bplustree;

import com.hazelcast.internal.bplustree.BPlusTreeKeyAccessor;
import com.hazelcast.internal.bplustree.BPlusTreeKeyComparator;
import com.hazelcast.internal.bplustree.CompositeKeyComparison;
import com.hazelcast.internal.bplustree.EntrySlotPayload;
import com.hazelcast.internal.bplustree.HDBPlusTree;
import com.hazelcast.internal.bplustree.LockManager;
import com.hazelcast.internal.bplustree.LockingContext;
import com.hazelcast.internal.bplustree.NodeSplitStrategy;
import com.hazelcast.internal.memory.GlobalMemoryAccessorRegistry;
import com.hazelcast.internal.memory.MemoryAllocator;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.internal.serialization.EnterpriseSerializationService;
import com.hazelcast.internal.serialization.impl.NativeMemoryData;

abstract class HDBTreeNodeBaseAccessor {
    static final int OFFSET_LOCK_STATE = 0;
    static final int OFFSET_SEQUENCE_NUMBER = 8;
    static final int OFFSET_LEVEL = 16;
    static final int OFFSET_KEYS_COUNT = 17;
    static final int OFFSET_STATS = 19;
    static final int OFFSET_NODE_BASE_DATA = 20;
    static final int OFFSET_NODE_CONTENT = 16;
    static final byte STATS_PAYLOAD_MASK = 1;
    static final int SLOT_ENTRY_OFFSET_BYTE_LENGTH = 2;
    static final int PAYLOAD_BYTE_LENGTH = 8;
    static final int CHILD_OR_VALUE_ADDRESS_BYTE_LENGTH = 8;
    static final int MAX_LEVEL = 255;
    static final int MAX_NODE_SIZE = 1048575;
    static final int MIN_NODE_SIZE = 128;
    final LockManager lockManager;
    final EnterpriseSerializationService ess;
    final BPlusTreeKeyComparator keyComparator;
    final BPlusTreeKeyAccessor keyAccessor;
    final MemoryAllocator keyAllocator;
    final MemoryAllocator btreeAllocator;
    final int nodeSize;
    final EntrySlotPayload entrySlotPayload;
    final boolean isPayloadSet;
    NodeSplitStrategy nodeSplitStrategy;

    HDBTreeNodeBaseAccessor(LockManager lockManager, EnterpriseSerializationService ess, BPlusTreeKeyComparator keyComparator, BPlusTreeKeyAccessor keyAccessor, MemoryAllocator keyAllocator, MemoryAllocator btreeAllocator, int nodeSize, NodeSplitStrategy nodeSplitStrategy, EntrySlotPayload entrySlotPayload) {
        this.lockManager = lockManager;
        this.ess = ess;
        this.keyComparator = keyComparator;
        this.keyAccessor = keyAccessor;
        this.keyAllocator = keyAllocator;
        this.btreeAllocator = btreeAllocator;
        this.nodeSize = nodeSize;
        this.nodeSplitStrategy = nodeSplitStrategy;
        this.entrySlotPayload = entrySlotPayload;
        this.isPayloadSet = entrySlotPayload.getPayloadSize() > 0;
    }

    int getKeyPartition(Data key) {
        return 0;
    }

    void allocateLogical(long stableAddress) {
    }

    boolean isAllocated(long stableAddress) {
        return true;
    }

    long translateToLogical(long stableAddress) {
        return stableAddress;
    }

    long translateToPhysical(long stableAddress) {
        return stableAddress;
    }

    boolean requiresUnlockBeforeNodeDisposal() {
        return true;
    }

    long tryLockRecord(int partition, long keyHash) {
        return 1L;
    }

    void yield(int partition) {
    }

    void waitUntilRecordUnlocked(int partition, long keyHash, long cookie) {
    }

    void unlockRecord(int partition, long keyHash, long cookie) {
    }

    void pinAndReplaceLastUnpinned(long stableAddress, LockingContext lockingContext) {
    }

    void unpinIfNotLastUnpinned(long stableAddress, LockingContext lockingContext) {
    }

    void unpin(long stableAddress) {
    }

    void ensureReadable(long stableAddress) {
    }

    void ensureWritable(long stableAddress) {
    }

    void upgradeToWritable(long stableAddress, LockingContext lockingContext) {
    }

    long newNodeLocked(LockingContext lockingContext) {
        long address = this.getBtreeAllocator().allocate(this.nodeSize);
        long lockAddr = this.getLockStateAddr(address);
        this.lockManager.writeLock(lockAddr);
        lockingContext.addLock(lockAddr);
        this.pinAndReplaceLastUnpinned(-address, lockingContext);
        this.allocateLogical(address);
        this.setNodeLevel(address, 0);
        this.setKeysCount(address, 0);
        this.setStatsPayloadMask(address);
        return address;
    }

    private void setStatsPayloadMask(long nodeAddr) {
        if (!this.isPayloadSet) {
            return;
        }
        byte mask = this.getStats(nodeAddr);
        mask = (byte)(mask | 1);
        this.setStats(nodeAddr, mask);
    }

    void disposeNode(long nodeAddr) {
        if (nodeAddr != 0L) {
            this.getBtreeAllocator().free(nodeAddr, this.nodeSize);
        }
    }

    abstract int getOffsetEntries();

    abstract long split(long var1, LockingContext var3);

    abstract int getSeparationSlot(long var1);

    void setNodeSplitStrategy(NodeSplitStrategy strategy) {
        this.nodeSplitStrategy = strategy;
    }

    byte getStats(long nodeAddr) {
        return GlobalMemoryAccessorRegistry.AMEM.getByte(this.translateToPhysical(nodeAddr) + 19L);
    }

    void setStats(long nodeAddr, byte stats) {
        GlobalMemoryAccessorRegistry.AMEM.putByte(this.translateToPhysical(nodeAddr) + 19L, stats);
    }

    long getLockStateAddr(long nodeAddr) {
        return this.translateToPhysical(nodeAddr) + 0L;
    }

    long getLockState(long nodeAddr) {
        return GlobalMemoryAccessorRegistry.AMEM.getLong(this.getLockStateAddr(nodeAddr));
    }

    int getNodeLevel(long nodeAddr) {
        return GlobalMemoryAccessorRegistry.AMEM.getByte(this.translateToPhysical(nodeAddr) + 16L) & 0xFF;
    }

    void setNodeLevel(long nodeAddr, int level) {
        GlobalMemoryAccessorRegistry.AMEM.putByte(this.translateToPhysical(nodeAddr) + 16L, (byte)level);
    }

    boolean isInnerNode(long nodeAddr) {
        return this.getNodeLevel(nodeAddr) > 0;
    }

    int getKeysCount(long nodeAddr) {
        return GlobalMemoryAccessorRegistry.AMEM.getShort(this.translateToPhysical(nodeAddr) + 17L);
    }

    void setKeysCount(long nodeAddr, int count) {
        GlobalMemoryAccessorRegistry.AMEM.putShort(this.translateToPhysical(nodeAddr) + 17L, (short)count);
    }

    int spaceNeeded(NativeMemoryData indexKey, NativeMemoryData entryKey) {
        return this.memoryNeededForSlotEntry(indexKey, entryKey) + 2;
    }

    int spaceNeeded(long nodeAddr, int slot) {
        int keysCount = this.getKeysCount(nodeAddr);
        assert (slot < keysCount);
        long slotAddr = this.getSlotAddr(nodeAddr, slot);
        long entryKeyAddr = this.getEntryKeyAddr(nodeAddr, slot);
        return (int)(entryKeyAddr + (long)this.readSize(entryKeyAddr) - slotAddr) + 2;
    }

    boolean isNodeFull(long nodeAddr, NativeMemoryData indexKey, NativeMemoryData entryKey) {
        int keysCount = this.getKeysCount(nodeAddr);
        if (keysCount == 0) {
            return false;
        }
        int spaceNeeded = this.memoryNeededForSlotEntry(indexKey, entryKey) + 2;
        return !this.canAccommodate(nodeAddr, spaceNeeded);
    }

    int freeSpace(long nodeAddr) {
        int lastSlot = this.getLastSlot(nodeAddr);
        if (lastSlot == -1) {
            return this.nodeSize - this.getOffsetEntries();
        }
        int freeSpace = (int)(this.getSlotEntryOffsetAddr(nodeAddr, 0) - this.freeSpaceBeginAddr(nodeAddr));
        assert (freeSpace <= this.nodeSize) : "freeSpace=" + freeSpace;
        return freeSpace;
    }

    abstract long freeSpaceBeginAddr(long var1);

    boolean canAccommodate(long dstNodeAddr, int size) {
        return this.freeSpace(dstNodeAddr) >= size;
    }

    long getSequenceNumber(long nodeAddr) {
        return GlobalMemoryAccessorRegistry.AMEM.getLong(this.translateToPhysical(nodeAddr) + 8L);
    }

    void setSequenceCounter(long nodeAddr, long value) {
        GlobalMemoryAccessorRegistry.AMEM.putLong(this.translateToPhysical(nodeAddr) + 8L, value);
    }

    void incSequenceCounter(long nodeAddr) {
        long sequenceNumber = this.getSequenceNumber(nodeAddr);
        this.setSequenceCounter(nodeAddr, sequenceNumber + 1L);
    }

    Data getIndexKeyHeapData(long nodeAddr, int slot) {
        long indexKeyAddr = this.getIndexKeyAddr(nodeAddr, slot);
        return this.keyAccessor.convertToHeapData(indexKeyAddr);
    }

    Data getIndexKeyHeapDataOrNull(long nodeAddr, int slot) {
        long indexKeyAddr = this.getIndexKeyAddr(nodeAddr, slot);
        if (indexKeyAddr == 0L) {
            return null;
        }
        return this.keyAccessor.convertToHeapData(indexKeyAddr);
    }

    long getIndexKeyAddr(long nodeAddr, int slot) {
        long indexKeyAddr = this.getSlotAddr(nodeAddr, slot) + 8L;
        if (this.isPayloadSet) {
            indexKeyAddr += 8L;
        }
        return indexKeyAddr;
    }

    NativeMemoryData getEntryKey(long nodeAddr, int slot) {
        return new NativeMemoryData().reset(this.getEntryKeyAddr(nodeAddr, slot));
    }

    long getEntryKeyAddr(long nodeAddr, int slot) {
        long indexKeyAddr = this.getIndexKeyAddr(nodeAddr, slot);
        return indexKeyAddr + (long)this.readSize(indexKeyAddr);
    }

    abstract void removeLastKSlotEntries(long var1, int var3);

    void insertSlot(long nodeAddr, int slot, NativeMemoryData indexKey, NativeMemoryData entryKey, long valueOrChildAddr) {
        long memCpyEndAddr;
        int lastSlot = this.getLastSlot(nodeAddr);
        if (lastSlot == -1) {
            this.writeSlotEntryContents(this.freeSpaceBeginAddr(nodeAddr), indexKey, entryKey, valueOrChildAddr);
            this.setKeysCount(nodeAddr, this.getKeysCount(nodeAddr) + 1);
            this.setSlotEntryOffset(nodeAddr, 0, 0);
            return;
        }
        int memoryNeeded = this.memoryNeededForSlotEntry(indexKey, entryKey);
        assert (this.freeSpace(nodeAddr) >= memoryNeeded + 2);
        long memCpyStartAddr = memCpyEndAddr = this.freeSpaceBeginAddr(nodeAddr);
        if (slot <= lastSlot) {
            memCpyStartAddr = this.getSlotAddr(nodeAddr, slot);
            assert (memCpyStartAddr <= memCpyEndAddr) : "lastSlot=" + lastSlot + ", slot=" + slot;
            GlobalMemoryAccessorRegistry.AMEM.copyMemory(memCpyStartAddr, memCpyStartAddr + (long)memoryNeeded, memCpyEndAddr - memCpyStartAddr);
            this.updateSlotOffsets(nodeAddr, slot, lastSlot, memoryNeeded);
        }
        this.insertToOffsetArr(nodeAddr, slot);
        this.writeSlotEntryContents(memCpyStartAddr, indexKey, entryKey, valueOrChildAddr);
        this.setKeysCount(nodeAddr, this.getKeysCount(nodeAddr) + 1);
        this.setSlotEntryOffset(nodeAddr, slot, (int)(memCpyStartAddr - (this.translateToPhysical(nodeAddr) + (long)this.getOffsetEntries())));
    }

    void removeSlot(long nodeAddr, int slot) {
        int lastSlot = this.getLastSlot(nodeAddr);
        if (this.isInnerNode(nodeAddr) ? !$assertionsDisabled && lastSlot <= 0 : !$assertionsDisabled && lastSlot < 0) {
            throw new AssertionError();
        }
        if (lastSlot == 0) {
            assert (slot == lastSlot) : "trying to remove slot=" + slot + " whereas, lastSlot" + lastSlot;
            this.setKeysCount(nodeAddr, 0);
            return;
        }
        if (slot < lastSlot) {
            long memCpyStartAddr = this.getSlotAddr(nodeAddr, slot + 1);
            long memCpyEndAddr = this.freeSpaceBeginAddr(nodeAddr);
            int shift = (int)(this.getSlotAddr(nodeAddr, slot) - memCpyStartAddr);
            GlobalMemoryAccessorRegistry.AMEM.copyMemory(memCpyStartAddr, memCpyStartAddr + (long)shift, memCpyEndAddr - memCpyStartAddr);
            this.updateSlotOffsets(nodeAddr, slot + 1, lastSlot, shift);
        }
        if (slot != 0) {
            long zerosSlotEntryOffsetAddr = this.getSlotEntryOffsetAddr(nodeAddr, 0);
            GlobalMemoryAccessorRegistry.AMEM.copyMemory(zerosSlotEntryOffsetAddr, zerosSlotEntryOffsetAddr + 2L, (long)slot * 2L);
        }
        this.setKeysCount(nodeAddr, this.getKeysCount(nodeAddr) - 1);
    }

    private void updateSlotOffsets(long nodeAddr, int startSlot, int endSlotInclusive, int deltaToAdd) {
        for (int i = startSlot; i <= endSlotInclusive; ++i) {
            int offset = this.getSlotEntryOffset(nodeAddr, i);
            this.setSlotEntryOffset(nodeAddr, i, offset + deltaToAdd);
        }
    }

    private void insertToOffsetArr(long nodeAddr, int slot) {
        int lastSlot = this.getLastSlot(nodeAddr);
        if (lastSlot == -1 || slot == 0) {
            return;
        }
        long zerosSlotEntryOffsetAddr = this.getSlotEntryOffsetAddr(nodeAddr, 0);
        long prevSlotEntryOffsetAddr = this.getSlotEntryOffsetAddr(nodeAddr, slot - 1);
        GlobalMemoryAccessorRegistry.AMEM.copyMemory(zerosSlotEntryOffsetAddr, zerosSlotEntryOffsetAddr - 2L, prevSlotEntryOffsetAddr - zerosSlotEntryOffsetAddr + 2L);
    }

    abstract int getLastSlot(long var1);

    private int memoryNeededForSlotEntry(NativeMemoryData indexKey, NativeMemoryData entryKey) {
        return 8 + (this.isPayloadSet ? 8 : 0) + indexKey.size() + entryKey.size();
    }

    private void writeSlotEntryContents(long slotAddr, NativeMemoryData indexKey, NativeMemoryData entryKey, long valueOrChildAddr) {
        long writeAddr = slotAddr;
        GlobalMemoryAccessorRegistry.AMEM.putLong(writeAddr, valueOrChildAddr);
        writeAddr += 8L;
        if (this.isPayloadSet) {
            this.entrySlotPayload.setPayload(writeAddr, indexKey.address());
            writeAddr += 8L;
        }
        indexKey.copyTo(0L, null, writeAddr, indexKey.size());
        entryKey.copyTo(0L, null, writeAddr += (long)indexKey.size(), entryKey.size());
    }

    int readSize(long address) {
        assert (address > 0L);
        int size = GlobalMemoryAccessorRegistry.MEM.getInt(address) + 4;
        assert (size > 0 && size < this.nodeSize) : "size=" + size;
        return size;
    }

    Data getValue(long nodeAddr, int slot, int partition, Data entryKey) {
        long valueAddr = this.getValueAddr(nodeAddr, slot);
        return new NativeMemoryData(valueAddr, this.readSize(valueAddr));
    }

    long getValueAddr(long nodeAddr, int slot) {
        long slotAddr = this.getSlotAddr(nodeAddr, slot);
        return GlobalMemoryAccessorRegistry.AMEM.getLong(slotAddr);
    }

    long getPayloadOrZero(long nodeAddr, int slot) {
        if (!this.isPayloadSet) {
            return 0L;
        }
        long payloadAddr = this.getSlotAddr(nodeAddr, slot) + 8L;
        return this.entrySlotPayload.getPayload(payloadAddr);
    }

    void setValueAddr(long nodeAddr, int slot, long valueAddr) {
        GlobalMemoryAccessorRegistry.AMEM.putLong(this.getSlotAddr(nodeAddr, slot), valueAddr);
    }

    CompositeKeyComparison compareKeys(Comparable leftIndexKey, Data leftEntryKey, long nodeAddr, int slot) {
        return this.compareKeys(leftIndexKey, leftEntryKey, nodeAddr, slot, false);
    }

    CompositeKeyComparison compareKeys(Comparable leftIndexKey, Data leftEntryKey, long nodeAddr, int slot, boolean cmpOnlyIndexKeyPart) {
        long rightPayload;
        long rightIndexKeyAddr = this.getIndexKeyAddr(nodeAddr, slot);
        int cmp = this.keyComparator.compare(leftIndexKey, rightIndexKeyAddr, rightPayload = this.getPayloadOrZero(nodeAddr, slot));
        if (cmp == 0 && !cmpOnlyIndexKeyPart) {
            if (leftEntryKey == HDBPlusTree.PLUS_INFINITY_ENTRY_KEY) {
                return CompositeKeyComparison.INDEX_KEY_EQUAL_ENTRY_KEY_GREATER;
            }
            if (leftEntryKey == HDBPlusTree.MINUS_INFINITY_ENTRY_KEY) {
                return CompositeKeyComparison.INDEX_KEY_EQUAL_ENTRY_KEY_LESS;
            }
            long rightEntryKeyAddr = this.getEntryKeyAddr(nodeAddr, slot);
            if (rightEntryKeyAddr == 0L) {
                return leftEntryKey == null ? CompositeKeyComparison.KEYS_EQUAL : CompositeKeyComparison.INDEX_KEY_EQUAL_ENTRY_KEY_GREATER;
            }
            if (leftEntryKey == null) {
                return CompositeKeyComparison.INDEX_KEY_EQUAL_ENTRY_KEY_LESS;
            }
            NativeMemoryData rightEntryKey = this.getEntryKey(nodeAddr, slot);
            int cmp2 = this.keyComparator.compareSerializedKeys(leftEntryKey, rightEntryKey);
            return cmp2 < 0 ? CompositeKeyComparison.INDEX_KEY_EQUAL_ENTRY_KEY_LESS : (cmp2 == 0 ? CompositeKeyComparison.KEYS_EQUAL : CompositeKeyComparison.INDEX_KEY_EQUAL_ENTRY_KEY_GREATER);
        }
        return cmp < 0 ? CompositeKeyComparison.INDEX_KEY_LESS : (cmp == 0 ? CompositeKeyComparison.KEYS_EQUAL : CompositeKeyComparison.INDEX_KEY_GREATER);
    }

    int lowerBound(long nodeAddr, Comparable indexKey, Data entryKey) {
        int mid;
        assert (indexKey != null);
        int lower = 0;
        int upper = this.getKeysCount(nodeAddr) - 1;
        while (true) {
            if (upper < lower) {
                return lower;
            }
            mid = (upper + lower) / 2;
            CompositeKeyComparison cmp = this.compareKeys(indexKey, entryKey, nodeAddr, mid);
            if (CompositeKeyComparison.less(cmp)) {
                upper = mid - 1;
                continue;
            }
            if (!CompositeKeyComparison.greater(cmp)) break;
            lower = mid + 1;
        }
        return mid;
    }

    long getSlotAddr(long nodeAddr, int slot) {
        return this.translateToPhysical(nodeAddr) + (long)this.getOffsetEntries() + (long)this.getSlotEntryOffset(nodeAddr, slot);
    }

    void setSlotEntryOffset(long nodeAddr, int slot, int offset) {
        GlobalMemoryAccessorRegistry.AMEM.putShort(this.getSlotEntryOffsetAddr(nodeAddr, slot), (short)offset);
    }

    int getSlotEntryOffset(long nodeAddr, int slot) {
        return GlobalMemoryAccessorRegistry.AMEM.getShort(this.getSlotEntryOffsetAddr(nodeAddr, slot)) & 0xFFFF;
    }

    long getSlotEntryOffsetAddr(long nodeAddr, int slot) {
        int lastSlot = this.getLastSlot(nodeAddr);
        return this.translateToPhysical(nodeAddr) + (long)this.nodeSize - (long)(lastSlot - slot + 1) * 2L;
    }

    void copyNodeContent(long srcNodeAddr, long destNodeAddr) {
        long contentSize = this.nodeSize - 16;
        GlobalMemoryAccessorRegistry.AMEM.copyMemory(this.translateToPhysical(srcNodeAddr) + 16L, this.translateToPhysical(destNodeAddr) + 16L, contentSize);
    }

    MemoryAllocator getKeyAllocator() {
        return this.keyAllocator;
    }

    MemoryAllocator getBtreeAllocator() {
        return this.btreeAllocator;
    }

    long nodeFromLock(long lockAddr) {
        return lockAddr - 0L;
    }

    void beforeOperation() {
    }

    void afterOperation(LockingContext lockingContext) {
    }

    void beforeLock() {
    }

    void afterLock() {
    }

    void beforePartitionOperation(int partitionId, LockingContext lockingContext) {
    }
}

