/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.bplustree;

import com.hazelcast.internal.bplustree.BPlusTreeKeyAccessor;
import com.hazelcast.internal.bplustree.BPlusTreeKeyComparator;
import com.hazelcast.internal.bplustree.EntrySlotPayload;
import com.hazelcast.internal.bplustree.HDBTreeNodeBaseAccessor;
import com.hazelcast.internal.bplustree.LockManager;
import com.hazelcast.internal.bplustree.LockingContext;
import com.hazelcast.internal.bplustree.NodeSplitStrategy;
import com.hazelcast.internal.memory.GlobalMemoryAccessorRegistry;
import com.hazelcast.internal.memory.MemoryAllocator;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.internal.serialization.EnterpriseSerializationService;
import com.hazelcast.internal.serialization.impl.NativeMemoryData;

class HDBTreeInnerNodeAccessor
extends HDBTreeNodeBaseAccessor {
    static final NativeMemoryData EMPTY_INDEX_KEY;
    static final NativeMemoryData EMPTY_ENTRY_KEY;

    HDBTreeInnerNodeAccessor(LockManager lockManager, EnterpriseSerializationService ess, BPlusTreeKeyComparator keyComparator, BPlusTreeKeyAccessor keyAccessor, MemoryAllocator keyAllocator, MemoryAllocator btreeAllocator, int nodeSize, NodeSplitStrategy nodeSplitStrategy, EntrySlotPayload entrySlotPayload) {
        super(lockManager, ess, keyComparator, keyAccessor, keyAllocator, btreeAllocator, nodeSize, nodeSplitStrategy, entrySlotPayload);
    }

    @Override
    int getOffsetEntries() {
        return 20;
    }

    long getChildNode(long nodeAddr, Comparable indexKey, Data entryKey) {
        int slot = this.lowerBound(nodeAddr, indexKey, entryKey);
        return this.getValueAddr(nodeAddr, slot);
    }

    @Override
    long split(long nodeAddr, LockingContext lockingContext) {
        int level = this.getNodeLevel(nodeAddr);
        assert (level > 0);
        long newInnerAddr = this.newNodeLocked(lockingContext);
        int keysCount = this.getKeysCount(nodeAddr);
        int newInnerKeysCount = this.nodeSplitStrategy.getNewNodeKeysCount(keysCount);
        int startSlot = keysCount - newInnerKeysCount;
        long memCpyStartAddr = this.getSlotAddr(nodeAddr, startSlot);
        long memCpyEndAddr = this.freeSpaceBeginAddr(nodeAddr);
        assert (memCpyStartAddr <= memCpyEndAddr);
        GlobalMemoryAccessorRegistry.AMEM.copyMemory(memCpyStartAddr, this.translateToPhysical(newInnerAddr) + (long)this.getOffsetEntries(), memCpyEndAddr - memCpyStartAddr);
        this.setKeysCount(newInnerAddr, newInnerKeysCount);
        this.setNodeLevel(newInnerAddr, level);
        long startSlotEntryOffset = this.getSlotEntryOffset(nodeAddr, startSlot);
        for (int slot = 0; slot <= newInnerKeysCount; ++slot) {
            this.setSlotEntryOffset(newInnerAddr, slot, (short)((long)this.getSlotEntryOffset(nodeAddr, startSlot + slot) - startSlotEntryOffset));
        }
        this.removeLastKSlotEntries(nodeAddr, newInnerKeysCount + 1);
        this.incSequenceCounter(nodeAddr);
        this.incSequenceCounter(newInnerAddr);
        return newInnerAddr;
    }

    @Override
    void removeLastKSlotEntries(long nodeAddr, int k) {
        int lastSlot = this.getLastSlot(nodeAddr);
        assert (k <= lastSlot + 1);
        if (k <= lastSlot) {
            long zerosSlotEntryOffsetAddr = this.getSlotEntryOffsetAddr(nodeAddr, 0);
            int shift = k * 2;
            GlobalMemoryAccessorRegistry.AMEM.copyMemory(zerosSlotEntryOffsetAddr, zerosSlotEntryOffsetAddr + (long)shift, (long)(lastSlot - k + 1) * 2L);
        }
        this.setKeysCount(nodeAddr, this.getKeysCount(nodeAddr) - k);
    }

    @Override
    int getSeparationSlot(long nodeAddr) {
        int keysCount = this.getKeysCount(nodeAddr);
        assert (keysCount >= 2);
        return keysCount - this.nodeSplitStrategy.getNewNodeKeysCount(keysCount) - 1;
    }

    void insertToEmptyNode(long nodeAddr, long childAddr) {
        assert (this.getKeysCount(nodeAddr) == 0);
        this.setKeysCount(nodeAddr, -1);
        this.insertSlot(nodeAddr, 0, EMPTY_INDEX_KEY, EMPTY_ENTRY_KEY, childAddr);
        this.incSequenceCounter(nodeAddr);
        assert (this.getKeysCount(nodeAddr) == 0);
    }

    int insert(long nodeAddr, long indexKeyAddr, long entryKeyAddr, long childAddr) {
        NativeMemoryData entryKeyData = new NativeMemoryData().reset(entryKeyAddr);
        Comparable indexKey = this.keyAccessor.convertToObject(indexKeyAddr);
        Comparable wrappedIndexKey = this.keyComparator.wrapIndexKey(indexKey);
        int slot = this.lowerBound(nodeAddr, wrappedIndexKey, entryKeyData);
        this.insertSlot(nodeAddr, slot, new NativeMemoryData().reset(indexKeyAddr), entryKeyData, childAddr);
        this.setValueAddr(nodeAddr, slot, this.getValueAddr(nodeAddr, slot + 1));
        this.setValueAddr(nodeAddr, slot + 1, childAddr);
        this.incSequenceCounter(nodeAddr);
        return slot;
    }

    void remove(long nodeAddr, Comparable indexKey, NativeMemoryData entryKey) {
        int keysCount = this.getKeysCount(nodeAddr);
        assert (this.getNodeLevel(nodeAddr) >= 1);
        assert (keysCount >= 1);
        int slot = this.lowerBound(nodeAddr, indexKey, entryKey);
        assert (slot <= keysCount) : "slot=" + slot + ", keysCount=" + keysCount;
        int slotToRemove = slot;
        if (slot == keysCount) {
            this.setValueAddr(nodeAddr, slot, this.getValueAddr(nodeAddr, slot - 1));
            slotToRemove = slot - 1;
        }
        this.removeSlot(nodeAddr, slotToRemove);
        this.incSequenceCounter(nodeAddr);
        assert (this.getValueAddr(nodeAddr, 0) != 0L);
    }

    @Override
    long freeSpaceBeginAddr(long nodeAddr) {
        assert (this.getNodeLevel(nodeAddr) > 0);
        int lastSlot = this.getLastSlot(nodeAddr);
        if (lastSlot == -1) {
            return this.translateToPhysical(nodeAddr) + (long)this.getOffsetEntries();
        }
        return this.getSlotAddr(nodeAddr, lastSlot) + 8L;
    }

    @Override
    int getLastSlot(long nodeAddr) {
        assert (this.getNodeLevel(nodeAddr) > 0);
        return this.getKeysCount(nodeAddr);
    }

    boolean isSplittable(long nodeAddr) {
        return this.getKeysCount(nodeAddr) >= 2;
    }

    static {
        EMPTY_ENTRY_KEY = EMPTY_INDEX_KEY = new NativeMemoryData();
    }
}

