/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.cache.impl.operation;

import com.hazelcast.cache.impl.CacheService;
import com.hazelcast.cache.impl.EnterpriseCachePartitionSegment;
import com.hazelcast.cache.impl.ICacheRecordStore;
import com.hazelcast.internal.serialization.SerializationService;
import com.hazelcast.internal.util.ThreadUtil;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.spi.impl.AllowedDuringPassiveState;
import com.hazelcast.spi.impl.NodeEngine;
import com.hazelcast.spi.impl.operationservice.AbstractNamedOperation;
import com.hazelcast.wan.impl.merkletree.MerkleTree;
import java.io.IOException;

public class CacheMerkleTreeRebuildOperation
extends AbstractNamedOperation
implements IdentifiedDataSerializable,
AllowedDuringPassiveState {
    public CacheMerkleTreeRebuildOperation() {
    }

    public CacheMerkleTreeRebuildOperation(String cacheName) {
        super(cacheName);
    }

    @Override
    public void run() {
        ThreadUtil.assertRunningOnPartitionThread();
        int partitionId = this.getPartitionId();
        MerkleTree merkleTree = this.getMerkleTree(this.name, partitionId);
        merkleTree.clear();
        NodeEngine nodeEngine = this.getNodeEngine();
        CacheService service = (CacheService)nodeEngine.getService("hz:impl:cacheService");
        SerializationService serializationService = nodeEngine.getSerializationService();
        ICacheRecordStore recordStore = service.getOrCreateRecordStore(this.name, partitionId);
        recordStore.getReadOnlyRecords().forEach((dataKey, cacheRecord) -> merkleTree.updateAdd(dataKey, serializationService.toData(cacheRecord.getValue())));
    }

    private MerkleTree getMerkleTree(String cacheName, int partitionId) {
        CacheService cacheService = (CacheService)this.getService();
        EnterpriseCachePartitionSegment segment = (EnterpriseCachePartitionSegment)cacheService.getSegment(partitionId);
        return segment.getMerkleTree(cacheName);
    }

    @Override
    public int getFactoryId() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getClassId() {
        throw new UnsupportedOperationException();
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        throw new UnsupportedOperationException();
    }
}

