/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.cache.impl.hidensity.operation;

import com.hazelcast.cache.CacheNotExistsException;
import com.hazelcast.cache.impl.EnterpriseCacheService;
import com.hazelcast.cache.impl.ICacheRecordStore;
import com.hazelcast.cache.impl.hidensity.HiDensityCacheRecord;
import com.hazelcast.cache.impl.hidensity.HiDensityCacheRecordStore;
import com.hazelcast.cache.impl.hidensity.operation.HiDensityCacheDataSerializerHook;
import com.hazelcast.cache.impl.hidensity.operation.HiDensityCacheOperation;
import com.hazelcast.cache.impl.operation.CacheReplicationOperation;
import com.hazelcast.internal.nio.IOUtil;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.internal.serialization.EnterpriseSerializationService;
import com.hazelcast.internal.serialization.impl.NativeMemoryData;
import com.hazelcast.internal.util.Clock;
import com.hazelcast.logging.ILogger;
import com.hazelcast.memory.NativeOutOfMemoryError;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public final class HiDensityCacheReplicationOperation
extends CacheReplicationOperation
implements IdentifiedDataSerializable {
    private final Map<String, Map<Data, HiDensityCacheRecord>> source = new HashMap<String, Map<Data, HiDensityCacheRecord>>();
    private final Map<String, Map<Data, CacheRecordHolder>> destination = new HashMap<String, Map<Data, CacheRecordHolder>>();
    private transient NativeOutOfMemoryError oome;

    @Override
    protected void storeRecordsToReplicate(ICacheRecordStore recordStore) {
        if (recordStore instanceof HiDensityCacheRecordStore) {
            this.source.put(recordStore.getName(), recordStore.getReadOnlyRecords());
        } else {
            super.storeRecordsToReplicate(recordStore);
        }
    }

    private void dispose() {
        EnterpriseSerializationService ss = (EnterpriseSerializationService)this.getNodeEngine().getSerializationService();
        for (Map.Entry<String, Map<Data, CacheRecordHolder>> entry : this.destination.entrySet()) {
            Map<Data, CacheRecordHolder> value = entry.getValue();
            for (Map.Entry<Data, CacheRecordHolder> e : value.entrySet()) {
                ss.disposeData(e.getKey());
                CacheRecordHolder holder = e.getValue();
                if (holder.value == null) continue;
                ss.disposeData(holder.value);
            }
            value.clear();
        }
        this.destination.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            super.run();
            EnterpriseCacheService service = (EnterpriseCacheService)this.getService();
            block5: for (Map.Entry<String, Map<Data, CacheRecordHolder>> entry : this.destination.entrySet()) {
                HiDensityCacheRecordStore recordStore = (HiDensityCacheRecordStore)service.getOrCreateRecordStore(entry.getKey(), this.getPartitionId());
                recordStore.reset();
                Map<Data, CacheRecordHolder> map = entry.getValue();
                Iterator<Map.Entry<Data, CacheRecordHolder>> iter = map.entrySet().iterator();
                while (iter.hasNext()) {
                    Map.Entry<Data, CacheRecordHolder> next = iter.next();
                    Data key = next.getKey();
                    CacheRecordHolder holder = next.getValue();
                    recordStore.putReplica(key, holder.value, holder.creationTime, holder.ttl);
                    iter.remove();
                    if (!recordStore.evictIfRequired()) continue;
                    continue block5;
                }
            }
        }
        catch (Throwable e) {
            if (e instanceof NativeOutOfMemoryError) {
                this.oome = (NativeOutOfMemoryError)e;
            } else {
                this.getLogger().severe("While replicating cache! partition: " + this.getPartitionId() + ", replica: " + this.getReplicaIndex(), e);
            }
        }
        finally {
            this.dispose();
        }
    }

    @Override
    public void afterRun() throws Exception {
        super.afterRun();
        if (this.oome != null) {
            ILogger logger = this.getLogger();
            logger.warning(this.oome.getMessage());
        }
    }

    @Override
    public void onExecutionFailure(Throwable e) {
        this.dispose();
        super.onExecutionFailure(e);
    }

    @Override
    public boolean returnsResponse() {
        return true;
    }

    @Override
    public Object getResponse() {
        return Boolean.TRUE;
    }

    @Override
    public String getServiceName() {
        return "hz:impl:cacheService";
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        int count = this.source.size();
        out.writeInt(count);
        NativeMemoryData valueData = new NativeMemoryData();
        long now = Clock.currentTimeMillis();
        for (Map.Entry<String, Map<Data, HiDensityCacheRecord>> entry : this.source.entrySet()) {
            Map<Data, HiDensityCacheRecord> value = entry.getValue();
            int subCount = value.size();
            out.writeInt(subCount);
            out.writeString(entry.getKey());
            for (Map.Entry<Data, HiDensityCacheRecord> e : value.entrySet()) {
                HiDensityCacheRecord record = e.getValue();
                valueData.reset(record.getValueAddress());
                IOUtil.writeData(out, e.getKey());
                IOUtil.writeData(out, valueData);
                long remainingTtl = this.getRemainingTtl(record, now);
                out.writeLong(remainingTtl);
                out.writeLong(record.getCreationTime());
                --subCount;
            }
            if (subCount != 0) {
                throw new AssertionError((Object)("Cache iteration error, count is not zero!" + subCount));
            }
        }
        super.writeInternal(out);
    }

    private long getRemainingTtl(HiDensityCacheRecord record, long now) {
        long creationTime = record.getCreationTime();
        long ttlMillis = record.getTtlMillis();
        if (ttlMillis > 0L) {
            long remainingTtl = creationTime + ttlMillis - now;
            return remainingTtl > 0L ? remainingTtl : 1L;
        }
        return -1L;
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        int count = in.readInt();
        for (int i = 0; i < count; ++i) {
            int subCount = in.readInt();
            String name = in.readString();
            HashMap<Data, CacheRecordHolder> m = new HashMap<Data, CacheRecordHolder>(subCount);
            this.destination.put(name, m);
            for (int j = 0; j < subCount; ++j) {
                Data key = HiDensityCacheOperation.readNativeMemoryOperationData(in);
                if (key == null) continue;
                Data value = HiDensityCacheOperation.readNativeMemoryOperationData(in);
                long ttlMillis = in.readLong();
                long creationTime = in.readLong();
                CacheRecordHolder holder = new CacheRecordHolder(value, creationTime, ttlMillis);
                m.put(key, holder);
            }
        }
        super.readInternal(in);
    }

    @Override
    public boolean isEmpty() {
        return this.source.isEmpty() && super.isEmpty();
    }

    @Override
    public int getFactoryId() {
        return HiDensityCacheDataSerializerHook.F_ID;
    }

    @Override
    public int getClassId() {
        return 21;
    }

    @Override
    public void logError(Throwable e) {
        ILogger logger = this.getLogger();
        if (e instanceof NativeOutOfMemoryError) {
            logger.warning("Cannot complete operation! -> " + e.getMessage());
        } else if (e instanceof CacheNotExistsException) {
            logger.finest("Error while getting a cache", e);
        } else {
            super.logError(e);
        }
    }

    private static final class CacheRecordHolder {
        final Data value;
        final long ttl;
        final long creationTime;

        private CacheRecordHolder(Data value, long ttl) {
            this.creationTime = -1L;
            this.ttl = ttl;
            this.value = value;
        }

        private CacheRecordHolder(Data value, long creationTime, long ttl) {
            this.creationTime = creationTime;
            this.ttl = ttl;
            this.value = value;
        }
    }
}

