/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.cache.impl.hidensity.operation;

import com.hazelcast.cache.impl.hidensity.operation.BackupAwareHiDensityCacheOperation;
import com.hazelcast.cache.impl.hidensity.operation.CacheMergeBackupOperation;
import com.hazelcast.cache.impl.operation.MutableOperation;
import com.hazelcast.cache.impl.record.CacheRecord;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.internal.util.MapUtil;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.spi.impl.merge.CacheMergingEntryImpl;
import com.hazelcast.spi.impl.operationservice.MutatingOperation;
import com.hazelcast.spi.impl.operationservice.Operation;
import com.hazelcast.spi.merge.SplitBrainMergePolicy;
import com.hazelcast.spi.merge.SplitBrainMergeTypes;
import com.hazelcast.wan.impl.CallerProvenance;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class CacheMergeOperation
extends BackupAwareHiDensityCacheOperation
implements MutableOperation,
MutatingOperation {
    private SplitBrainMergePolicy<Object, SplitBrainMergeTypes.CacheMergeTypes<Object, Object>, Object> mergePolicy;
    private List<SplitBrainMergeTypes.CacheMergeTypes<Object, Object>> mergingEntries;
    private transient boolean hasBackups;
    private transient boolean wanReplicationEnabled;
    private transient Map<Data, CacheRecord> backupRecords;

    public CacheMergeOperation() {
    }

    public CacheMergeOperation(String name, List<SplitBrainMergeTypes.CacheMergeTypes<Object, Object>> mergingEntries, SplitBrainMergePolicy<Object, SplitBrainMergeTypes.CacheMergeTypes<Object, Object>, Object> policy) {
        super(name);
        this.mergingEntries = mergingEntries;
        this.mergePolicy = policy;
    }

    @Override
    public void beforeRunInternal() {
        this.wanReplicationEnabled = this.recordStore.isWanReplicationEnabled();
        boolean bl = this.hasBackups = this.getSyncBackupCount() + this.getAsyncBackupCount() > 0;
        if (this.hasBackups) {
            this.backupRecords = MapUtil.createHashMap(this.mergingEntries.size());
        }
    }

    @Override
    public void runInternal() {
        for (SplitBrainMergeTypes.CacheMergeTypes<Object, Object> mergingEntry : this.mergingEntries) {
            this.merge(mergingEntry);
        }
        this.response = true;
    }

    private void merge(SplitBrainMergeTypes.CacheMergeTypes mergingEntry) {
        assert (mergingEntry instanceof CacheMergingEntryImpl);
        CacheMergingEntryImpl mergingEntryImpl = (CacheMergingEntryImpl)mergingEntry;
        CacheRecord backupRecord = this.recordStore.merge(mergingEntry, this.mergePolicy, CallerProvenance.NOT_WAN);
        if (this.hasBackups && backupRecord != null) {
            this.backupRecords.put(mergingEntryImpl.getRawKey(), backupRecord);
        }
        if (this.wanReplicationEnabled) {
            if (backupRecord != null) {
                this.publishWanUpdate(mergingEntryImpl.getRawKey(), backupRecord);
            } else {
                this.publishWanRemove(mergingEntryImpl.getRawKey());
            }
        }
    }

    @Override
    public boolean shouldBackup() {
        return this.hasBackups && !this.backupRecords.isEmpty();
    }

    @Override
    public Operation getBackupOperation() {
        return new CacheMergeBackupOperation(this.name, this.backupRecords);
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeInt(this.mergingEntries.size());
        for (SplitBrainMergeTypes.CacheMergeTypes<Object, Object> mergingEntry : this.mergingEntries) {
            out.writeObject(mergingEntry);
        }
        out.writeObject(this.mergePolicy);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        int size = in.readInt();
        this.mergingEntries = new ArrayList<SplitBrainMergeTypes.CacheMergeTypes<Object, Object>>(size);
        for (int i = 0; i < size; ++i) {
            SplitBrainMergeTypes.CacheMergeTypes mergingEntry = (SplitBrainMergeTypes.CacheMergeTypes)in.readObject();
            this.mergingEntries.add(mergingEntry);
        }
        this.mergePolicy = (SplitBrainMergePolicy)in.readObject();
    }

    @Override
    public int getClassId() {
        return 24;
    }
}

