/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.cache.impl.hidensity.nativememory;

import com.hazelcast.cache.CacheEntryView;
import com.hazelcast.cache.impl.CacheEntriesWithCursor;
import com.hazelcast.cache.impl.CacheKeysWithCursor;
import com.hazelcast.cache.impl.hidensity.SampleableHiDensityCacheRecordMap;
import com.hazelcast.cache.impl.hidensity.nativememory.HiDensityNativeMemoryCacheRecord;
import com.hazelcast.internal.hidensity.HiDensityRecordProcessor;
import com.hazelcast.internal.hidensity.HiDensityStorageInfo;
import com.hazelcast.internal.hidensity.impl.SampleableEvictableHiDensityRecordMap;
import com.hazelcast.internal.iteration.IterationPointer;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.internal.serialization.DataType;
import com.hazelcast.internal.serialization.impl.NativeMemoryData;
import com.hazelcast.internal.serialization.impl.NativeMemoryDataUtil;
import com.hazelcast.internal.util.Clock;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Map;
import java.util.function.BiConsumer;
import javax.cache.expiry.ExpiryPolicy;

public class HiDensityNativeMemoryCacheRecordMap
extends SampleableEvictableHiDensityRecordMap<HiDensityNativeMemoryCacheRecord>
implements SampleableHiDensityCacheRecordMap<HiDensityNativeMemoryCacheRecord> {
    private boolean entryCountingEnable;

    public HiDensityNativeMemoryCacheRecordMap(int initialCapacity, HiDensityRecordProcessor cacheRecordProcessor, HiDensityStorageInfo cacheInfo) {
        super(initialCapacity, cacheRecordProcessor, cacheInfo);
    }

    @Override
    public void setEntryCounting(boolean enable) {
        if (enable) {
            if (!this.entryCountingEnable) {
                this.storageInfo.addEntryCount(this.size());
            }
        } else if (this.entryCountingEnable) {
            int size = this.size();
            this.storageInfo.removeEntryCount(size);
        }
        this.entryCountingEnable = enable;
    }

    @Override
    protected void increaseEntryCount() {
        if (this.entryCountingEnable) {
            super.increaseEntryCount();
        }
    }

    @Override
    protected void decreaseEntryCount() {
        if (this.entryCountingEnable) {
            super.decreaseEntryCount();
        }
    }

    @Override
    protected void decreaseEntryCount(int entryCount) {
        if (this.entryCountingEnable) {
            super.decreaseEntryCount(entryCount);
        }
    }

    @Override
    public CacheKeysWithCursor fetchKeys(IterationPointer[] pointers, int size) {
        ArrayList<Data> keys = new ArrayList<Data>(size);
        IterationPointer[] newIterationPointers = this.fetchNext(pointers, size, (k, v) -> keys.add(this.memoryBlockProcessor.convertData((Data)k, DataType.HEAP)));
        return new CacheKeysWithCursor(keys, newIterationPointers);
    }

    @Override
    public CacheEntriesWithCursor fetchEntries(IterationPointer[] pointers, int size) {
        ArrayList<Map.Entry<Data, Data>> entries = new ArrayList<Map.Entry<Data, Data>>(size);
        IterationPointer[] newIterationPointers = this.fetchNext(pointers, size, (k, v) -> {
            Data key = this.recordProcessor.convertData((Data)k, DataType.HEAP);
            Data value = this.recordProcessor.convertData((Data)v, DataType.HEAP);
            entries.add(new AbstractMap.SimpleEntry<Data, Data>(key, value));
        });
        return new CacheEntriesWithCursor(entries, newIterationPointers);
    }

    private IterationPointer[] fetchNext(IterationPointer[] pointers, int size, BiConsumer<Data, Data> keyValueConsumer) {
        long now = Clock.currentTimeMillis();
        IterationPointer[] updatedPointers = this.checkPointers(pointers, this.capacity());
        IterationPointer lastPointer = updatedPointers[updatedPointers.length - 1];
        int currentBaseSlot = lastPointer.getIndex();
        int[] fetchedEntries = new int[]{0};
        while (fetchedEntries[0] < size && currentBaseSlot >= 0) {
            currentBaseSlot = this.fetchAllWithBaseSlot(currentBaseSlot, slot -> {
                long currentKey;
                int currentKeyHashCode;
                long valueAddr = this.accessor.getValue(slot);
                HiDensityNativeMemoryCacheRecord record = (HiDensityNativeMemoryCacheRecord)this.readV(valueAddr);
                if (!record.isExpiredAt(now) && this.hasNotBeenObserved(currentKeyHashCode = NativeMemoryDataUtil.hashCode(currentKey = this.accessor.getKey(slot)), updatedPointers)) {
                    NativeMemoryData keyData = this.accessor.keyData(slot);
                    keyValueConsumer.accept(keyData, record.getValue());
                    fetchedEntries[0] = fetchedEntries[0] + 1;
                }
            });
            lastPointer.setIndex(currentBaseSlot);
        }
        return updatedPointers;
    }

    private IterationPointer[] checkPointers(IterationPointer[] pointers, int currentTableSize) {
        IterationPointer lastPointer = pointers[pointers.length - 1];
        boolean iterationStarted = lastPointer.getSize() == -1;
        boolean tableResized = lastPointer.getSize() != currentTableSize;
        int newLength = !iterationStarted && tableResized ? pointers.length + 1 : pointers.length;
        IterationPointer[] updatedPointers = new IterationPointer[newLength];
        for (int i = 0; i < pointers.length; ++i) {
            updatedPointers[i] = new IterationPointer(pointers[i]);
        }
        if (iterationStarted || tableResized) {
            updatedPointers[updatedPointers.length - 1] = new IterationPointer(Integer.MAX_VALUE, currentTableSize);
        }
        return updatedPointers;
    }

    @Override
    protected SampleableEvictableHiDensityRecordMap.EvictableSamplingEntry createSamplingEntry(int slot) {
        return new CacheEvictableSamplingEntry(slot);
    }

    private final class CacheEvictableSamplingEntry
    extends SampleableEvictableHiDensityRecordMap.EvictableSamplingEntry
    implements CacheEntryView {
        private CacheEvictableSamplingEntry(int slot) {
            super(HiDensityNativeMemoryCacheRecordMap.this, slot);
        }

        @Override
        public long getExpirationTime() {
            return ((HiDensityNativeMemoryCacheRecord)this.getEntryValue()).getExpirationTime();
        }

        public ExpiryPolicy getExpiryPolicy() {
            return (ExpiryPolicy)HiDensityNativeMemoryCacheRecordMap.this.recordProcessor.toObject(((HiDensityNativeMemoryCacheRecord)this.getEntryValue()).getExpiryPolicy());
        }
    }
}

