/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.cache.impl.hidensity.nativememory;

import com.hazelcast.cache.impl.hidensity.HiDensityCacheRecord;
import com.hazelcast.internal.hidensity.HiDensityRecordAccessor;
import com.hazelcast.internal.memory.GlobalMemoryAccessorRegistry;
import com.hazelcast.internal.serialization.impl.NativeMemoryData;

public final class HiDensityNativeMemoryCacheRecord
extends HiDensityCacheRecord {
    public static final int SIZE = 52;
    static final int CREATION_TIME_OFFSET = 0;
    static final int ACCESS_TIME_OFFSET = 8;
    static final int TTL_OFFSET = 16;
    static final int SEQUENCE_OFFSET = 24;
    static final int VALUE_OFFSET = 32;
    static final int EXPIRY_POLICY_OFFSET = 40;
    static final int ACCESS_HIT_OFFSET = 48;
    private final HiDensityRecordAccessor<HiDensityNativeMemoryCacheRecord> recordAccessor;

    public HiDensityNativeMemoryCacheRecord(HiDensityRecordAccessor<HiDensityNativeMemoryCacheRecord> recordAccessor, long address) {
        super(GlobalMemoryAccessorRegistry.AMEM, address, SIZE);
        this.recordAccessor = recordAccessor;
    }

    public HiDensityNativeMemoryCacheRecord(HiDensityRecordAccessor<HiDensityNativeMemoryCacheRecord> recordAccessor) {
        super(GlobalMemoryAccessorRegistry.AMEM);
        this.recordAccessor = recordAccessor;
    }

    public HiDensityNativeMemoryCacheRecord(long address) {
        this(null, address);
    }

    @Override
    public long getCreationTime() {
        return this.readLong(0L);
    }

    @Override
    public void setCreationTime(long time) {
        this.writeLong(0L, time);
    }

    @Override
    public long getLastAccessTime() {
        return this.readLong(8L);
    }

    @Override
    public void setLastAccessTime(long time) {
        this.writeLong(8L, time);
    }

    @Override
    public long getHits() {
        return this.readInt(48L);
    }

    @Override
    public void setHits(long hit) {
        this.writeInt(48L, hit > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)hit);
    }

    @Override
    public void incrementHits() {
        long accessHit = this.getHits() + 1L;
        this.writeInt(48L, accessHit > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)accessHit);
    }

    @Override
    public long getTtlMillis() {
        return this.readLong(16L);
    }

    @Override
    public void setTtlMillis(long ttl) {
        this.writeLong(16L, ttl);
    }

    @Override
    public long getValueAddress() {
        return this.readLong(32L);
    }

    @Override
    public void setValueAddress(long valueAddress) {
        this.writeLong(32L, valueAddress);
    }

    @Override
    public void setExpiryPolicyAddress(long policyAddress) {
        this.writeLong(40L, policyAddress);
    }

    @Override
    public long getExpiryPolicyAddress() {
        return this.readLong(40L);
    }

    @Override
    public HiDensityNativeMemoryCacheRecord reset(long address) {
        this.setAddress(address);
        this.setSize(SIZE);
        return this;
    }

    @Override
    public void clear() {
        this.zero();
    }

    @Override
    public NativeMemoryData getValue() {
        if (this.address == 0L) {
            return null;
        }
        long valueAddress = this.getValueAddress();
        if (valueAddress == 0L) {
            return null;
        }
        if (this.recordAccessor != null) {
            return this.recordAccessor.readData(valueAddress);
        }
        return new NativeMemoryData().reset(valueAddress);
    }

    @Override
    public void setValue(NativeMemoryData value) {
        if (value != null) {
            this.setValueAddress(value.address());
        } else {
            this.setValueAddress(0L);
        }
    }

    @Override
    public void setExpiryPolicy(NativeMemoryData expiryPolicy) {
        if (expiryPolicy == null) {
            this.setExpiryPolicyAddress(0L);
        } else {
            this.setExpiryPolicyAddress(expiryPolicy.address());
        }
    }

    @Override
    public NativeMemoryData getExpiryPolicy() {
        if (this.address == 0L) {
            return null;
        }
        long policyAddress = this.getExpiryPolicyAddress();
        if (policyAddress == 0L) {
            return null;
        }
        if (this.recordAccessor != null) {
            return this.recordAccessor.readData(policyAddress);
        }
        return new NativeMemoryData().reset(policyAddress);
    }

    @Override
    public long getExpirationTime() {
        long ttlMillis = this.getTtlMillis();
        if (ttlMillis < 0L) {
            return Long.MAX_VALUE;
        }
        long creationTime = this.getCreationTime();
        long expirationTime = creationTime + ttlMillis;
        if (expirationTime < creationTime) {
            return Long.MAX_VALUE;
        }
        return expirationTime;
    }

    @Override
    public void setExpirationTime(long expirationTime) {
        long creationTime = this.getCreationTime();
        long timeDiff = expirationTime - creationTime;
        long newTtl = timeDiff >= 0L ? timeDiff : -1L;
        this.setTtlMillis(newTtl);
    }

    @Override
    public long getSequence() {
        return this.readLong(24L);
    }

    public void setSequence(long seq) {
        this.writeLong(24L, seq);
    }

    @Override
    public boolean isExpiredAt(long now) {
        long expirationTime = this.getExpirationTime();
        return expirationTime > -1L && expirationTime <= now;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HiDensityNativeMemoryCacheRecord record = (HiDensityNativeMemoryCacheRecord)o;
        return this.address == record.address && this.size == record.size;
    }

    @Override
    public int hashCode() {
        int result = (int)(this.address ^ this.address >>> 32);
        result = 31 * result + this.size;
        return result;
    }

    @Override
    public String toString() {
        if (this.address() != 0L) {
            return "HiDensityNativeMemoryCacheRecord{creationTime: " + this.getCreationTime() + ", lastAccessTime: " + this.getLastAccessTime() + ", hits: " + this.getHits() + ", ttl: " + this.getTtlMillis() + ", sequence: " + this.getSequence() + ", valueAddress: " + this.getValueAddress() + " }";
        }
        return "HiDensityNativeMemoryCacheRecord{NULL}";
    }
}

