/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.cache.impl.hidensity.maxsize;

import com.hazelcast.config.MaxSizePolicy;
import com.hazelcast.internal.eviction.EvictionChecker;
import com.hazelcast.internal.memory.HazelcastMemoryManager;

public class HiDensityFreeNativeMemoryPercentageEvictionChecker
implements EvictionChecker {
    private final HazelcastMemoryManager memoryManager;
    private final long minFreeMemorySize;

    public HiDensityFreeNativeMemoryPercentageEvictionChecker(HazelcastMemoryManager memoryManager, int maxSizePercentage, long maxNativeMemory) {
        if (maxSizePercentage < 0 || maxSizePercentage > 100) {
            throw new IllegalArgumentException("\"maxSize\" can only be 0-100 for " + (Object)((Object)MaxSizePolicy.FREE_NATIVE_MEMORY_PERCENTAGE) + " max-size policy !");
        }
        double maxSizeRatio = (double)maxSizePercentage / 100.0;
        this.memoryManager = memoryManager;
        this.minFreeMemorySize = (long)((double)maxNativeMemory * maxSizeRatio);
    }

    @Override
    public boolean isEvictionRequired() {
        return this.memoryManager.getMemoryStats().getFreeNative() < this.minFreeMemorySize;
    }
}

