/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.org.apache.calcite.sql2rel;

import com.hazelcast.com.google.common.collect.ImmutableSet;
import com.hazelcast.org.apache.calcite.rel.RelHomogeneousShuttle;
import com.hazelcast.org.apache.calcite.rel.RelNode;
import com.hazelcast.org.apache.calcite.rel.core.CorrelationId;
import com.hazelcast.org.apache.calcite.rex.RexBuilder;
import com.hazelcast.org.apache.calcite.rex.RexCorrelVariable;
import com.hazelcast.org.apache.calcite.rex.RexNode;
import com.hazelcast.org.apache.calcite.rex.RexShuttle;
import com.hazelcast.org.apache.calcite.rex.RexSubQuery;
import com.hazelcast.org.checkerframework.checker.initialization.qual.NotOnlyInitialized;
import com.hazelcast.org.checkerframework.checker.initialization.qual.UnderInitialization;

public class DeduplicateCorrelateVariables
extends RelHomogeneousShuttle {
    @NotOnlyInitialized
    private final RexShuttle dedupRex;

    private DeduplicateCorrelateVariables(RexBuilder builder, CorrelationId canonicalId, ImmutableSet<CorrelationId> alternateIds) {
        this.dedupRex = new DeduplicateCorrelateVariablesShuttle(builder, canonicalId, alternateIds, this);
    }

    public static RelNode go(RexBuilder builder, CorrelationId canonicalId, Iterable<? extends CorrelationId> alternateIds, RelNode r) {
        return r.accept(new DeduplicateCorrelateVariables(builder, canonicalId, ImmutableSet.copyOf(alternateIds)));
    }

    @Override
    public RelNode visit(RelNode other) {
        RelNode next = super.visit(other);
        return next.accept(this.dedupRex);
    }

    private static class DeduplicateCorrelateVariablesShuttle
    extends RexShuttle {
        private final RexBuilder builder;
        private final CorrelationId canonicalId;
        private final ImmutableSet<CorrelationId> alternateIds;
        @NotOnlyInitialized
        private final DeduplicateCorrelateVariables shuttle;

        private DeduplicateCorrelateVariablesShuttle(RexBuilder builder, CorrelationId canonicalId, ImmutableSet<CorrelationId> alternateIds, @UnderInitialization DeduplicateCorrelateVariables shuttle) {
            this.builder = builder;
            this.canonicalId = canonicalId;
            this.alternateIds = alternateIds;
            this.shuttle = shuttle;
        }

        @Override
        public RexNode visitCorrelVariable(RexCorrelVariable variable) {
            if (!this.alternateIds.contains(variable.id)) {
                return variable;
            }
            return this.builder.makeCorrel(variable.getType(), this.canonicalId);
        }

        @Override
        public RexNode visitSubQuery(RexSubQuery subQuery) {
            RelNode r;
            if (this.shuttle != null && (r = subQuery.rel.accept(this.shuttle)) != subQuery.rel) {
                subQuery = subQuery.clone(r);
            }
            return super.visitSubQuery(subQuery);
        }
    }
}

