/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.org.apache.calcite.sql.validate;

import com.hazelcast.com.google.common.collect.ImmutableList;
import com.hazelcast.org.apache.calcite.rel.type.RelDataType;
import com.hazelcast.org.apache.calcite.rel.type.RelDataTypeFactory;
import com.hazelcast.org.apache.calcite.sql.SqlNode;
import com.hazelcast.org.apache.calcite.sql.validate.AbstractNamespace;
import com.hazelcast.org.apache.calcite.sql.validate.SqlMoniker;
import com.hazelcast.org.apache.calcite.sql.validate.SqlValidatorImpl;
import com.hazelcast.org.apache.calcite.sql.validate.SqlValidatorTable;
import com.hazelcast.org.apache.calcite.util.Util;
import com.hazelcast.org.checkerframework.checker.nullness.qual.Nullable;
import java.util.List;
import java.util.Objects;

class SchemaNamespace
extends AbstractNamespace {
    private final ImmutableList<String> names;

    SchemaNamespace(SqlValidatorImpl validator, ImmutableList<String> names) {
        super(validator, null);
        this.names = Objects.requireNonNull(names, "names");
    }

    @Override
    protected RelDataType validateImpl(RelDataType targetRowType) {
        RelDataTypeFactory.FieldInfoBuilder builder = this.validator.getTypeFactory().builder();
        for (SqlMoniker moniker : this.validator.catalogReader.getAllSchemaObjectNames(this.names)) {
            List<String> names1 = moniker.getFullyQualifiedNames();
            SqlValidatorTable table = Objects.requireNonNull(this.validator.catalogReader.getTable(names1), () -> "table " + names1 + " is not found in scope " + this.names);
            ((RelDataTypeFactory.Builder)builder).add(Util.last(names1), table.getRowType());
        }
        return builder.build();
    }

    @Override
    public @Nullable SqlNode getNode() {
        return null;
    }
}

