/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.org.apache.calcite.sql.fun;

import com.hazelcast.org.apache.calcite.linq4j.Nullness;
import com.hazelcast.org.apache.calcite.linq4j.Ord;
import com.hazelcast.org.apache.calcite.rel.type.RelDataType;
import com.hazelcast.org.apache.calcite.sql.SqlCall;
import com.hazelcast.org.apache.calcite.sql.SqlCallBinding;
import com.hazelcast.org.apache.calcite.sql.SqlCharStringLiteral;
import com.hazelcast.org.apache.calcite.sql.SqlCollation;
import com.hazelcast.org.apache.calcite.sql.SqlKind;
import com.hazelcast.org.apache.calcite.sql.SqlLiteral;
import com.hazelcast.org.apache.calcite.sql.SqlNode;
import com.hazelcast.org.apache.calcite.sql.SqlOperatorBinding;
import com.hazelcast.org.apache.calcite.sql.SqlSpecialOperator;
import com.hazelcast.org.apache.calcite.sql.SqlUtil;
import com.hazelcast.org.apache.calcite.sql.SqlWriter;
import com.hazelcast.org.apache.calcite.sql.parser.SqlParserPos;
import com.hazelcast.org.apache.calcite.sql.type.InferTypes;
import com.hazelcast.org.apache.calcite.sql.type.OperandTypes;
import com.hazelcast.org.apache.calcite.sql.type.ReturnTypes;
import com.hazelcast.org.apache.calcite.sql.type.SqlTypeName;
import com.hazelcast.org.apache.calcite.sql.type.SqlTypeUtil;
import com.hazelcast.org.apache.calcite.sql.validate.SqlValidator;
import com.hazelcast.org.apache.calcite.sql.validate.SqlValidatorScope;
import com.hazelcast.org.apache.calcite.util.BitString;
import com.hazelcast.org.apache.calcite.util.NlsString;
import com.hazelcast.org.apache.calcite.util.Static;
import com.hazelcast.org.apache.calcite.util.Util;
import java.util.List;

public class SqlLiteralChainOperator
extends SqlSpecialOperator {
    SqlLiteralChainOperator() {
        super("$LiteralChain", SqlKind.LITERAL_CHAIN, 80, true, ReturnTypes.ARG0, InferTypes.FIRST_KNOWN, OperandTypes.VARIADIC);
    }

    private static boolean argTypesValid(SqlCallBinding callBinding) {
        if (callBinding.getOperandCount() < 2) {
            return true;
        }
        RelDataType firstType = null;
        for (Ord<SqlNode> operand : Ord.zip(callBinding.operands())) {
            RelDataType type = SqlTypeUtil.deriveType(callBinding, (SqlNode)operand.e);
            if (operand.i == 0) {
                firstType = type;
                continue;
            }
            if (SqlTypeUtil.sameNamedType(Nullness.castNonNull(firstType), type)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean checkOperandTypes(SqlCallBinding callBinding, boolean throwOnFailure) {
        if (!SqlLiteralChainOperator.argTypesValid(callBinding)) {
            if (throwOnFailure) {
                throw callBinding.newValidationSignatureError();
            }
            return false;
        }
        return true;
    }

    @Override
    public RelDataType inferReturnType(SqlOperatorBinding opBinding) {
        RelDataType ret = opBinding.getOperandType(0);
        SqlTypeName typeName = ret.getSqlTypeName();
        assert (typeName.allowsPrecNoScale()) : "LiteralChain has impossible operand type " + (Object)((Object)typeName);
        int size = 0;
        for (RelDataType type : opBinding.collectOperandTypes()) {
            size += type.getPrecision();
            assert (type.getSqlTypeName() == typeName);
        }
        return opBinding.getTypeFactory().createSqlType(typeName, size);
    }

    @Override
    public String getAllowedSignatures(String opName) {
        return opName + "(...)";
    }

    @Override
    public void validateCall(SqlCall call, SqlValidator validator, SqlValidatorScope scope, SqlValidatorScope operandScope) {
        List<SqlNode> operandList = call.getOperandList();
        for (int i = 1; i < operandList.size(); ++i) {
            SqlParserPos prevPos = operandList.get(i - 1).getParserPosition();
            SqlNode operand = operandList.get(i);
            SqlParserPos pos = operand.getParserPosition();
            if (pos.getLineNum() > prevPos.getLineNum()) continue;
            throw validator.newValidationError(operand, Static.RESOURCE.stringFragsOnSameLine());
        }
    }

    @Override
    public void unparse(SqlWriter writer, SqlCall call, int leftPrec, int rightPrec) {
        SqlWriter.Frame frame = writer.startList("", "");
        SqlCollation collation = null;
        for (Ord<SqlNode> operand : Ord.zip(call.getOperandList())) {
            SqlLiteral rand = (SqlLiteral)operand.e;
            if (operand.i > 0) {
                writer.newlineAndIndent();
            }
            if (rand instanceof SqlCharStringLiteral) {
                NlsString nls = rand.getValueAs(NlsString.class);
                if (operand.i == 0) {
                    collation = nls.getCollation();
                    writer.literal(nls.asSql(true, false, writer.getDialect()));
                    continue;
                }
                writer.literal(nls.asSql(false, false, writer.getDialect()));
                continue;
            }
            if (operand.i == 0) {
                rand.unparse(writer, leftPrec, rightPrec);
                continue;
            }
            if (rand.getTypeName() == SqlTypeName.BINARY) {
                BitString bs = rand.getValueAs(BitString.class);
                writer.literal("'" + bs.toHexString() + "'");
                continue;
            }
            writer.literal("'" + rand.toValue() + "'");
        }
        if (collation != null) {
            collation.unparse(writer);
        }
        writer.endList(frame);
    }

    public static SqlLiteral concatenateOperands(SqlCall call) {
        List<SqlNode> operandList = call.getOperandList();
        assert (operandList.size() > 0);
        assert (operandList.get(0) instanceof SqlLiteral) : operandList.get(0).getClass();
        return SqlUtil.concatenateLiterals(Util.cast(operandList, SqlLiteral.class));
    }
}

