/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.org.apache.calcite.sql.fun;

import com.hazelcast.com.google.common.collect.ImmutableList;
import com.hazelcast.org.apache.calcite.rel.type.RelDataType;
import com.hazelcast.org.apache.calcite.rel.type.RelDataTypeFactory;
import com.hazelcast.org.apache.calcite.rel.type.RelDataTypeField;
import com.hazelcast.org.apache.calcite.sql.ExplicitOperatorBinding;
import com.hazelcast.org.apache.calcite.sql.SqlBinaryOperator;
import com.hazelcast.org.apache.calcite.sql.SqlCall;
import com.hazelcast.org.apache.calcite.sql.SqlCallBinding;
import com.hazelcast.org.apache.calcite.sql.SqlKind;
import com.hazelcast.org.apache.calcite.sql.SqlNode;
import com.hazelcast.org.apache.calcite.sql.SqlNodeList;
import com.hazelcast.org.apache.calcite.sql.SqlOperator;
import com.hazelcast.org.apache.calcite.sql.fun.SqlInternalOperators;
import com.hazelcast.org.apache.calcite.sql.fun.SqlStdOperatorTable;
import com.hazelcast.org.apache.calcite.sql.type.ComparableOperandTypeChecker;
import com.hazelcast.org.apache.calcite.sql.type.InferTypes;
import com.hazelcast.org.apache.calcite.sql.type.OperandTypes;
import com.hazelcast.org.apache.calcite.sql.type.ReturnTypes;
import com.hazelcast.org.apache.calcite.sql.type.SqlTypeName;
import com.hazelcast.org.apache.calcite.sql.type.SqlTypeUtil;
import com.hazelcast.org.apache.calcite.sql.validate.SqlValidator;
import com.hazelcast.org.apache.calcite.sql.validate.SqlValidatorScope;
import com.hazelcast.org.apache.calcite.util.Litmus;
import com.hazelcast.org.apache.calcite.util.Static;
import java.util.ArrayList;
import java.util.List;

public class SqlInOperator
extends SqlBinaryOperator {
    SqlInOperator(SqlKind kind) {
        this(kind.sql, kind);
        assert (kind == SqlKind.IN || kind == SqlKind.NOT_IN || kind == SqlKind.DRUID_IN || kind == SqlKind.DRUID_NOT_IN);
    }

    protected SqlInOperator(String name, SqlKind kind) {
        super(name, kind, 32, true, ReturnTypes.BOOLEAN_NULLABLE, InferTypes.FIRST_KNOWN, null);
    }

    @Deprecated
    public boolean isNotIn() {
        return this.kind == SqlKind.NOT_IN;
    }

    @Override
    public SqlOperator not() {
        return SqlInOperator.of(this.kind.negateNullSafe());
    }

    private static SqlBinaryOperator of(SqlKind kind) {
        switch (kind) {
            case IN: {
                return SqlStdOperatorTable.IN;
            }
            case NOT_IN: {
                return SqlStdOperatorTable.NOT_IN;
            }
            case DRUID_IN: {
                return SqlInternalOperators.DRUID_IN;
            }
            case DRUID_NOT_IN: {
                return SqlInternalOperators.DRUID_NOT_IN;
            }
        }
        throw new AssertionError((Object)("unexpected " + (Object)((Object)kind)));
    }

    @Override
    public boolean validRexOperands(int count, Litmus litmus) {
        if (count == 0) {
            return litmus.fail("wrong operand count {} for {}", count, this);
        }
        return litmus.succeed();
    }

    @Override
    public RelDataType deriveType(SqlValidator validator, SqlValidatorScope scope, SqlCall call) {
        RelDataType rightRowType;
        RelDataType leftRowType;
        ComparableOperandTypeChecker checker;
        boolean coerced;
        RelDataType rightType;
        List<SqlNode> operands = call.getOperandList();
        assert (operands.size() == 2);
        SqlNode left = operands.get(0);
        SqlNode right = operands.get(1);
        RelDataTypeFactory typeFactory = validator.getTypeFactory();
        RelDataType leftType = validator.deriveType(scope, left);
        if (right instanceof SqlNodeList) {
            ArrayList<RelDataType> rightTypeList = new ArrayList<RelDataType>();
            SqlNodeList nodeList = (SqlNodeList)right;
            for (int i = 0; i < nodeList.size(); ++i) {
                SqlNode node = nodeList.get(i);
                RelDataType nodeType = validator.deriveType(scope, node);
                rightTypeList.add(nodeType);
            }
            rightType = typeFactory.leastRestrictive(rightTypeList);
            if (null == rightType && validator.config().typeCoercionEnabled()) {
                rightType = validator.getTypeCoercion().getWiderTypeFor(rightTypeList, true);
            }
            if (null == rightType) {
                throw validator.newValidationError(right, Static.RESOURCE.incompatibleTypesInList());
            }
            validator.setValidatedNodeType(nodeList, rightType);
        } else {
            rightType = validator.deriveType(scope, right);
        }
        SqlCallBinding callBinding = new SqlCallBinding(validator, scope, call);
        if (callBinding.isTypeCoercionEnabled() && (coerced = callBinding.getValidator().getTypeCoercion().inOperationCoercion(callBinding))) {
            leftType = validator.deriveType(scope, (SqlNode)call.operand(0));
            rightType = validator.deriveType(scope, (SqlNode)call.operand(1));
        }
        if (!(checker = (ComparableOperandTypeChecker)OperandTypes.COMPARABLE_UNORDERED_COMPARABLE_UNORDERED).checkOperandTypes(new ExplicitOperatorBinding(callBinding, ImmutableList.of(leftRowType = SqlTypeUtil.promoteToRowType(typeFactory, leftType, null), rightRowType = SqlTypeUtil.promoteToRowType(typeFactory, rightType, null))), callBinding)) {
            throw validator.newValidationError(call, Static.RESOURCE.incompatibleValueType(SqlStdOperatorTable.IN.getName()));
        }
        return typeFactory.createTypeWithNullability(typeFactory.createSqlType(SqlTypeName.BOOLEAN), SqlInOperator.anyNullable(leftRowType.getFieldList()) || SqlInOperator.anyNullable(rightRowType.getFieldList()));
    }

    private static boolean anyNullable(List<RelDataTypeField> fieldList) {
        for (RelDataTypeField field : fieldList) {
            if (!field.getType().isNullable()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean argumentMustBeScalar(int ordinal) {
        return ordinal == 0;
    }
}

