/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.org.apache.calcite.sql;

import com.hazelcast.org.apache.calcite.rel.type.RelDataType;
import com.hazelcast.org.apache.calcite.sql.SqlBinaryOperator;
import com.hazelcast.org.apache.calcite.sql.SqlCall;
import com.hazelcast.org.apache.calcite.sql.SqlKind;
import com.hazelcast.org.apache.calcite.sql.SqlNode;
import com.hazelcast.org.apache.calcite.sql.SqlWriter;
import com.hazelcast.org.apache.calcite.sql.type.OperandTypes;
import com.hazelcast.org.apache.calcite.sql.type.ReturnTypes;
import com.hazelcast.org.apache.calcite.sql.type.SqlOperandTypeChecker;
import com.hazelcast.org.apache.calcite.sql.validate.SqlValidator;
import com.hazelcast.org.apache.calcite.sql.validate.SqlValidatorScope;
import com.hazelcast.org.apache.calcite.sql.validate.SqlValidatorUtil;
import com.hazelcast.org.apache.calcite.util.Static;
import java.util.Objects;

public class SqlWithinDistinctOperator
extends SqlBinaryOperator {
    public SqlWithinDistinctOperator() {
        super("WITHIN DISTINCT", SqlKind.WITHIN_DISTINCT, 100, true, ReturnTypes.ARG0, null, (SqlOperandTypeChecker)OperandTypes.ANY_IGNORE);
    }

    @Override
    public void unparse(SqlWriter writer, SqlCall call, int leftPrec, int rightPrec) {
        assert (call.operandCount() == 2);
        ((SqlNode)call.operand(0)).unparse(writer, 0, 0);
        writer.keyword("WITHIN DISTINCT");
        SqlWriter.Frame orderFrame = writer.startList(SqlWriter.FrameTypeEnum.GROUP_BY_LIST, "(", ")");
        ((SqlNode)call.operand(1)).unparse(writer, 0, 0);
        writer.endList(orderFrame);
    }

    @Override
    public void validateCall(SqlCall call, SqlValidator validator, SqlValidatorScope scope, SqlValidatorScope operandScope) {
        assert (call.getOperator() == this);
        assert (call.operandCount() == 2);
        SqlValidatorUtil.FlatAggregate flat = SqlValidatorUtil.flatten(call);
        if (!flat.aggregateCall.getOperator().isAggregator()) {
            throw validator.newValidationError(call, Static.RESOURCE.withinDistinctNotAllowed(flat.aggregateCall.getOperator().getName()));
        }
        for (SqlNode order : Objects.requireNonNull(flat.distinctList)) {
            Objects.requireNonNull(validator.deriveType(scope, order));
        }
        validator.validateAggregateParams(flat.aggregateCall, flat.filter, flat.distinctList, flat.orderList, scope);
    }

    @Override
    public RelDataType deriveType(SqlValidator validator, SqlValidatorScope scope, SqlCall call) {
        return this.validateOperands(validator, scope, call);
    }
}

