/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.org.apache.calcite.schema;

import com.hazelcast.com.google.common.collect.ImmutableList;
import com.hazelcast.org.apache.calcite.rel.RelCollation;
import com.hazelcast.org.apache.calcite.rel.RelReferentialConstraint;
import com.hazelcast.org.apache.calcite.schema.Statistic;
import com.hazelcast.org.apache.calcite.util.ImmutableBitSet;
import com.hazelcast.org.checkerframework.checker.nullness.qual.Nullable;
import java.util.List;

public class Statistics {
    public static final Statistic UNKNOWN = new Statistic(){};

    private Statistics() {
    }

    public static Statistic of(@Nullable List<RelReferentialConstraint> referentialConstraints) {
        return Statistics.of(null, null, referentialConstraints, null);
    }

    public static Statistic of(double rowCount, @Nullable List<ImmutableBitSet> keys) {
        return Statistics.of(rowCount, keys, null, null);
    }

    public static Statistic of(double rowCount, @Nullable List<ImmutableBitSet> keys, @Nullable List<RelCollation> collations) {
        return Statistics.of(rowCount, keys, null, collations);
    }

    public static Statistic of(final @Nullable Double rowCount, @Nullable List<ImmutableBitSet> keys, @Nullable List<RelReferentialConstraint> referentialConstraints, @Nullable List<RelCollation> collations) {
        final ImmutableList<Object> keysCopy = keys == null ? ImmutableList.of() : ImmutableList.copyOf(keys);
        final ImmutableList<RelReferentialConstraint> referentialConstraintsCopy = referentialConstraints == null ? null : ImmutableList.copyOf(referentialConstraints);
        final ImmutableList<RelCollation> collationsCopy = collations == null ? null : ImmutableList.copyOf(collations);
        return new Statistic(){

            @Override
            public @Nullable Double getRowCount() {
                return rowCount;
            }

            @Override
            public boolean isKey(ImmutableBitSet columns) {
                for (ImmutableBitSet key : keysCopy) {
                    if (!columns.contains(key)) continue;
                    return true;
                }
                return false;
            }

            @Override
            public @Nullable List<ImmutableBitSet> getKeys() {
                return keysCopy;
            }

            @Override
            public @Nullable List<RelReferentialConstraint> getReferentialConstraints() {
                return referentialConstraintsCopy;
            }

            @Override
            public @Nullable List<RelCollation> getCollations() {
                return collationsCopy;
            }
        };
    }
}

