/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.org.apache.calcite.rel.convert;

import com.hazelcast.org.apache.calcite.plan.RelOptCluster;
import com.hazelcast.org.apache.calcite.plan.RelOptCost;
import com.hazelcast.org.apache.calcite.plan.RelOptPlanner;
import com.hazelcast.org.apache.calcite.plan.RelTraitDef;
import com.hazelcast.org.apache.calcite.plan.RelTraitSet;
import com.hazelcast.org.apache.calcite.rel.RelNode;
import com.hazelcast.org.apache.calcite.rel.SingleRel;
import com.hazelcast.org.apache.calcite.rel.convert.Converter;
import com.hazelcast.org.apache.calcite.rel.metadata.RelMetadataQuery;
import com.hazelcast.org.checkerframework.checker.nullness.qual.Nullable;

public abstract class ConverterImpl
extends SingleRel
implements Converter {
    protected RelTraitSet inTraits;
    protected final @Nullable RelTraitDef traitDef;

    protected ConverterImpl(RelOptCluster cluster, @Nullable RelTraitDef traitDef, RelTraitSet traits, RelNode child) {
        super(cluster, traits, child);
        this.inTraits = child.getTraitSet();
        this.traitDef = traitDef;
    }

    @Override
    public @Nullable RelOptCost computeSelfCost(RelOptPlanner planner, RelMetadataQuery mq) {
        double dRows;
        double dCpu = dRows = mq.getRowCount(this.getInput()).doubleValue();
        double dIo = 0.0;
        return planner.getCostFactory().makeCost(dRows, dCpu, dIo);
    }

    @Deprecated
    protected Error cannotImplement() {
        return new AssertionError((Object)(this.getClass() + " cannot convert from " + this.inTraits + " traits"));
    }

    @Override
    public RelTraitSet getInputTraits() {
        return this.inTraits;
    }

    @Override
    public @Nullable RelTraitDef getTraitDef() {
        return this.traitDef;
    }
}

