/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.org.apache.calcite.adapter.enumerable;

import com.hazelcast.com.google.common.collect.ImmutableList;
import com.hazelcast.org.apache.calcite.DataContext;
import com.hazelcast.org.apache.calcite.adapter.enumerable.EnumUtils;
import com.hazelcast.org.apache.calcite.adapter.enumerable.EnumerableConvention;
import com.hazelcast.org.apache.calcite.adapter.enumerable.EnumerableRel;
import com.hazelcast.org.apache.calcite.adapter.enumerable.EnumerableRelImplementor;
import com.hazelcast.org.apache.calcite.adapter.enumerable.EnumerableTraitsUtils;
import com.hazelcast.org.apache.calcite.adapter.enumerable.PhysType;
import com.hazelcast.org.apache.calcite.adapter.enumerable.PhysTypeImpl;
import com.hazelcast.org.apache.calcite.adapter.enumerable.RexToLixTranslator;
import com.hazelcast.org.apache.calcite.adapter.java.JavaTypeFactory;
import com.hazelcast.org.apache.calcite.linq4j.Enumerator;
import com.hazelcast.org.apache.calcite.linq4j.tree.BlockBuilder;
import com.hazelcast.org.apache.calcite.linq4j.tree.BlockStatement;
import com.hazelcast.org.apache.calcite.linq4j.tree.Blocks;
import com.hazelcast.org.apache.calcite.linq4j.tree.Expression;
import com.hazelcast.org.apache.calcite.linq4j.tree.Expressions;
import com.hazelcast.org.apache.calcite.linq4j.tree.NewExpression;
import com.hazelcast.org.apache.calcite.linq4j.tree.ParameterExpression;
import com.hazelcast.org.apache.calcite.linq4j.tree.Types;
import com.hazelcast.org.apache.calcite.plan.RelOptCluster;
import com.hazelcast.org.apache.calcite.plan.RelOptPredicateList;
import com.hazelcast.org.apache.calcite.plan.RelTraitSet;
import com.hazelcast.org.apache.calcite.rel.RelCollation;
import com.hazelcast.org.apache.calcite.rel.RelCollationTraitDef;
import com.hazelcast.org.apache.calcite.rel.RelDistributionTraitDef;
import com.hazelcast.org.apache.calcite.rel.RelNode;
import com.hazelcast.org.apache.calcite.rel.core.Calc;
import com.hazelcast.org.apache.calcite.rel.metadata.RelMdCollation;
import com.hazelcast.org.apache.calcite.rel.metadata.RelMdDistribution;
import com.hazelcast.org.apache.calcite.rel.metadata.RelMetadataQuery;
import com.hazelcast.org.apache.calcite.rex.RexBuilder;
import com.hazelcast.org.apache.calcite.rex.RexNode;
import com.hazelcast.org.apache.calcite.rex.RexProgram;
import com.hazelcast.org.apache.calcite.rex.RexSimplify;
import com.hazelcast.org.apache.calcite.rex.RexUtil;
import com.hazelcast.org.apache.calcite.sql.validate.SqlConformance;
import com.hazelcast.org.apache.calcite.sql.validate.SqlConformanceEnum;
import com.hazelcast.org.apache.calcite.util.BuiltInMethod;
import com.hazelcast.org.apache.calcite.util.Pair;
import com.hazelcast.org.apache.calcite.util.Util;
import com.hazelcast.org.checkerframework.checker.nullness.qual.Nullable;
import java.lang.reflect.Type;
import java.util.List;

public class EnumerableCalc
extends Calc
implements EnumerableRel {
    public EnumerableCalc(RelOptCluster cluster, RelTraitSet traitSet, RelNode input, RexProgram program) {
        super(cluster, traitSet, ImmutableList.of(), input, program);
        assert (this.getConvention() instanceof EnumerableConvention);
        assert (!program.containsAggs());
    }

    @Deprecated
    public EnumerableCalc(RelOptCluster cluster, RelTraitSet traitSet, RelNode input, RexProgram program, List<RelCollation> collationList) {
        this(cluster, traitSet, input, program);
        Util.discard(collationList);
    }

    public static EnumerableCalc create(RelNode input, RexProgram program) {
        RelOptCluster cluster = input.getCluster();
        RelMetadataQuery mq = cluster.getMetadataQuery();
        RelTraitSet traitSet = cluster.traitSet().replace(EnumerableConvention.INSTANCE).replaceIfs(RelCollationTraitDef.INSTANCE, () -> RelMdCollation.calc(mq, input, program)).replaceIf(RelDistributionTraitDef.INSTANCE, () -> RelMdDistribution.calc(mq, input, program));
        return new EnumerableCalc(cluster, traitSet, input, program);
    }

    @Override
    public EnumerableCalc copy(RelTraitSet traitSet, RelNode child, RexProgram program) {
        return new EnumerableCalc(this.getCluster(), traitSet, child, program);
    }

    @Override
    public EnumerableRel.Result implement(EnumerableRelImplementor implementor, EnumerableRel.Prefer pref) {
        BlockStatement moveNextBody;
        RelMetadataQuery mq;
        RelOptPredicateList predicates;
        RexSimplify simplify;
        JavaTypeFactory typeFactory = implementor.getTypeFactory();
        BlockBuilder builder = new BlockBuilder();
        EnumerableRel child = (EnumerableRel)this.getInput();
        EnumerableRel.Result result = implementor.visitChild(this, 0, child, pref);
        PhysType physType = PhysTypeImpl.of(typeFactory, this.getRowType(), pref.prefer(result.format));
        Type outputJavaType = physType.getJavaRowType();
        Type enumeratorType = Types.of(Enumerator.class, new Type[]{outputJavaType});
        Type inputJavaType = result.physType.getJavaRowType();
        ParameterExpression inputEnumerator = Expressions.parameter(Types.of(Enumerator.class, new Type[]{inputJavaType}), "inputEnumerator");
        Expression input = EnumUtils.convert(Expressions.call((Expression)inputEnumerator, BuiltInMethod.ENUMERATOR_CURRENT.method, new Expression[0]), inputJavaType);
        RexBuilder rexBuilder = this.getCluster().getRexBuilder();
        RexProgram program = this.program.normalize(rexBuilder, simplify = new RexSimplify(rexBuilder, predicates = (mq = this.getCluster().getMetadataQuery()).getPulledUpPredicates(child), RexUtil.EXECUTOR));
        if (program.getCondition() == null) {
            moveNextBody = Blocks.toFunctionBlock(Expressions.call((Expression)inputEnumerator, BuiltInMethod.ENUMERATOR_MOVE_NEXT.method, new Expression[0]));
        } else {
            BlockBuilder builder2 = new BlockBuilder();
            Expression condition = RexToLixTranslator.translateCondition(program, typeFactory, builder2, new RexToLixTranslator.InputGetterImpl(input, result.physType), implementor.allCorrelateVariables, implementor.getConformance());
            builder2.add(Expressions.ifThen(condition, Expressions.return_(null, Expressions.constant(true))));
            moveNextBody = Expressions.block(Expressions.while_(Expressions.call((Expression)inputEnumerator, BuiltInMethod.ENUMERATOR_MOVE_NEXT.method, new Expression[0]), builder2.toBlock()), Expressions.return_(null, Expressions.constant(false)));
        }
        BlockBuilder builder3 = new BlockBuilder();
        SqlConformance conformance = (SqlConformance)implementor.map.getOrDefault("_conformance", SqlConformanceEnum.DEFAULT);
        List<Expression> expressions = RexToLixTranslator.translateProjects(program, typeFactory, conformance, builder3, null, physType, DataContext.ROOT, new RexToLixTranslator.InputGetterImpl(input, result.physType), implementor.allCorrelateVariables);
        builder3.add(Expressions.return_(null, physType.record(expressions)));
        BlockStatement currentBody = builder3.toBlock();
        Expression inputEnumerable = builder.append("inputEnumerable", result.block, false);
        NewExpression body = Expressions.new_(enumeratorType, EnumUtils.NO_EXPRS, Expressions.list(Expressions.fieldDecl(17, inputEnumerator, Expressions.call(inputEnumerable, BuiltInMethod.ENUMERABLE_ENUMERATOR.method, new Expression[0])), EnumUtils.overridingMethodDecl(BuiltInMethod.ENUMERATOR_RESET.method, EnumUtils.NO_PARAMS, Blocks.toFunctionBlock(Expressions.call((Expression)inputEnumerator, BuiltInMethod.ENUMERATOR_RESET.method, new Expression[0]))), EnumUtils.overridingMethodDecl(BuiltInMethod.ENUMERATOR_MOVE_NEXT.method, EnumUtils.NO_PARAMS, moveNextBody), EnumUtils.overridingMethodDecl(BuiltInMethod.ENUMERATOR_CLOSE.method, EnumUtils.NO_PARAMS, Blocks.toFunctionBlock(Expressions.call((Expression)inputEnumerator, BuiltInMethod.ENUMERATOR_CLOSE.method, new Expression[0]))), Expressions.methodDecl(1, Object.class, "current", EnumUtils.NO_PARAMS, currentBody)));
        builder.add(Expressions.return_(null, Expressions.new_(BuiltInMethod.ABSTRACT_ENUMERABLE_CTOR.constructor, EnumUtils.NO_EXPRS, ImmutableList.of(Expressions.methodDecl(1, enumeratorType, BuiltInMethod.ENUMERABLE_ENUMERATOR.method.getName(), EnumUtils.NO_PARAMS, Blocks.toFunctionBlock(body))))));
        return implementor.result(physType, builder.toBlock());
    }

    @Override
    public @Nullable Pair<RelTraitSet, List<RelTraitSet>> passThroughTraits(RelTraitSet required) {
        List<RexNode> exps = Util.transform(this.program.getProjectList(), this.program::expandLocalRef);
        return EnumerableTraitsUtils.passThroughTraitsForProject(required, exps, this.input.getRowType(), this.input.getCluster().getTypeFactory(), this.traitSet);
    }

    @Override
    public @Nullable Pair<RelTraitSet, List<RelTraitSet>> deriveTraits(RelTraitSet childTraits, int childId) {
        List<RexNode> exps = Util.transform(this.program.getProjectList(), this.program::expandLocalRef);
        return EnumerableTraitsUtils.deriveTraitsForProject(childTraits, childId, exps, this.input.getRowType(), this.input.getCluster().getTypeFactory(), this.traitSet);
    }

    @Override
    public RexProgram getProgram() {
        return this.program;
    }
}

