/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.validate.types;

import com.hazelcast.jet.sql.impl.validate.types.HazelcastIntegerType;
import com.hazelcast.org.apache.calcite.rel.type.RelDataType;
import com.hazelcast.org.apache.calcite.rel.type.RelDataTypeFactory;
import com.hazelcast.org.apache.calcite.rel.type.RelDataTypeSystem;
import com.hazelcast.org.apache.calcite.rel.type.RelDataTypeSystemImpl;
import com.hazelcast.org.apache.calcite.sql.type.BasicSqlType;
import com.hazelcast.org.apache.calcite.sql.type.SqlTypeName;

public final class HazelcastTypeSystem
extends RelDataTypeSystemImpl {
    public static final RelDataTypeSystem INSTANCE = new HazelcastTypeSystem();
    public static final int MAX_DECIMAL_PRECISION = 76;
    public static final int MAX_DECIMAL_SCALE = 38;

    private HazelcastTypeSystem() {
    }

    @Override
    public int getMaxNumericPrecision() {
        return 76;
    }

    @Override
    public int getMaxNumericScale() {
        return 38;
    }

    @Override
    public RelDataType deriveSumType(RelDataTypeFactory typeFactory, RelDataType argumentType) {
        if (argumentType instanceof BasicSqlType) {
            SqlTypeName type = HazelcastTypeSystem.deriveSumType(argumentType.getSqlTypeName());
            if (type == SqlTypeName.BIGINT) {
                return HazelcastIntegerType.create(64, argumentType.isNullable());
            }
            if (type.allowsPrec() && argumentType.getPrecision() != -1) {
                int precision = typeFactory.getTypeSystem().getMaxPrecision(type);
                if (type.allowsScale()) {
                    return typeFactory.createTypeWithNullability(typeFactory.createSqlType(type, precision, argumentType.getScale()), argumentType.isNullable());
                }
                return typeFactory.createTypeWithNullability(typeFactory.createSqlType(type, precision), argumentType.isNullable());
            }
            return typeFactory.createTypeWithNullability(typeFactory.createSqlType(type), argumentType.isNullable());
        }
        return argumentType;
    }

    private static SqlTypeName deriveSumType(SqlTypeName type) {
        switch (type) {
            case TINYINT: 
            case SMALLINT: 
            case INTEGER: {
                return SqlTypeName.BIGINT;
            }
            case BIGINT: 
            case DECIMAL: {
                return SqlTypeName.DECIMAL;
            }
            case REAL: 
            case DOUBLE: {
                return SqlTypeName.DOUBLE;
            }
        }
        return type;
    }

    @Override
    public RelDataType deriveAvgAggType(RelDataTypeFactory typeFactory, RelDataType argumentType) {
        switch (argumentType.getSqlTypeName()) {
            case TINYINT: 
            case SMALLINT: 
            case INTEGER: 
            case BIGINT: 
            case DECIMAL: {
                return typeFactory.createTypeWithNullability(typeFactory.createSqlType(SqlTypeName.DECIMAL), argumentType.isNullable());
            }
            case REAL: 
            case DOUBLE: {
                return typeFactory.createTypeWithNullability(typeFactory.createSqlType(SqlTypeName.DOUBLE), argumentType.isNullable());
            }
        }
        return argumentType;
    }
}

