/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.validate.operators.string;

import com.hazelcast.jet.sql.impl.validate.HazelcastCallBinding;
import com.hazelcast.jet.sql.impl.validate.HazelcastSqlValidator;
import com.hazelcast.jet.sql.impl.validate.operators.common.HazelcastBinaryOperator;
import com.hazelcast.jet.sql.impl.validate.operators.typeinference.ReplaceUnknownOperandTypeInference;
import com.hazelcast.jet.sql.impl.validate.param.AnyToVarcharParameterConverter;
import com.hazelcast.jet.sql.impl.validate.types.HazelcastTypeUtils;
import com.hazelcast.org.apache.calcite.rel.type.RelDataType;
import com.hazelcast.org.apache.calcite.sql.SqlDynamicParam;
import com.hazelcast.org.apache.calcite.sql.SqlKind;
import com.hazelcast.org.apache.calcite.sql.SqlNode;
import com.hazelcast.org.apache.calcite.sql.SqlOperandCountRange;
import com.hazelcast.org.apache.calcite.sql.fun.SqlStdOperatorTable;
import com.hazelcast.org.apache.calcite.sql.type.ReturnTypes;
import com.hazelcast.org.apache.calcite.sql.type.SqlOperandCountRanges;
import com.hazelcast.org.apache.calcite.sql.type.SqlTypeName;

public final class HazelcastConcatOperator
extends HazelcastBinaryOperator {
    public static final HazelcastConcatOperator INSTANCE = new HazelcastConcatOperator();

    private HazelcastConcatOperator() {
        super("||", SqlKind.OTHER, SqlStdOperatorTable.CONCAT.getLeftPrec(), true, ReturnTypes.DYADIC_STRING_SUM_PRECISION_NULLABLE, new ReplaceUnknownOperandTypeInference(SqlTypeName.VARCHAR));
    }

    @Override
    public SqlOperandCountRange getOperandCountRange() {
        return SqlOperandCountRanges.from(1);
    }

    @Override
    public boolean checkOperandTypes(HazelcastCallBinding binding, boolean throwOnFailure) {
        HazelcastSqlValidator validator = binding.getValidator();
        for (int i = 0; i < binding.getOperandCount(); ++i) {
            SqlNode operand = binding.operand(i);
            RelDataType operandType = binding.getOperandType(i);
            if (operandType.getSqlTypeName() != SqlTypeName.VARCHAR) {
                RelDataType newOperandType = HazelcastTypeUtils.createType(validator.getTypeFactory(), SqlTypeName.VARCHAR, operandType.isNullable());
                validator.getTypeCoercion().coerceOperandType(binding.getScope(), binding.getCall(), i, newOperandType);
            }
            if (operand.getKind() != SqlKind.DYNAMIC_PARAM) continue;
            int paramIndex = ((SqlDynamicParam)operand).getIndex();
            AnyToVarcharParameterConverter paramConverter = new AnyToVarcharParameterConverter(paramIndex, operand.getParserPosition());
            validator.setParameterConverter(paramIndex, paramConverter);
        }
        return true;
    }
}

