/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.parse;

import com.hazelcast.jet.sql.impl.parse.SqlOption;
import com.hazelcast.jet.sql.impl.parse.SqlTypeColumn;
import com.hazelcast.org.apache.calcite.sql.SqlCreate;
import com.hazelcast.org.apache.calcite.sql.SqlIdentifier;
import com.hazelcast.org.apache.calcite.sql.SqlKind;
import com.hazelcast.org.apache.calcite.sql.SqlNode;
import com.hazelcast.org.apache.calcite.sql.SqlNodeList;
import com.hazelcast.org.apache.calcite.sql.SqlOperator;
import com.hazelcast.org.apache.calcite.sql.SqlSpecialOperator;
import com.hazelcast.org.apache.calcite.sql.SqlWriter;
import com.hazelcast.org.apache.calcite.sql.parser.SqlParserPos;
import com.hazelcast.org.apache.calcite.sql.validate.SqlValidator;
import com.hazelcast.org.apache.calcite.sql.validate.SqlValidatorScope;
import com.hazelcast.org.apache.calcite.util.ImmutableNullableList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;

public class SqlCreateType
extends SqlCreate {
    private static final SqlSpecialOperator OPERATOR = new SqlSpecialOperator("CREATE TYPE", SqlKind.CREATE_TYPE);
    private final SqlIdentifier name;
    private final SqlNodeList columns;
    private final SqlNodeList options;

    public SqlCreateType(SqlIdentifier name, SqlNodeList columns, SqlNodeList options, boolean replace, boolean ifNotExists, SqlParserPos pos) {
        super(OPERATOR, pos, replace, ifNotExists);
        this.name = Objects.requireNonNull(name, "Name should not be null");
        this.columns = Objects.requireNonNull(columns, "Columns should not be null");
        this.options = Objects.requireNonNull(options, "Options should not be null");
    }

    @Override
    public List<SqlNode> getOperandList() {
        return ImmutableNullableList.of(this.name, this.columns, this.options);
    }

    @Override
    public SqlOperator getOperator() {
        return OPERATOR;
    }

    @Override
    public void validate(SqlValidator validator, SqlValidatorScope scope) {
    }

    @Override
    public void unparse(SqlWriter writer, int leftPrec, int rightPrec) {
        writer.keyword("CREATE");
        if (this.getReplace()) {
            writer.keyword("OR REPLACE");
        }
        if (this.ifNotExists) {
            writer.keyword("IF NOT EXISTS");
        }
        this.name.unparse(writer, leftPrec, rightPrec);
        if (!this.columns.isEmpty()) {
            writer.keyword("(");
            for (SqlNode column : this.columns) {
                writer.sep(",", false);
                column.unparse(writer, leftPrec, rightPrec);
            }
            writer.keyword(")");
        }
        if (this.options().isEmpty()) {
            return;
        }
        writer.keyword("OPTIONS");
        writer.keyword("(");
        for (SqlNode option : this.options) {
            writer.sep(",", false);
            option.unparse(writer, leftPrec, rightPrec);
        }
        writer.keyword(")");
    }

    public String getName() {
        return this.name.getSimple();
    }

    public boolean ifNotExists() {
        return this.ifNotExists;
    }

    public Stream<SqlTypeColumn> columns() {
        return this.columns.getList().stream().map(node -> (SqlTypeColumn)node);
    }

    public Map<String, String> options() {
        return this.options.getList().stream().map(node -> (SqlOption)node).collect(LinkedHashMap::new, (map, option) -> map.putIfAbsent(option.keyString(), option.valueString()), Map::putAll);
    }
}

