/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.opt.physical;

import com.hazelcast.jet.impl.util.Util;
import com.hazelcast.jet.sql.impl.opt.Conventions;
import com.hazelcast.jet.sql.impl.opt.OptUtils;
import com.hazelcast.jet.sql.impl.opt.logical.SlidingWindowLogicalRel;
import com.hazelcast.jet.sql.impl.opt.physical.SlidingWindowPhysicalRel;
import com.hazelcast.org.apache.calcite.plan.RelOptRule;
import com.hazelcast.org.apache.calcite.rel.RelNode;
import com.hazelcast.org.apache.calcite.rel.convert.ConverterRule;

final class SlidingWindowPhysicalRule
extends ConverterRule {
    static final RelOptRule INSTANCE = new SlidingWindowPhysicalRule();

    private SlidingWindowPhysicalRule() {
        super(SlidingWindowLogicalRel.class, Conventions.LOGICAL, Conventions.PHYSICAL, SlidingWindowPhysicalRule.class.getSimpleName());
    }

    @Override
    public RelNode convert(RelNode rel) {
        SlidingWindowLogicalRel logicalWindow = (SlidingWindowLogicalRel)rel;
        return new SlidingWindowPhysicalRel(logicalWindow.getCluster(), OptUtils.toPhysicalConvention(logicalWindow.getTraitSet()), Util.toList(logicalWindow.getInputs(), OptUtils::toPhysicalInput), logicalWindow.getCall(), logicalWindow.getElementType(), logicalWindow.getRowType(), logicalWindow.getColumnMappings());
    }
}

