/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.opt.physical;

import com.hazelcast.internal.util.CollectionUtil;
import com.hazelcast.jet.core.Vertex;
import com.hazelcast.jet.sql.impl.HazelcastPhysicalScan;
import com.hazelcast.jet.sql.impl.JetJoinInfo;
import com.hazelcast.jet.sql.impl.opt.OptUtils;
import com.hazelcast.jet.sql.impl.opt.physical.CreateDagVisitor;
import com.hazelcast.jet.sql.impl.opt.physical.JoinPhysicalRel;
import com.hazelcast.jet.sql.impl.schema.HazelcastTable;
import com.hazelcast.jet.sql.impl.validate.HazelcastSqlOperatorTable;
import com.hazelcast.org.apache.calcite.plan.RelOptCluster;
import com.hazelcast.org.apache.calcite.plan.RelTraitSet;
import com.hazelcast.org.apache.calcite.rel.RelNode;
import com.hazelcast.org.apache.calcite.rel.core.Join;
import com.hazelcast.org.apache.calcite.rel.core.JoinRelType;
import com.hazelcast.org.apache.calcite.rex.RexBuilder;
import com.hazelcast.org.apache.calcite.rex.RexInputRef;
import com.hazelcast.org.apache.calcite.rex.RexNode;
import com.hazelcast.org.apache.calcite.rex.RexShuttle;
import com.hazelcast.org.apache.calcite.rex.RexUtil;
import com.hazelcast.org.apache.calcite.sql.SqlOperator;
import com.hazelcast.sql.impl.QueryParameterMetadata;
import com.hazelcast.sql.impl.expression.Expression;
import com.hazelcast.sql.impl.plan.node.PlanNodeFieldTypeProvider;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class JoinNestedLoopPhysicalRel
extends JoinPhysicalRel {
    JoinNestedLoopPhysicalRel(RelOptCluster cluster, RelTraitSet traitSet, RelNode left, RelNode right, RexNode condition, JoinRelType joinType) {
        super(cluster, traitSet, left, right, condition, joinType);
    }

    public Expression<Boolean> rightFilter(QueryParameterMetadata parameterMetadata) {
        return ((HazelcastPhysicalScan)this.getRight()).filter(parameterMetadata);
    }

    public List<Expression<?>> rightProjection(QueryParameterMetadata parameterMetadata) {
        return ((HazelcastPhysicalScan)this.getRight()).projection(parameterMetadata);
    }

    public JetJoinInfo joinInfo(QueryParameterMetadata parameterMetadata) {
        List<Integer> leftKeys = this.analyzeCondition().leftKeys.toIntegerList();
        List<Integer> rightKeys = this.analyzeCondition().rightKeys.toIntegerList();
        HazelcastTable table = OptUtils.extractHazelcastTable(this.getRight());
        final RexBuilder rexBuilder = this.getCluster().getRexBuilder();
        ArrayList<RexNode> additionalNonEquiConditions = new ArrayList<RexNode>();
        for (int i = 0; i < rightKeys.size(); ++i) {
            Integer rightKeyIndex = rightKeys.get(i);
            RexNode rightExpr = table.getProjects().get(rightKeyIndex);
            if (rightExpr instanceof RexInputRef) {
                rightKeys.set(i, ((RexInputRef)rightExpr).getIndex());
                continue;
            }
            rightExpr = rightExpr.accept(new RexShuttle(){

                @Override
                public RexNode visitInputRef(RexInputRef inputRef) {
                    return rexBuilder.makeInputRef(inputRef.getType(), inputRef.getIndex() + JoinNestedLoopPhysicalRel.this.getLeft().getRowType().getFieldCount());
                }
            });
            additionalNonEquiConditions.add(rexBuilder.makeCall((SqlOperator)HazelcastSqlOperatorTable.EQUALS, rexBuilder.makeInputRef(this.getLeft(), (int)leftKeys.get(i)), rightExpr));
            leftKeys.remove(i);
            rightKeys.remove(i);
            --i;
        }
        Expression<Boolean> nonEquiCondition = this.filter((PlanNodeFieldTypeProvider)this.schema(parameterMetadata), RexUtil.composeConjunction(rexBuilder, Arrays.asList(this.analyzeCondition().getRemaining(rexBuilder), RexUtil.composeConjunction(rexBuilder, additionalNonEquiConditions))), parameterMetadata);
        Expression<Boolean> condition = this.filter((PlanNodeFieldTypeProvider)this.schema(parameterMetadata), this.getCondition(), parameterMetadata);
        return new JetJoinInfo(this.getJoinType(), CollectionUtil.toIntArray(leftKeys), CollectionUtil.toIntArray(rightKeys), nonEquiCondition, condition);
    }

    @Override
    public Vertex accept(CreateDagVisitor visitor) {
        return visitor.onNestedLoopJoin(this);
    }

    @Override
    public Join copy(RelTraitSet traitSet, RexNode conditionExpr, RelNode left, RelNode right, JoinRelType joinType, boolean semiJoinDone) {
        return new JoinNestedLoopPhysicalRel(this.getCluster(), traitSet, left, right, this.getCondition(), joinType);
    }
}

