/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.opt.physical;

import com.hazelcast.config.IndexType;
import com.hazelcast.function.ComparatorEx;
import com.hazelcast.jet.core.Vertex;
import com.hazelcast.jet.impl.util.Util;
import com.hazelcast.jet.sql.impl.ExpressionUtil;
import com.hazelcast.jet.sql.impl.HazelcastPhysicalScan;
import com.hazelcast.jet.sql.impl.opt.FieldCollation;
import com.hazelcast.jet.sql.impl.opt.OptUtils;
import com.hazelcast.jet.sql.impl.opt.cost.CostUtils;
import com.hazelcast.jet.sql.impl.opt.physical.CreateDagVisitor;
import com.hazelcast.jet.sql.impl.schema.HazelcastTable;
import com.hazelcast.org.apache.calcite.plan.RelOptCluster;
import com.hazelcast.org.apache.calcite.plan.RelOptCost;
import com.hazelcast.org.apache.calcite.plan.RelOptPlanner;
import com.hazelcast.org.apache.calcite.plan.RelOptTable;
import com.hazelcast.org.apache.calcite.plan.RelTraitSet;
import com.hazelcast.org.apache.calcite.rel.RelCollation;
import com.hazelcast.org.apache.calcite.rel.RelCollationTraitDef;
import com.hazelcast.org.apache.calcite.rel.RelNode;
import com.hazelcast.org.apache.calcite.rel.RelWriter;
import com.hazelcast.org.apache.calcite.rel.core.TableScan;
import com.hazelcast.org.apache.calcite.rel.metadata.RelMdUtil;
import com.hazelcast.org.apache.calcite.rel.metadata.RelMetadataQuery;
import com.hazelcast.org.apache.calcite.rex.RexNode;
import com.hazelcast.sql.impl.QueryParameterMetadata;
import com.hazelcast.sql.impl.exec.scan.index.IndexFilter;
import com.hazelcast.sql.impl.expression.Expression;
import com.hazelcast.sql.impl.plan.node.PlanNodeFieldTypeProvider;
import com.hazelcast.sql.impl.plan.node.PlanNodeSchema;
import com.hazelcast.sql.impl.row.JetSqlRow;
import com.hazelcast.sql.impl.schema.map.MapTableIndex;
import java.util.List;
import java.util.stream.Collectors;

public class IndexScanMapPhysicalRel
extends TableScan
implements HazelcastPhysicalScan {
    private final MapTableIndex index;
    private final IndexFilter indexFilter;
    private final RexNode indexExp;
    private final RexNode remainderExp;

    public IndexScanMapPhysicalRel(RelOptCluster cluster, RelTraitSet traitSet, RelOptTable table, MapTableIndex index, IndexFilter indexFilter, RexNode indexExp, RexNode remainderExp) {
        super(cluster, traitSet, table);
        this.index = index;
        this.indexFilter = indexFilter;
        this.indexExp = indexExp;
        this.remainderExp = remainderExp;
    }

    public MapTableIndex getIndex() {
        return this.index;
    }

    public IndexFilter getIndexFilter() {
        return this.indexFilter;
    }

    public RexNode getRemainderExp() {
        return this.remainderExp;
    }

    public ComparatorEx<JetSqlRow> getComparator() {
        if (this.index.getType() == IndexType.SORTED) {
            RelCollation relCollation = this.getTraitSet().getTrait(RelCollationTraitDef.INSTANCE);
            List<FieldCollation> collations = relCollation.getFieldCollations().stream().map(FieldCollation::new).collect(Collectors.toList());
            return ExpressionUtil.comparisonFn(collations);
        }
        return null;
    }

    public boolean isDescending() {
        boolean descending = false;
        RelCollation relCollation = this.getTraitSet().getTrait(RelCollationTraitDef.INSTANCE);
        if (!relCollation.getFieldCollations().isEmpty()) {
            descending = relCollation.getFieldCollations().get(0).getDirection().isDescending();
        }
        return descending;
    }

    @Override
    public Expression<Boolean> filter(QueryParameterMetadata parameterMetadata) {
        PlanNodeSchema schema = OptUtils.schema(this.getTable());
        return this.filter((PlanNodeFieldTypeProvider)schema, this.remainderExp, parameterMetadata);
    }

    @Override
    public List<Expression<?>> projection(QueryParameterMetadata parameterMetadata) {
        PlanNodeSchema schema = OptUtils.schema(this.getTable());
        HazelcastTable table = this.getTable().unwrap(HazelcastTable.class);
        return this.project((PlanNodeFieldTypeProvider)schema, table.getProjects(), parameterMetadata);
    }

    public HazelcastTable getTableUnwrapped() {
        return this.table.unwrap(HazelcastTable.class);
    }

    @Override
    public PlanNodeSchema schema(QueryParameterMetadata parameterMetadata) {
        List fieldTypes = Util.toList(this.projection(parameterMetadata), Expression::getType);
        return new PlanNodeSchema(fieldTypes);
    }

    @Override
    public Vertex accept(CreateDagVisitor visitor) {
        return visitor.onMapIndexScan(this);
    }

    @Override
    public double estimateRowCount(RelMetadataQuery mq) {
        double rowCount = this.table.getRowCount();
        if (this.indexExp != null) {
            rowCount = CostUtils.adjustFilteredRowCount(rowCount, RelMdUtil.guessSelectivity(this.indexExp));
        }
        if (this.remainderExp != null) {
            rowCount = CostUtils.adjustFilteredRowCount(rowCount, RelMdUtil.guessSelectivity(this.remainderExp));
        }
        return rowCount;
    }

    @Override
    public RelOptCost computeSelfCost(RelOptPlanner planner, RelMetadataQuery mq) {
        double scanRowCount = this.table.getRowCount();
        if (this.indexExp != null) {
            scanRowCount = CostUtils.adjustFilteredRowCount(scanRowCount, RelMdUtil.guessSelectivity(this.indexExp));
        }
        boolean hasFilter = this.remainderExp != null;
        double filterRowCount = scanRowCount;
        if (hasFilter) {
            filterRowCount = CostUtils.adjustFilteredRowCount(filterRowCount, RelMdUtil.guessSelectivity(this.remainderExp));
        }
        return IndexScanMapPhysicalRel.computeSelfCost(planner, scanRowCount, CostUtils.indexScanCpuMultiplier(this.index.getType()), hasFilter, filterRowCount, this.getTableUnwrapped().getProjects().size());
    }

    private static RelOptCost computeSelfCost(RelOptPlanner planner, double scanRowCount, double scanCostMultiplier, boolean hasFilter, double filterRowCount, int projectCount) {
        double scanCpu = scanRowCount * scanCostMultiplier;
        double filterCpu = hasFilter ? CostUtils.adjustCpuForConstrainedScan(scanCpu) : 0.0;
        double projectCpu = CostUtils.adjustCpuForConstrainedScan(CostUtils.getProjectCpu(filterRowCount, projectCount));
        return planner.getCostFactory().makeCost(filterRowCount, scanCpu + filterCpu + projectCpu, 0.0);
    }

    @Override
    public RelWriter explainTerms(RelWriter pw) {
        return super.explainTerms(pw).item("index", this.index.getName()).item("indexExp", this.indexExp).item("remainderExp", this.remainderExp);
    }

    @Override
    public RelNode copy(RelTraitSet traitSet, List<RelNode> inputs) {
        return new IndexScanMapPhysicalRel(this.getCluster(), traitSet, this.getTable(), this.index, this.indexFilter, this.indexExp, this.remainderExp);
    }
}

