/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.opt.metadata;

import com.hazelcast.org.apache.calcite.util.ImmutableBitSet;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;

public final class WatermarkedFields
implements Serializable {
    private final Set<Integer> fieldIndexes;

    public WatermarkedFields(Set<Integer> fieldIndexes) {
        this.fieldIndexes = Collections.unmodifiableSet(fieldIndexes);
    }

    public WatermarkedFields union(WatermarkedFields other) {
        if (other == null || other.fieldIndexes.isEmpty()) {
            return this;
        }
        HashSet<Integer> newWatermarkedFields = new HashSet<Integer>(this.fieldIndexes);
        newWatermarkedFields.addAll(other.fieldIndexes);
        assert (this.fieldIndexes.size() + other.fieldIndexes.size() == newWatermarkedFields.size());
        return new WatermarkedFields(newWatermarkedFields);
    }

    public int findFirst() {
        return this.fieldIndexes.iterator().next();
    }

    @Nullable
    public Integer findFirst(ImmutableBitSet indices) {
        for (Integer entry : this.fieldIndexes) {
            if (!indices.get(entry)) continue;
            return entry;
        }
        return null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WatermarkedFields that = (WatermarkedFields)o;
        return Objects.equals(this.fieldIndexes, that.fieldIndexes);
    }

    public int hashCode() {
        return Objects.hash(this.fieldIndexes);
    }

    public boolean isEmpty() {
        return this.fieldIndexes.isEmpty();
    }

    public Set<Integer> getFieldIndexes() {
        return this.fieldIndexes;
    }
}

