/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.connector.kafka;

import com.hazelcast.function.FunctionEx;
import com.hazelcast.jet.core.DAG;
import com.hazelcast.jet.core.Edge;
import com.hazelcast.jet.core.EventTimePolicy;
import com.hazelcast.jet.core.ProcessorMetaSupplier;
import com.hazelcast.jet.core.ProcessorSupplier;
import com.hazelcast.jet.core.Vertex;
import com.hazelcast.jet.kafka.KafkaProcessors;
import com.hazelcast.jet.sql.impl.connector.SqlConnector;
import com.hazelcast.jet.sql.impl.connector.kafka.KafkaTable;
import com.hazelcast.jet.sql.impl.connector.kafka.RowProjectorProcessorSupplier;
import com.hazelcast.jet.sql.impl.connector.keyvalue.KvMetadata;
import com.hazelcast.jet.sql.impl.connector.keyvalue.KvMetadataAvroResolver;
import com.hazelcast.jet.sql.impl.connector.keyvalue.KvMetadataJavaResolver;
import com.hazelcast.jet.sql.impl.connector.keyvalue.KvMetadataJsonResolver;
import com.hazelcast.jet.sql.impl.connector.keyvalue.KvMetadataNullResolver;
import com.hazelcast.jet.sql.impl.connector.keyvalue.KvMetadataResolver;
import com.hazelcast.jet.sql.impl.connector.keyvalue.KvMetadataResolvers;
import com.hazelcast.jet.sql.impl.connector.keyvalue.KvProcessors;
import com.hazelcast.spi.impl.NodeEngine;
import com.hazelcast.sql.impl.expression.Expression;
import com.hazelcast.sql.impl.expression.ExpressionEvalContext;
import com.hazelcast.sql.impl.row.JetSqlRow;
import com.hazelcast.sql.impl.schema.ConstantTableStatistics;
import com.hazelcast.sql.impl.schema.MappingField;
import com.hazelcast.sql.impl.schema.Table;
import com.hazelcast.sql.impl.schema.TableField;
import com.hazelcast.sql.impl.schema.TableStatistics;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class KafkaSqlConnector
implements SqlConnector {
    public static final String TYPE_NAME = "Kafka";
    private static final KvMetadataResolvers METADATA_RESOLVERS = new KvMetadataResolvers(new KvMetadataResolver[]{KvMetadataNullResolver.INSTANCE, KvMetadataJavaResolver.INSTANCE, KvMetadataJsonResolver.INSTANCE, KvMetadataAvroResolver.INSTANCE}, new KvMetadataResolver[]{KvMetadataJavaResolver.INSTANCE, KvMetadataJsonResolver.INSTANCE, KvMetadataAvroResolver.INSTANCE});

    @Override
    public String typeName() {
        return TYPE_NAME;
    }

    @Override
    public boolean isStream() {
        return true;
    }

    @Override
    @Nonnull
    public List<MappingField> resolveAndValidateFields(@Nonnull NodeEngine nodeEngine, @Nonnull Map<String, String> options, @Nonnull List<MappingField> userFields, @Nonnull String externalName) {
        return METADATA_RESOLVERS.resolveAndValidateFields(userFields, options, nodeEngine);
    }

    @Override
    @Nonnull
    public Table createTable(@Nonnull NodeEngine nodeEngine, @Nonnull String schemaName, @Nonnull String mappingName, @Nonnull String externalName, @Nonnull Map<String, String> options, @Nonnull List<MappingField> resolvedFields) {
        KvMetadata keyMetadata = METADATA_RESOLVERS.resolveMetadata(true, resolvedFields, options, null);
        KvMetadata valueMetadata = METADATA_RESOLVERS.resolveMetadata(false, resolvedFields, options, null);
        List<TableField> fields = Stream.concat(keyMetadata.getFields().stream(), valueMetadata.getFields().stream()).collect(Collectors.toList());
        return new KafkaTable(this, schemaName, mappingName, fields, (TableStatistics)new ConstantTableStatistics(0L), externalName, options, keyMetadata.getQueryTargetDescriptor(), keyMetadata.getUpsertTargetDescriptor(), valueMetadata.getQueryTargetDescriptor(), valueMetadata.getUpsertTargetDescriptor());
    }

    @Override
    @Nonnull
    public Vertex fullScanReader(@Nonnull DAG dag, @Nonnull Table table0, @Nullable Expression<Boolean> predicate, @Nonnull List<Expression<?>> projections, @Nullable FunctionEx<ExpressionEvalContext, EventTimePolicy<JetSqlRow>> eventTimePolicyProvider) {
        KafkaTable table = (KafkaTable)table0;
        return dag.newUniqueVertex(table.toString(), ProcessorMetaSupplier.of((int)4, (ProcessorSupplier)new RowProjectorProcessorSupplier(table.kafkaConsumerProperties(), table.topicName(), eventTimePolicyProvider, table.paths(), table.types(), table.keyQueryDescriptor(), table.valueQueryDescriptor(), predicate, projections)));
    }

    @Override
    @Nonnull
    public SqlConnector.VertexWithInputConfig insertProcessor(@Nonnull DAG dag, @Nonnull Table table) {
        return new SqlConnector.VertexWithInputConfig(this.writeProcessor(dag, table));
    }

    @Override
    @Nonnull
    public Vertex sinkProcessor(@Nonnull DAG dag, @Nonnull Table table) {
        return this.writeProcessor(dag, table);
    }

    @Nonnull
    private Vertex writeProcessor(DAG dag, Table table0) {
        KafkaTable table = (KafkaTable)table0;
        Vertex vStart = dag.newUniqueVertex("Project(" + (Object)((Object)table) + ")", KvProcessors.entryProjector(table.paths(), table.types(), table.keyUpsertDescriptor(), table.valueUpsertDescriptor(), false));
        vStart.localParallelism(1);
        Vertex vEnd = dag.newUniqueVertex(table.toString(), KafkaProcessors.writeKafkaP((Properties)table.kafkaProducerProperties(), (String)table.topicName(), Map.Entry::getKey, Map.Entry::getValue, (boolean)true));
        dag.edge(Edge.between((Vertex)vStart, (Vertex)vEnd));
        return vStart;
    }
}

