/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.connector.jdbc;

import com.hazelcast.jet.sql.impl.connector.jdbc.JdbcTable;
import com.hazelcast.jet.sql.impl.connector.jdbc.JdbcTableField;
import com.hazelcast.jet.sql.impl.connector.jdbc.ParamCollectingVisitor;
import com.hazelcast.org.apache.calcite.rel.rel2sql.SqlImplementor;
import com.hazelcast.org.apache.calcite.rex.RexNode;
import com.hazelcast.org.apache.calcite.sql.SqlDialect;
import com.hazelcast.org.apache.calcite.sql.SqlIdentifier;
import com.hazelcast.org.apache.calcite.sql.SqlNode;
import com.hazelcast.org.apache.calcite.sql.parser.SqlParserPos;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

class UpdateQueryBuilder {
    private final String query;
    private final ParamCollectingVisitor paramCollectingVisitor = new ParamCollectingVisitor();

    UpdateQueryBuilder(JdbcTable table, List<String> pkFields, Map<String, RexNode> updates) {
        SqlDialect dialect = table.sqlDialect();
        SqlImplementor.SimpleContext simpleContext = new SqlImplementor.SimpleContext(dialect, value -> {
            JdbcTableField field = (JdbcTableField)table.getField(value);
            return new SqlIdentifier(field.externalName(), SqlParserPos.ZERO);
        });
        String setSqlFragment = updates.entrySet().stream().map(entry -> {
            SqlNode sqlNode = simpleContext.toSql(null, (RexNode)entry.getValue());
            sqlNode.accept(this.paramCollectingVisitor);
            return '\"' + table.getField((String)entry.getKey()).externalName() + "\" =" + sqlNode.toSqlString(dialect).toString();
        }).collect(Collectors.joining(", "));
        String whereClause = pkFields.stream().map(e -> '\"' + e + "\" = ?").collect(Collectors.joining(" AND "));
        this.query = "UPDATE " + table.getExternalName() + " SET " + setSqlFragment + " WHERE " + whereClause;
    }

    String query() {
        return this.query;
    }

    int[] parameterPositions() {
        return this.paramCollectingVisitor.parameterPositions();
    }
}

