/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.kinesis;

import com.hazelcast.function.FunctionEx;
import com.hazelcast.function.SupplierEx;
import com.hazelcast.jet.core.ProcessorMetaSupplier;
import com.hazelcast.jet.impl.pipeline.SinkImpl;
import com.hazelcast.jet.kinesis.impl.AwsConfig;
import com.hazelcast.jet.kinesis.impl.sink.KinesisSinkPSupplier;
import com.hazelcast.jet.pipeline.Sink;
import com.hazelcast.jet.retry.IntervalFunction;
import com.hazelcast.jet.retry.RetryStrategies;
import com.hazelcast.jet.retry.RetryStrategy;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class KinesisSinks {
    public static final int MAXIMUM_KEY_LENGTH = 256;
    public static final int MAX_RECORD_SIZE = 0x100000;
    public static final String BATCH_SIZE_METRIC = "batchSize";
    public static final String THROTTLING_SLEEP_METRIC = "throttlingSleep";

    private KinesisSinks() {
    }

    @Nonnull
    public static <T> Builder<T> kinesis(@Nonnull String stream, @Nonnull FunctionEx<T, String> keyFn, @Nonnull FunctionEx<T, byte[]> valueFn) {
        return new Builder(stream, keyFn, valueFn);
    }

    @Nonnull
    public static Builder<Map.Entry<String, byte[]>> kinesis(@Nonnull String stream) {
        return new Builder<Map.Entry<String, byte[]>>(stream, Map.Entry::getKey, Map.Entry::getValue);
    }

    public static final class Builder<T> {
        private static final long INITIAL_RETRY_TIMEOUT_MS = 100L;
        private static final long MAXIMUM_RETRY_TIMEOUT_MS = 3000L;
        private static final double EXPONENTIAL_BACKOFF_MULTIPLIER = 2.0;
        private static final RetryStrategy DEFAULT_RETRY_STRATEGY = RetryStrategies.custom().intervalFunction(IntervalFunction.exponentialBackoffWithCap((long)100L, (double)2.0, (long)3000L)).build();
        @Nonnull
        private final String stream;
        @Nonnull
        private final FunctionEx<T, String> keyFn;
        @Nonnull
        private final FunctionEx<T, byte[]> valueFn;
        @Nonnull
        private final AwsConfig awsConfig = new AwsConfig();
        @Nonnull
        private RetryStrategy retryStrategy = DEFAULT_RETRY_STRATEGY;

        private Builder(@Nonnull String stream, @Nonnull FunctionEx<T, String> keyFn, @Nonnull FunctionEx<T, byte[]> valueFn) {
            this.stream = stream;
            this.keyFn = keyFn;
            this.valueFn = valueFn;
        }

        @Nonnull
        public Builder<T> withEndpoint(@Nullable String endpoint) {
            this.awsConfig.withEndpoint(endpoint);
            return this;
        }

        @Nonnull
        public Builder<T> withRegion(@Nullable String region) {
            this.awsConfig.withRegion(region);
            return this;
        }

        @Nonnull
        public Builder<T> withCredentials(@Nullable String accessKey, @Nullable String secretKey) {
            this.awsConfig.withCredentials(accessKey, secretKey);
            return this;
        }

        @Nonnull
        public Builder<T> withRetryStrategy(@Nonnull RetryStrategy retryStrategy) {
            this.retryStrategy = retryStrategy;
            return this;
        }

        @Nonnull
        public Builder<T> withExecutorServiceSupplier(@Nonnull SupplierEx<ExecutorService> executorSupplier) {
            this.awsConfig.withExecutorServiceSupplier(executorSupplier);
            return this;
        }

        @Nonnull
        public Sink<T> build() {
            String name = "Kinesis Sink (" + this.stream + ")";
            KinesisSinkPSupplier<T> supplier = new KinesisSinkPSupplier<T>(this.awsConfig, this.stream, this.keyFn, this.valueFn, this.retryStrategy);
            return new SinkImpl(name, ProcessorMetaSupplier.of(supplier), SinkImpl.Type.DISTRIBUTED_PARTITIONED, this.keyFn);
        }
    }
}

