/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.geo;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Comparator;
import java.util.List;
import org.apache.lucene.util.BitUtil;
import org.elasticsearch.common.geo.GeoPoint;
import org.elasticsearch.common.geo.SphericalMercatorUtils;
import org.elasticsearch.common.io.stream.BytesStreamOutput;
import org.elasticsearch.geometry.Rectangle;
import org.elasticsearch.search.aggregations.bucket.geogrid.GeoTileUtils;

public class SimpleFeatureFactory {
    private final int extent;
    private final double pointXScale;
    private final double pointYScale;
    private final double pointXTranslate;
    private final double pointYTranslate;
    private static final int MOVETO = 1;
    private static final int LINETO = 2;
    private static final int CLOSEPATH = 7;
    private static final byte[] EMPTY = new byte[0];

    public SimpleFeatureFactory(int z, int x, int y, int extent) {
        this.extent = extent;
        Rectangle rectangle = SphericalMercatorUtils.recToSphericalMercator(GeoTileUtils.toBoundingBox(x, y, z));
        this.pointXScale = (double)extent / (rectangle.getMaxLon() - rectangle.getMinLon());
        this.pointYScale = (double)(-extent) / (rectangle.getMaxLat() - rectangle.getMinLat());
        this.pointXTranslate = -this.pointXScale * rectangle.getMinX();
        this.pointYTranslate = -this.pointYScale * rectangle.getMinY();
    }

    public byte[] point(double lon, double lat) throws IOException {
        int posLon = this.lon(lon);
        if (posLon > this.extent || posLon < 0) {
            return EMPTY;
        }
        int posLat = this.lat(lat);
        if (posLat > this.extent || posLat < 0) {
            return EMPTY;
        }
        int[] commands = new int[]{SimpleFeatureFactory.encodeCommand(1, 1), BitUtil.zigZagEncode(posLon), BitUtil.zigZagEncode(posLat)};
        return SimpleFeatureFactory.writeCommands(commands, 1, 3);
    }

    public byte[] points(List<GeoPoint> multiPoint) {
        multiPoint.sort(Comparator.comparingDouble(GeoPoint::getLon).thenComparingDouble(GeoPoint::getLat));
        int[] commands = new int[2 * multiPoint.size() + 1];
        int pos = 1;
        int prevLon = 0;
        int prevLat = 0;
        int numPoints = 0;
        for (GeoPoint point : multiPoint) {
            int posLat;
            int posLon = this.lon(point.getLon());
            if (posLon > this.extent || posLon < 0 || (posLat = this.lat(point.getLat())) > this.extent || posLat < 0 || numPoints != 0 && posLon == prevLon && posLat == prevLat) continue;
            commands[pos++] = BitUtil.zigZagEncode(posLon - prevLon);
            commands[pos++] = BitUtil.zigZagEncode(posLat - prevLat);
            prevLon = posLon;
            prevLat = posLat;
            ++numPoints;
        }
        if (numPoints == 0) {
            return EMPTY;
        }
        commands[0] = SimpleFeatureFactory.encodeCommand(1, numPoints);
        try {
            return SimpleFeatureFactory.writeCommands(commands, 1, pos);
        }
        catch (IOException ioe) {
            throw new UncheckedIOException(ioe);
        }
    }

    public byte[] box(double minLon, double maxLon, double minLat, double maxLat) throws IOException {
        int[] commands = new int[11];
        int minX = Math.max(0, this.lon(minLon));
        if (minX > this.extent) {
            return EMPTY;
        }
        int minY = Math.min(this.extent, this.lat(minLat));
        if (minY > this.extent) {
            return EMPTY;
        }
        int maxX = Math.min(this.extent, this.lon(maxLon));
        if (maxX < 0 || minX == maxX) {
            return EMPTY;
        }
        int maxY = Math.max(0, this.lat(maxLat));
        if (maxY < 0 || minY == maxY) {
            return EMPTY;
        }
        commands[0] = SimpleFeatureFactory.encodeCommand(1, 1);
        commands[1] = BitUtil.zigZagEncode(minX);
        commands[2] = BitUtil.zigZagEncode(minY);
        commands[3] = SimpleFeatureFactory.encodeCommand(2, 3);
        commands[4] = BitUtil.zigZagEncode(maxX - minX);
        commands[5] = BitUtil.zigZagEncode(0);
        commands[6] = BitUtil.zigZagEncode(0);
        commands[7] = BitUtil.zigZagEncode(maxY - minY);
        commands[8] = BitUtil.zigZagEncode(minX - maxX);
        commands[9] = BitUtil.zigZagEncode(0);
        commands[10] = SimpleFeatureFactory.encodeCommand(7, 1);
        return SimpleFeatureFactory.writeCommands(commands, 3, 11);
    }

    private int lat(double lat) {
        return (int)Math.round(this.pointYScale * SphericalMercatorUtils.latToSphericalMercator(lat) + this.pointYTranslate) + this.extent;
    }

    private int lon(double lon) {
        return (int)Math.round(this.pointXScale * SphericalMercatorUtils.lonToSphericalMercator(lon) + this.pointXTranslate);
    }

    private static int encodeCommand(int id, int length) {
        return id & 7 | length << 3;
    }

    private static byte[] writeCommands(int[] commands, int type, int length) throws IOException {
        try (BytesStreamOutput output = new BytesStreamOutput();){
            for (int i = 0; i < length; ++i) {
                output.writeVInt(commands[i]);
            }
            int dataSize = output.size();
            output.reset();
            output.writeVInt(24);
            output.writeVInt(type);
            output.writeVInt(34);
            output.writeVInt(dataSize);
            for (int i = 0; i < length; ++i) {
                output.writeVInt(commands[i]);
            }
            byte[] byArray = output.copyBytes().array();
            return byArray;
        }
    }
}

