/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client.transform;

import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.elasticsearch.action.admin.indices.alias.Alias;
import org.elasticsearch.client.indices.CreateIndexRequest;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.XContentParser;

public class PreviewTransformResponse {
    public static final ParseField PREVIEW = new ParseField("preview", new String[0]);
    public static final ParseField GENERATED_DEST_INDEX_SETTINGS = new ParseField("generated_dest_index", new String[0]);
    private final List<Map<String, Object>> docs;
    private final GeneratedDestIndexSettings generatedDestIndexSettings;
    private static final ConstructingObjectParser<PreviewTransformResponse, Void> PARSER = new ConstructingObjectParser("data_frame_transform_preview", true, args -> {
        List docs = (List)args[0];
        GeneratedDestIndexSettings generatedDestIndex = (GeneratedDestIndexSettings)args[1];
        if (generatedDestIndex == null) {
            Map mappings = (Map)args[2];
            generatedDestIndex = new GeneratedDestIndexSettings(mappings, null, null);
        }
        return new PreviewTransformResponse(docs, generatedDestIndex);
    });

    public PreviewTransformResponse(List<Map<String, Object>> docs, GeneratedDestIndexSettings generatedDestIndexSettings) {
        this.docs = docs;
        this.generatedDestIndexSettings = generatedDestIndexSettings;
    }

    public List<Map<String, Object>> getDocs() {
        return this.docs;
    }

    public GeneratedDestIndexSettings getGeneratedDestIndexSettings() {
        return this.generatedDestIndexSettings;
    }

    public Map<String, Object> getMappings() {
        return this.generatedDestIndexSettings.getMappings();
    }

    public Settings getSettings() {
        return this.generatedDestIndexSettings.getSettings();
    }

    public Set<Alias> getAliases() {
        return this.generatedDestIndexSettings.getAliases();
    }

    public CreateIndexRequest getCreateIndexRequest(String index) {
        CreateIndexRequest createIndexRequest = new CreateIndexRequest(index);
        createIndexRequest.aliases(this.generatedDestIndexSettings.getAliases());
        createIndexRequest.settings(this.generatedDestIndexSettings.getSettings());
        createIndexRequest.mapping(this.generatedDestIndexSettings.getMappings());
        return createIndexRequest;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        PreviewTransformResponse other = (PreviewTransformResponse)obj;
        return Objects.equals(other.docs, this.docs) && Objects.equals(other.generatedDestIndexSettings, this.generatedDestIndexSettings);
    }

    public int hashCode() {
        return Objects.hash(this.docs, this.generatedDestIndexSettings);
    }

    public static PreviewTransformResponse fromXContent(XContentParser parser) throws IOException {
        return PARSER.parse(parser, null);
    }

    static {
        PARSER.declareObjectArray(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> p.mapOrdered(), PREVIEW);
        PARSER.declareObject(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> GeneratedDestIndexSettings.fromXContent(p), GENERATED_DEST_INDEX_SETTINGS);
        PARSER.declareObject(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> p.mapOrdered(), GeneratedDestIndexSettings.MAPPINGS);
    }

    public static class GeneratedDestIndexSettings {
        static final ParseField MAPPINGS = new ParseField("mappings", new String[0]);
        private static final ParseField SETTINGS = new ParseField("settings", new String[0]);
        private static final ParseField ALIASES = new ParseField("aliases", new String[0]);
        private final Map<String, Object> mappings;
        private final Settings settings;
        private final Set<Alias> aliases;
        private static final ConstructingObjectParser<GeneratedDestIndexSettings, Void> PARSER = new ConstructingObjectParser("transform_preview_generated_dest_index", true, args -> {
            Map mappings = (Map)args[0];
            Settings settings = (Settings)args[1];
            Set aliases = (Set)args[2];
            return new GeneratedDestIndexSettings(mappings, settings, aliases);
        });

        public GeneratedDestIndexSettings(Map<String, Object> mappings, Settings settings, Set<Alias> aliases) {
            this.mappings = mappings == null ? Collections.emptyMap() : Collections.unmodifiableMap(mappings);
            this.settings = settings == null ? Settings.EMPTY : settings;
            this.aliases = aliases == null ? Collections.emptySet() : Collections.unmodifiableSet(aliases);
        }

        public Map<String, Object> getMappings() {
            return this.mappings;
        }

        public Settings getSettings() {
            return this.settings;
        }

        public Set<Alias> getAliases() {
            return this.aliases;
        }

        public static GeneratedDestIndexSettings fromXContent(XContentParser parser) {
            return PARSER.apply(parser, null);
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || obj.getClass() != this.getClass()) {
                return false;
            }
            GeneratedDestIndexSettings other = (GeneratedDestIndexSettings)obj;
            return Objects.equals(other.mappings, this.mappings) && Objects.equals(other.settings, this.settings) && Objects.equals(other.aliases, this.aliases);
        }

        public int hashCode() {
            return Objects.hash(this.mappings, this.settings, this.aliases);
        }

        static {
            PARSER.declareObject(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> p.mapOrdered(), MAPPINGS);
            PARSER.declareObject(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> Settings.fromXContent(p), SETTINGS);
            PARSER.declareObject(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> {
                HashSet<Alias> aliases = new HashSet<Alias>();
                while (p.nextToken() != XContentParser.Token.END_OBJECT) {
                    aliases.add(Alias.fromXContent(p));
                }
                return aliases;
            }, ALIASES);
        }
    }
}

