/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client.security;

import java.io.IOException;
import java.util.Arrays;
import java.util.stream.IntStream;
import org.elasticsearch.client.Validatable;
import org.elasticsearch.common.Strings;
import org.elasticsearch.core.List;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;

public final class InvalidateApiKeyRequest
implements Validatable,
ToXContentObject {
    private final String realmName;
    private final String userName;
    private final java.util.List<String> ids;
    private final String name;
    private final boolean ownedByAuthenticatedUser;

    @Deprecated
    InvalidateApiKeyRequest(@Nullable String realmName, @Nullable String userName, @Nullable String apiKeyId, @Nullable String apiKeyName, boolean ownedByAuthenticatedUser) {
        this(realmName, userName, apiKeyName, ownedByAuthenticatedUser, InvalidateApiKeyRequest.apiKeyIdToIds(apiKeyId));
    }

    InvalidateApiKeyRequest(@Nullable String realmName, @Nullable String userName, @Nullable String apiKeyName, boolean ownedByAuthenticatedUser, @Nullable java.util.List<String> apiKeyIds) {
        this.validateApiKeyIds(apiKeyIds);
        if (!(Strings.hasText(realmName) || Strings.hasText(userName) || apiKeyIds != null || Strings.hasText(apiKeyName) || ownedByAuthenticatedUser)) {
            this.throwValidationError("One of [api key id(s), api key name, username, realm name] must be specified if [owner] flag is false");
        }
        if ((apiKeyIds != null || Strings.hasText(apiKeyName)) && (Strings.hasText(realmName) || Strings.hasText(userName))) {
            this.throwValidationError("username or realm name must not be specified when the api key id(s) or api key name is specified");
        }
        if (ownedByAuthenticatedUser && (Strings.hasText(realmName) || Strings.hasText(userName))) {
            this.throwValidationError("neither username nor realm-name may be specified when invalidating owned API keys");
        }
        if (apiKeyIds != null && Strings.hasText(apiKeyName)) {
            this.throwValidationError("only one of [api key id(s), api key name] can be specified");
        }
        this.realmName = realmName;
        this.userName = userName;
        this.ids = apiKeyIds == null ? null : List.copyOf(apiKeyIds);
        this.name = apiKeyName;
        this.ownedByAuthenticatedUser = ownedByAuthenticatedUser;
    }

    private void validateApiKeyIds(@Nullable java.util.List<String> apiKeyIds) {
        if (apiKeyIds != null) {
            if (apiKeyIds.size() == 0) {
                this.throwValidationError("Argument [apiKeyIds] cannot be an empty array");
            } else {
                int[] idxOfBlankIds = IntStream.range(0, apiKeyIds.size()).filter(i -> !Strings.hasText((String)apiKeyIds.get(i))).toArray();
                if (idxOfBlankIds.length > 0) {
                    this.throwValidationError("Argument [apiKeyIds] must not contain blank id, but got blank " + (idxOfBlankIds.length == 1 ? "id" : "ids") + " at index " + (idxOfBlankIds.length == 1 ? "position" : "positions") + ": " + Arrays.toString(idxOfBlankIds));
                }
            }
        }
    }

    private void throwValidationError(String message) {
        throw new IllegalArgumentException(message);
    }

    public String getRealmName() {
        return this.realmName;
    }

    public String getUserName() {
        return this.userName;
    }

    @Deprecated
    public String getId() {
        if (this.ids == null) {
            return null;
        }
        if (this.ids.size() == 1) {
            return this.ids.get(0);
        }
        throw new IllegalArgumentException("Cannot get a single api key id when multiple ids have been set [" + Strings.collectionToCommaDelimitedString(this.ids) + "]");
    }

    public java.util.List<String> getIds() {
        return this.ids;
    }

    public String getName() {
        return this.name;
    }

    public boolean ownedByAuthenticatedUser() {
        return this.ownedByAuthenticatedUser;
    }

    public static InvalidateApiKeyRequest usingRealmName(String realmName) {
        return new InvalidateApiKeyRequest(realmName, null, null, false, null);
    }

    public static InvalidateApiKeyRequest usingUserName(String userName) {
        return new InvalidateApiKeyRequest(null, userName, null, false, null);
    }

    public static InvalidateApiKeyRequest usingRealmAndUserName(String realmName, String userName) {
        return new InvalidateApiKeyRequest(realmName, userName, null, false, null);
    }

    public static InvalidateApiKeyRequest usingApiKeyId(String apiKeyId, boolean ownedByAuthenticatedUser) {
        return new InvalidateApiKeyRequest(null, null, null, ownedByAuthenticatedUser, InvalidateApiKeyRequest.apiKeyIdToIds(apiKeyId));
    }

    public static InvalidateApiKeyRequest usingApiKeyIds(java.util.List<String> apiKeyIds, boolean ownedByAuthenticatedUser) {
        return new InvalidateApiKeyRequest(null, null, null, ownedByAuthenticatedUser, apiKeyIds);
    }

    public static InvalidateApiKeyRequest usingApiKeyName(String apiKeyName, boolean ownedByAuthenticatedUser) {
        return new InvalidateApiKeyRequest(null, null, apiKeyName, ownedByAuthenticatedUser, null);
    }

    public static InvalidateApiKeyRequest forOwnedApiKeys() {
        return new InvalidateApiKeyRequest(null, null, null, true, null);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (this.realmName != null) {
            builder.field("realm_name", this.realmName);
        }
        if (this.userName != null) {
            builder.field("username", this.userName);
        }
        if (this.ids != null) {
            builder.field("ids", this.ids);
        }
        if (this.name != null) {
            builder.field("name", this.name);
        }
        builder.field("owner", this.ownedByAuthenticatedUser);
        return builder.endObject();
    }

    static java.util.List<String> apiKeyIdToIds(@Nullable String apiKeyId) {
        return Strings.hasText(apiKeyId) ? List.of(apiKeyId) : null;
    }
}

