/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client.ml.job.config;

import java.io.IOException;
import java.util.Locale;
import java.util.Objects;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.tasks.TaskId;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;

public class Blocked
implements ToXContentObject {
    public static final ParseField REASON = new ParseField("reason", new String[0]);
    public static final ParseField TASK_ID = new ParseField("task_id", new String[0]);
    public static final ConstructingObjectParser<Blocked, Void> PARSER = new ConstructingObjectParser("blocked", true, a -> new Blocked((Reason)((Object)((Object)a[0])), (TaskId)a[1]));
    private final Reason reason;
    @Nullable
    private final TaskId taskId;

    public Blocked(Reason reason, @Nullable TaskId taskId) {
        this.reason = Objects.requireNonNull(reason);
        this.taskId = taskId;
    }

    public Reason getReason() {
        return this.reason;
    }

    @Nullable
    public TaskId getTaskId() {
        return this.taskId;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(REASON.getPreferredName(), this.reason);
        if (this.taskId != null) {
            builder.field(TASK_ID.getPreferredName(), this.taskId.toString());
        }
        builder.endObject();
        return builder;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.reason, this.taskId});
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Blocked that = (Blocked)o;
        return Objects.equals((Object)this.reason, (Object)that.reason) && Objects.equals(this.taskId, that.taskId);
    }

    static {
        PARSER.declareString(ConstructingObjectParser.constructorArg(), Reason::fromString, REASON);
        PARSER.declareString(ConstructingObjectParser.optionalConstructorArg(), TaskId::new, TASK_ID);
    }

    public static enum Reason {
        NONE,
        DELETE,
        RESET,
        REVERT;


        public static Reason fromString(String value) {
            return Reason.valueOf(value.toUpperCase(Locale.ROOT));
        }

        public String toString() {
            return this.name().toLowerCase(Locale.ROOT);
        }
    }
}

