/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client.ccr;

import java.util.AbstractMap;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.common.util.Maps;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ParseField;

public final class IndicesFollowStats {
    static final ParseField INDICES_FIELD = new ParseField("indices", new String[0]);
    static final ParseField INDEX_FIELD = new ParseField("index", new String[0]);
    static final ParseField SHARDS_FIELD = new ParseField("shards", new String[0]);
    private static final ConstructingObjectParser<Tuple<String, List<ShardFollowStats>>, Void> ENTRY_PARSER = new ConstructingObjectParser("entry", true, args -> {
        String index = (String)args[0];
        List shardFollowStats = (List)args[1];
        return new Tuple<String, List>(index, shardFollowStats);
    });
    static final ConstructingObjectParser<IndicesFollowStats, Void> PARSER;
    private final NavigableMap<String, List<ShardFollowStats>> shardFollowStats;

    IndicesFollowStats(NavigableMap<String, List<ShardFollowStats>> shardFollowStats) {
        this.shardFollowStats = Collections.unmodifiableNavigableMap(shardFollowStats);
    }

    public List<ShardFollowStats> getShardFollowStats(String index) {
        return (List)this.shardFollowStats.get(index);
    }

    public Map<String, List<ShardFollowStats>> getShardFollowStats() {
        return this.shardFollowStats;
    }

    static {
        ENTRY_PARSER.declareString(ConstructingObjectParser.constructorArg(), INDEX_FIELD);
        ENTRY_PARSER.declareObjectArray(ConstructingObjectParser.constructorArg(), ShardFollowStats.PARSER, SHARDS_FIELD);
        PARSER = new ConstructingObjectParser("indices", true, args -> {
            List entries = (List)args[0];
            Map<String, List> shardFollowStats = entries.stream().collect(Collectors.toMap(Tuple::v1, Tuple::v2));
            return new IndicesFollowStats(new TreeMap<String, List<ShardFollowStats>>(shardFollowStats));
        });
        PARSER.declareObjectArray(ConstructingObjectParser.constructorArg(), ENTRY_PARSER, INDICES_FIELD);
    }

    public static final class ShardFollowStats {
        static final ParseField LEADER_CLUSTER = new ParseField("remote_cluster", new String[0]);
        static final ParseField LEADER_INDEX = new ParseField("leader_index", new String[0]);
        static final ParseField FOLLOWER_INDEX = new ParseField("follower_index", new String[0]);
        static final ParseField SHARD_ID = new ParseField("shard_id", new String[0]);
        static final ParseField LEADER_GLOBAL_CHECKPOINT_FIELD = new ParseField("leader_global_checkpoint", new String[0]);
        static final ParseField LEADER_MAX_SEQ_NO_FIELD = new ParseField("leader_max_seq_no", new String[0]);
        static final ParseField FOLLOWER_GLOBAL_CHECKPOINT_FIELD = new ParseField("follower_global_checkpoint", new String[0]);
        static final ParseField FOLLOWER_MAX_SEQ_NO_FIELD = new ParseField("follower_max_seq_no", new String[0]);
        static final ParseField LAST_REQUESTED_SEQ_NO_FIELD = new ParseField("last_requested_seq_no", new String[0]);
        static final ParseField OUTSTANDING_READ_REQUESTS = new ParseField("outstanding_read_requests", new String[0]);
        static final ParseField OUTSTANDING_WRITE_REQUESTS = new ParseField("outstanding_write_requests", new String[0]);
        static final ParseField WRITE_BUFFER_OPERATION_COUNT_FIELD = new ParseField("write_buffer_operation_count", new String[0]);
        static final ParseField WRITE_BUFFER_SIZE_IN_BYTES_FIELD = new ParseField("write_buffer_size_in_bytes", new String[0]);
        static final ParseField FOLLOWER_MAPPING_VERSION_FIELD = new ParseField("follower_mapping_version", new String[0]);
        static final ParseField FOLLOWER_SETTINGS_VERSION_FIELD = new ParseField("follower_settings_version", new String[0]);
        static final ParseField FOLLOWER_ALIASES_VERSION_FIELD = new ParseField("follower_aliases_version", new String[0]);
        static final ParseField TOTAL_READ_TIME_MILLIS_FIELD = new ParseField("total_read_time_millis", new String[0]);
        static final ParseField TOTAL_READ_REMOTE_EXEC_TIME_MILLIS_FIELD = new ParseField("total_read_remote_exec_time_millis", new String[0]);
        static final ParseField SUCCESSFUL_READ_REQUESTS_FIELD = new ParseField("successful_read_requests", new String[0]);
        static final ParseField FAILED_READ_REQUESTS_FIELD = new ParseField("failed_read_requests", new String[0]);
        static final ParseField OPERATIONS_READ_FIELD = new ParseField("operations_read", new String[0]);
        static final ParseField BYTES_READ = new ParseField("bytes_read", new String[0]);
        static final ParseField TOTAL_WRITE_TIME_MILLIS_FIELD = new ParseField("total_write_time_millis", new String[0]);
        static final ParseField SUCCESSFUL_WRITE_REQUESTS_FIELD = new ParseField("successful_write_requests", new String[0]);
        static final ParseField FAILED_WRITE_REQUEST_FIELD = new ParseField("failed_write_requests", new String[0]);
        static final ParseField OPERATIONS_WRITTEN = new ParseField("operations_written", new String[0]);
        static final ParseField READ_EXCEPTIONS = new ParseField("read_exceptions", new String[0]);
        static final ParseField TIME_SINCE_LAST_READ_MILLIS_FIELD = new ParseField("time_since_last_read_millis", new String[0]);
        static final ParseField FATAL_EXCEPTION = new ParseField("fatal_exception", new String[0]);
        static final ConstructingObjectParser<ShardFollowStats, Void> PARSER = new ConstructingObjectParser("shard-follow-stats", true, args -> new ShardFollowStats((String)args[0], (String)args[1], (String)args[2], (Integer)args[3], (Long)args[4], (Long)args[5], (Long)args[6], (Long)args[7], (Long)args[8], (Integer)args[9], (Integer)args[10], (Integer)args[11], (Long)args[12], (Long)args[13], (Long)args[14], (Long)args[15], (Long)args[16], (Long)args[17], (Long)args[18], (Long)args[19], (Long)args[20], (Long)args[21], (Long)args[22], (Long)args[23], (Long)args[24], (Long)args[25], (Long)args[26], ((List)args[27]).stream().collect(Maps.toUnmodifiableSortedMap(Map.Entry::getKey, Map.Entry::getValue)), (ElasticsearchException)args[28]));
        static final ConstructingObjectParser<Map.Entry<Long, Tuple<Integer, ElasticsearchException>>, Void> READ_EXCEPTIONS_ENTRY_PARSER = new ConstructingObjectParser("shard-follow-stats-read-exceptions-entry", true, args -> new AbstractMap.SimpleEntry<Long, Tuple<Integer, ElasticsearchException>>((Long)args[0], Tuple.tuple((Integer)args[1], (ElasticsearchException)args[2])));
        static final ParseField READ_EXCEPTIONS_ENTRY_FROM_SEQ_NO;
        static final ParseField READ_EXCEPTIONS_RETRIES;
        static final ParseField READ_EXCEPTIONS_ENTRY_EXCEPTION;
        private final String remoteCluster;
        private final String leaderIndex;
        private final String followerIndex;
        private final int shardId;
        private final long leaderGlobalCheckpoint;
        private final long leaderMaxSeqNo;
        private final long followerGlobalCheckpoint;
        private final long followerMaxSeqNo;
        private final long lastRequestedSeqNo;
        private final int outstandingReadRequests;
        private final int outstandingWriteRequests;
        private final int writeBufferOperationCount;
        private final long writeBufferSizeInBytes;
        private final long followerMappingVersion;
        private final long followerSettingsVersion;
        private final long followerAliasesVersion;
        private final long totalReadTimeMillis;
        private final long totalReadRemoteExecTimeMillis;
        private final long successfulReadRequests;
        private final long failedReadRequests;
        private final long operationsReads;
        private final long bytesRead;
        private final long totalWriteTimeMillis;
        private final long successfulWriteRequests;
        private final long failedWriteRequests;
        private final long operationWritten;
        private final long timeSinceLastReadMillis;
        private final NavigableMap<Long, Tuple<Integer, ElasticsearchException>> readExceptions;
        private final ElasticsearchException fatalException;

        ShardFollowStats(String remoteCluster, String leaderIndex, String followerIndex, int shardId, long leaderGlobalCheckpoint, long leaderMaxSeqNo, long followerGlobalCheckpoint, long followerMaxSeqNo, long lastRequestedSeqNo, int outstandingReadRequests, int outstandingWriteRequests, int writeBufferOperationCount, long writeBufferSizeInBytes, long followerMappingVersion, long followerSettingsVersion, long followerAliasesVersion, long totalReadTimeMillis, long totalReadRemoteExecTimeMillis, long successfulReadRequests, long failedReadRequests, long operationsReads, long bytesRead, long totalWriteTimeMillis, long successfulWriteRequests, long failedWriteRequests, long operationWritten, long timeSinceLastReadMillis, NavigableMap<Long, Tuple<Integer, ElasticsearchException>> readExceptions, ElasticsearchException fatalException) {
            this.remoteCluster = remoteCluster;
            this.leaderIndex = leaderIndex;
            this.followerIndex = followerIndex;
            this.shardId = shardId;
            this.leaderGlobalCheckpoint = leaderGlobalCheckpoint;
            this.leaderMaxSeqNo = leaderMaxSeqNo;
            this.followerGlobalCheckpoint = followerGlobalCheckpoint;
            this.followerMaxSeqNo = followerMaxSeqNo;
            this.lastRequestedSeqNo = lastRequestedSeqNo;
            this.outstandingReadRequests = outstandingReadRequests;
            this.outstandingWriteRequests = outstandingWriteRequests;
            this.writeBufferOperationCount = writeBufferOperationCount;
            this.writeBufferSizeInBytes = writeBufferSizeInBytes;
            this.followerMappingVersion = followerMappingVersion;
            this.followerSettingsVersion = followerSettingsVersion;
            this.followerAliasesVersion = followerAliasesVersion;
            this.totalReadTimeMillis = totalReadTimeMillis;
            this.totalReadRemoteExecTimeMillis = totalReadRemoteExecTimeMillis;
            this.successfulReadRequests = successfulReadRequests;
            this.failedReadRequests = failedReadRequests;
            this.operationsReads = operationsReads;
            this.bytesRead = bytesRead;
            this.totalWriteTimeMillis = totalWriteTimeMillis;
            this.successfulWriteRequests = successfulWriteRequests;
            this.failedWriteRequests = failedWriteRequests;
            this.operationWritten = operationWritten;
            this.timeSinceLastReadMillis = timeSinceLastReadMillis;
            this.readExceptions = readExceptions;
            this.fatalException = fatalException;
        }

        public String getRemoteCluster() {
            return this.remoteCluster;
        }

        public String getLeaderIndex() {
            return this.leaderIndex;
        }

        public String getFollowerIndex() {
            return this.followerIndex;
        }

        public int getShardId() {
            return this.shardId;
        }

        public long getLeaderGlobalCheckpoint() {
            return this.leaderGlobalCheckpoint;
        }

        public long getLeaderMaxSeqNo() {
            return this.leaderMaxSeqNo;
        }

        public long getFollowerGlobalCheckpoint() {
            return this.followerGlobalCheckpoint;
        }

        public long getFollowerMaxSeqNo() {
            return this.followerMaxSeqNo;
        }

        public long getLastRequestedSeqNo() {
            return this.lastRequestedSeqNo;
        }

        public int getOutstandingReadRequests() {
            return this.outstandingReadRequests;
        }

        public int getOutstandingWriteRequests() {
            return this.outstandingWriteRequests;
        }

        public int getWriteBufferOperationCount() {
            return this.writeBufferOperationCount;
        }

        public long getWriteBufferSizeInBytes() {
            return this.writeBufferSizeInBytes;
        }

        public long getFollowerMappingVersion() {
            return this.followerMappingVersion;
        }

        public long getFollowerSettingsVersion() {
            return this.followerSettingsVersion;
        }

        public long getFollowerAliasesVersion() {
            return this.followerAliasesVersion;
        }

        public long getTotalReadTimeMillis() {
            return this.totalReadTimeMillis;
        }

        public long getTotalReadRemoteExecTimeMillis() {
            return this.totalReadRemoteExecTimeMillis;
        }

        public long getSuccessfulReadRequests() {
            return this.successfulReadRequests;
        }

        public long getFailedReadRequests() {
            return this.failedReadRequests;
        }

        public long getOperationsReads() {
            return this.operationsReads;
        }

        public long getBytesRead() {
            return this.bytesRead;
        }

        public long getTotalWriteTimeMillis() {
            return this.totalWriteTimeMillis;
        }

        public long getSuccessfulWriteRequests() {
            return this.successfulWriteRequests;
        }

        public long getFailedWriteRequests() {
            return this.failedWriteRequests;
        }

        public long getOperationWritten() {
            return this.operationWritten;
        }

        public long getTimeSinceLastReadMillis() {
            return this.timeSinceLastReadMillis;
        }

        public NavigableMap<Long, Tuple<Integer, ElasticsearchException>> getReadExceptions() {
            return this.readExceptions;
        }

        public ElasticsearchException getFatalException() {
            return this.fatalException;
        }

        static {
            PARSER.declareString(ConstructingObjectParser.constructorArg(), LEADER_CLUSTER);
            PARSER.declareString(ConstructingObjectParser.constructorArg(), LEADER_INDEX);
            PARSER.declareString(ConstructingObjectParser.constructorArg(), FOLLOWER_INDEX);
            PARSER.declareInt(ConstructingObjectParser.constructorArg(), SHARD_ID);
            PARSER.declareLong(ConstructingObjectParser.constructorArg(), LEADER_GLOBAL_CHECKPOINT_FIELD);
            PARSER.declareLong(ConstructingObjectParser.constructorArg(), LEADER_MAX_SEQ_NO_FIELD);
            PARSER.declareLong(ConstructingObjectParser.constructorArg(), FOLLOWER_GLOBAL_CHECKPOINT_FIELD);
            PARSER.declareLong(ConstructingObjectParser.constructorArg(), FOLLOWER_MAX_SEQ_NO_FIELD);
            PARSER.declareLong(ConstructingObjectParser.constructorArg(), LAST_REQUESTED_SEQ_NO_FIELD);
            PARSER.declareInt(ConstructingObjectParser.constructorArg(), OUTSTANDING_READ_REQUESTS);
            PARSER.declareInt(ConstructingObjectParser.constructorArg(), OUTSTANDING_WRITE_REQUESTS);
            PARSER.declareInt(ConstructingObjectParser.constructorArg(), WRITE_BUFFER_OPERATION_COUNT_FIELD);
            PARSER.declareLong(ConstructingObjectParser.constructorArg(), WRITE_BUFFER_SIZE_IN_BYTES_FIELD);
            PARSER.declareLong(ConstructingObjectParser.constructorArg(), FOLLOWER_MAPPING_VERSION_FIELD);
            PARSER.declareLong(ConstructingObjectParser.constructorArg(), FOLLOWER_SETTINGS_VERSION_FIELD);
            PARSER.declareLong(ConstructingObjectParser.constructorArg(), FOLLOWER_ALIASES_VERSION_FIELD);
            PARSER.declareLong(ConstructingObjectParser.constructorArg(), TOTAL_READ_TIME_MILLIS_FIELD);
            PARSER.declareLong(ConstructingObjectParser.constructorArg(), TOTAL_READ_REMOTE_EXEC_TIME_MILLIS_FIELD);
            PARSER.declareLong(ConstructingObjectParser.constructorArg(), SUCCESSFUL_READ_REQUESTS_FIELD);
            PARSER.declareLong(ConstructingObjectParser.constructorArg(), FAILED_READ_REQUESTS_FIELD);
            PARSER.declareLong(ConstructingObjectParser.constructorArg(), OPERATIONS_READ_FIELD);
            PARSER.declareLong(ConstructingObjectParser.constructorArg(), BYTES_READ);
            PARSER.declareLong(ConstructingObjectParser.constructorArg(), TOTAL_WRITE_TIME_MILLIS_FIELD);
            PARSER.declareLong(ConstructingObjectParser.constructorArg(), SUCCESSFUL_WRITE_REQUESTS_FIELD);
            PARSER.declareLong(ConstructingObjectParser.constructorArg(), FAILED_WRITE_REQUEST_FIELD);
            PARSER.declareLong(ConstructingObjectParser.constructorArg(), OPERATIONS_WRITTEN);
            PARSER.declareLong(ConstructingObjectParser.constructorArg(), TIME_SINCE_LAST_READ_MILLIS_FIELD);
            PARSER.declareObjectArray(ConstructingObjectParser.constructorArg(), READ_EXCEPTIONS_ENTRY_PARSER, READ_EXCEPTIONS);
            PARSER.declareObject(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> ElasticsearchException.fromXContent(p), FATAL_EXCEPTION);
            READ_EXCEPTIONS_ENTRY_FROM_SEQ_NO = new ParseField("from_seq_no", new String[0]);
            READ_EXCEPTIONS_RETRIES = new ParseField("retries", new String[0]);
            READ_EXCEPTIONS_ENTRY_EXCEPTION = new ParseField("exception", new String[0]);
            READ_EXCEPTIONS_ENTRY_PARSER.declareLong(ConstructingObjectParser.constructorArg(), READ_EXCEPTIONS_ENTRY_FROM_SEQ_NO);
            READ_EXCEPTIONS_ENTRY_PARSER.declareInt(ConstructingObjectParser.constructorArg(), READ_EXCEPTIONS_RETRIES);
            READ_EXCEPTIONS_ENTRY_PARSER.declareObject(ConstructingObjectParser.constructorArg(), (p, c) -> ElasticsearchException.fromXContent(p), READ_EXCEPTIONS_ENTRY_EXCEPTION);
        }
    }
}

