/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.elastic.impl;

import com.hazelcast.cluster.Address;
import com.hazelcast.cluster.Member;
import com.hazelcast.jet.JetException;
import com.hazelcast.jet.core.ProcessorMetaSupplier;
import com.hazelcast.jet.core.ProcessorSupplier;
import com.hazelcast.jet.core.processor.Processors;
import com.hazelcast.jet.elastic.impl.ElasticCatClient;
import com.hazelcast.jet.elastic.impl.ElasticSourceConfiguration;
import com.hazelcast.jet.elastic.impl.ElasticSourcePSupplier;
import com.hazelcast.jet.elastic.impl.Shard;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.client.RestHighLevelClient;

public class ElasticSourcePMetaSupplier<T>
implements ProcessorMetaSupplier {
    private static final long serialVersionUID = 1L;
    private static final int DEFAULT_LOCAL_PARALLELISM = 2;
    @Nonnull
    private final ElasticSourceConfiguration<T> configuration;
    private transient Map<Address, List<Shard>> assignedShards;
    private transient Address ownerAddress;

    public ElasticSourcePMetaSupplier(@Nonnull ElasticSourceConfiguration<T> configuration) {
        this.configuration = configuration;
    }

    public int preferredLocalParallelism() {
        if (this.configuration.isCoLocatedReadingEnabled() || this.configuration.isSlicingEnabled()) {
            return 2;
        }
        return 1;
    }

    public void init(@Nonnull ProcessorMetaSupplier.Context context) throws Exception {
        try (ElasticCatClient catClient = new ElasticCatClient(((RestHighLevelClient)this.configuration.clientFn().get()).getLowLevelClient(), this.configuration.retries());){
            List<Shard> shards = catClient.shards(((SearchRequest)this.configuration.searchRequestFn().get()).indices());
            if (this.configuration.isCoLocatedReadingEnabled()) {
                Set<Address> addresses = context.hazelcastInstance().getCluster().getMembers().stream().map(Member::getAddress).collect(Collectors.toSet());
                this.assignedShards = ElasticSourcePMetaSupplier.assignShards(shards, addresses);
            } else {
                this.ownerAddress = context.hazelcastInstance().getPartitionService().getPartition((Object)context.jobId()).getOwner().getAddress();
                this.assignedShards = Collections.emptyMap();
            }
        }
    }

    static Map<Address, List<Shard>> assignShards(Collection<Shard> shards, Collection<Address> addresses) {
        Map<String, List<Shard>> nodeCandidates = shards.stream().collect(Collectors.groupingBy(Shard::getIp));
        HashMap<Address, List<Shard>> nodeAssigned = new HashMap<Address, List<Shard>>();
        if (!addresses.stream().map(Address::getHost).collect(Collectors.toSet()).containsAll(nodeCandidates.keySet())) {
            throw new JetException("Shard locations are not equal to Hazelcast members locations, shards=" + nodeCandidates.keySet() + ", Hazelcast members=" + addresses);
        }
        int uniqueShards = (int)shards.stream().map(Shard::indexShard).distinct().count();
        HashSet<String> assignedShards = new HashSet<String>();
        int candidatesSize = nodeCandidates.size();
        int iterations = (uniqueShards + candidatesSize - 1) / candidatesSize;
        for (int i = 0; i < iterations; ++i) {
            for (Address address : addresses) {
                String host = address.getHost();
                List thisNodeCandidates = nodeCandidates.getOrDefault(host, Collections.emptyList());
                if (thisNodeCandidates.isEmpty()) continue;
                Shard shard = (Shard)thisNodeCandidates.remove(0);
                List nodeShards = nodeAssigned.computeIfAbsent(address, key -> new ArrayList());
                nodeShards.add(shard);
                nodeCandidates.values().forEach(candidates -> candidates.removeIf(next -> next.indexShard().equals(shard.indexShard())));
                assignedShards.add(shard.indexShard());
            }
        }
        if (assignedShards.size() != uniqueShards) {
            throw new JetException("Not all shards have been assigned");
        }
        return nodeAssigned;
    }

    @Nonnull
    public Function<? super Address, ? extends ProcessorSupplier> get(@Nonnull List<Address> addresses) {
        if (this.configuration.isSlicingEnabled() || this.configuration.isCoLocatedReadingEnabled()) {
            return address -> {
                List<Shard> shards = this.assignedShards.getOrDefault(address, Collections.emptyList());
                return new ElasticSourcePSupplier<T>(this.configuration, shards);
            };
        }
        return address -> address.equals((Object)this.ownerAddress) ? new ElasticSourcePSupplier<T>(this.configuration, Collections.emptyList()) : count -> Collections.nCopies(count, Processors.noopP().get());
    }

    public boolean closeIsCooperative() {
        return true;
    }
}

