/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.mapstore;

import com.hazelcast.config.MapConfig;
import com.hazelcast.core.HazelcastException;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.datastore.ExternalDataStoreFactory;
import com.hazelcast.datastore.JdbcDataStoreFactory;
import com.hazelcast.instance.impl.HazelcastInstanceImpl;
import com.hazelcast.internal.util.UuidUtil;
import com.hazelcast.internal.util.executor.ManagedExecutorService;
import com.hazelcast.jet.impl.util.Util;
import com.hazelcast.logging.ILogger;
import com.hazelcast.map.MapLoaderLifecycleSupport;
import com.hazelcast.map.MapStore;
import com.hazelcast.mapstore.MappingClosingIterator;
import com.hazelcast.mapstore.Queries;
import com.hazelcast.nio.serialization.genericrecord.GenericRecord;
import com.hazelcast.nio.serialization.genericrecord.GenericRecordBuilder;
import com.hazelcast.spi.impl.NodeEngineImpl;
import com.hazelcast.spi.properties.HazelcastProperties;
import com.hazelcast.spi.properties.HazelcastProperty;
import com.hazelcast.sql.SqlColumnMetadata;
import com.hazelcast.sql.SqlResult;
import com.hazelcast.sql.SqlRow;
import com.hazelcast.sql.SqlRowMetadata;
import com.hazelcast.sql.SqlService;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;

public class GenericMapStore<K>
implements MapStore<K, GenericRecord>,
MapLoaderLifecycleSupport {
    public static final HazelcastProperty MAPSTORE_INIT_TIMEOUT = new HazelcastProperty("hazelcast.mapstore.init.timeout", Integer.valueOf(30), TimeUnit.SECONDS);
    static final String MAPPING_PREFIX = "__map-store.";
    static final String EXTERNAL_REF_ID_PROPERTY = "external-data-store-ref";
    static final String TABLE_NAME_PROPERTY = "table-name";
    static final String MAPPING_TYPE_PROPERTY = "mapping-type";
    static final String ID_COLUMN_PROPERTY = "id-column";
    static final String ID_COLUMN_DEFAULT = "id";
    static final String COLUMNS_PROPERTY = "columns";
    static final String TYPE_NAME_PROPERTY = "type-name";
    static final String MAPPING_NAME_COLUMN = "name";
    static final String H2_PK_VIOLATION = "Unique index or primary key violation";
    static final String PG_PK_VIOLATION = "ERROR: duplicate key value violates unique constraint";
    static final String MYSQL_PK_VIOLATION = "Duplicate entry";
    private ILogger logger;
    private HazelcastInstanceImpl instance;
    private SqlService sql;
    private GenericMapStoreProperties properties;
    private String mapName;
    private String mapping;
    private Queries queries;
    private long initTimeoutMillis;
    private Exception initFailure;
    private List<SqlColumnMetadata> columnMetadataList;
    private final CountDownLatch initFinished = new CountDownLatch(1);

    public void init(HazelcastInstance instance, Properties properties, String mapName) {
        this.verifyMapStoreOffload(instance, mapName);
        this.logger = instance.getLoggingService().getLogger(GenericMapStore.class);
        this.instance = Util.getHazelcastInstanceImpl((HazelcastInstance)instance);
        this.properties = new GenericMapStoreProperties(properties, mapName);
        this.sql = instance.getSql();
        this.mapName = mapName;
        this.mapping = MAPPING_PREFIX + mapName;
        HazelcastProperties hzProperties = this.nodeEngine().getProperties();
        this.initTimeoutMillis = hzProperties.getMillis(MAPSTORE_INIT_TIMEOUT);
        ManagedExecutorService asyncExecutor = this.nodeEngine().getExecutionService().getExecutor("hz:map-store-offloadable");
        asyncExecutor.submit(() -> this.createMappingForMapStore(mapName));
    }

    private void verifyMapStoreOffload(HazelcastInstance instance, String mapName) {
        MapConfig mapConfig = instance.getConfig().findMapConfig(mapName);
        if (!mapConfig.getMapStoreConfig().isOffload()) {
            throw new HazelcastException("Config for GenericMapStore must have `offload` property set to true");
        }
    }

    private NodeEngineImpl nodeEngine() {
        return this.instance.node.nodeEngine;
    }

    private void createMappingForMapStore(String mapName) {
        this.logger.fine("Initializing for map " + mapName);
        try {
            String mappingColumns = null;
            if (this.properties.hasColumns()) {
                mappingColumns = this.resolveMappingColumns(this.properties.tableName, this.properties.externalDataStoreRef);
                this.logger.fine("Discovered following mapping columns: " + mappingColumns);
            }
            this.sql.execute("CREATE MAPPING \"" + this.mapping + "\" EXTERNAL NAME \"" + this.properties.tableName + "\" " + (mappingColumns != null ? " ( " + mappingColumns + " ) " : "") + "TYPE " + this.deriveMappingType() + " OPTIONS (    '" + "externalDataStoreRef" + "' = '" + this.properties.externalDataStoreRef + "' )", new Object[0]).close();
            if (!this.properties.hasColumns()) {
                this.columnMetadataList = this.loadMetadataFromMapping(this.mapping).getColumns();
            }
            this.queries = new Queries(this.mapping, this.properties.idColumn, this.columnMetadataList);
        }
        catch (Exception e) {
            if (e.getMessage() != null && e.getMessage().startsWith("Mapping or view already exists:")) {
                this.readExistingMapping();
            } else {
                this.logger.warning((Throwable)e);
                this.initFailure = e;
            }
        }
        finally {
            this.initFinished.countDown();
        }
    }

    private String deriveMappingType() {
        if (this.properties.mappingType != null) {
            return this.properties.mappingType;
        }
        ExternalDataStoreFactory factory = this.nodeEngine().getExternalDataStoreService().getExternalDataStoreFactory(this.properties.externalDataStoreRef);
        if (factory instanceof JdbcDataStoreFactory) {
            return "JDBC";
        }
        throw new HazelcastException("Unknown ExternalDataStoreFactory class " + factory.getClass() + ". Set the mapping type using '" + MAPPING_TYPE_PROPERTY + "' property");
    }

    private String resolveMappingColumns(String tableName, String externalDataStoreRef) {
        String tempMapping = "temp_mapping_" + UuidUtil.newUnsecureUuidString();
        this.createMapping(tempMapping, tableName, externalDataStoreRef);
        SqlRowMetadata rowMetadata = this.loadMetadataFromMapping(tempMapping);
        this.columnMetadataList = rowMetadata.getColumns();
        this.dropMapping(tempMapping);
        return Stream.concat(Stream.of(this.properties.idColumn), this.properties.columns.stream()).distinct().map(columnName -> this.validateColumn(rowMetadata.findColumn(columnName), (String)columnName)).map(arg_0 -> ((SqlRowMetadata)rowMetadata).getColumn(arg_0)).map(columnMetadata1 -> columnMetadata1.getName() + " " + columnMetadata1.getType()).collect(Collectors.joining(", "));
    }

    private void createMapping(String mappingName, String tableName, String externalDataStoreRef) {
        this.sql.execute("CREATE MAPPING \"" + mappingName + "\" EXTERNAL NAME \"" + tableName + "\"  TYPE " + this.deriveMappingType() + " OPTIONS (    '" + "externalDataStoreRef" + "' = '" + externalDataStoreRef + "' )", new Object[0]).close();
    }

    private SqlRowMetadata loadMetadataFromMapping(String mapping) {
        try (SqlResult result = this.sql.execute("SELECT * FROM \"" + mapping + "\" LIMIT 0", new Object[0]);){
            SqlRowMetadata rowMetadata;
            SqlRowMetadata sqlRowMetadata = rowMetadata = result.getRowMetadata();
            return sqlRowMetadata;
        }
    }

    private void readExistingMapping() {
        this.logger.fine("Reading existing mapping for map" + this.mapName);
        try (SqlResult mappings = this.sql.execute("SHOW MAPPINGS", new Object[0]);){
            for (SqlRow mapping : mappings) {
                String name = (String)mapping.getObject(MAPPING_NAME_COLUMN);
                if (!name.equals(this.mapping)) continue;
                SqlRowMetadata rowMetadata = this.loadMetadataFromMapping(name);
                this.validateColumns(rowMetadata);
                this.columnMetadataList = rowMetadata.getColumns();
                this.queries = new Queries(name, this.properties.idColumn, this.columnMetadataList);
                break;
            }
        }
        catch (Exception e) {
            this.initFailure = e;
        }
    }

    private void validateColumns(SqlRowMetadata rowMetadata) {
        Stream.concat(Stream.of(this.properties.idColumn), this.properties.columns.stream()).distinct().forEach(columnName -> this.validateColumn(rowMetadata.findColumn(columnName), (String)columnName));
    }

    private int validateColumn(int column, String columnName) {
        if (column == -1) {
            throw new HazelcastException("Column '" + columnName + "' not found");
        }
        return column;
    }

    public void destroy() {
        this.awaitInitFinished();
        this.dropMapping(this.mapping);
    }

    public GenericRecord load(K key) {
        this.awaitInitFinished();
        try (SqlResult queryResult = this.sql.execute(this.queries.load(), new Object[]{key});){
            Iterator it = queryResult.iterator();
            if (it.hasNext()) {
                SqlRow row = (SqlRow)it.next();
                if (it.hasNext()) {
                    throw new IllegalStateException("multiple matching rows for a key " + key);
                }
                GenericRecord genericRecord = this.convertRowToGenericRecord(key, row);
                return genericRecord;
            }
            GenericRecord genericRecord = null;
            return genericRecord;
        }
    }

    @Nonnull
    private GenericRecord convertRowToGenericRecord(K key, SqlRow row) {
        GenericRecordBuilder builder = GenericRecordBuilder.compact((String)this.properties.compactTypeName);
        SqlRowMetadata metadata = row.getMetadata();
        block13: for (int i = 0; i < metadata.getColumnCount(); ++i) {
            SqlColumnMetadata column = metadata.getColumn(i);
            if (column.getName().equals(this.properties.idColumn) && !this.properties.idColumnInColumns) continue;
            switch (column.getType()) {
                case VARCHAR: {
                    builder.setString(column.getName(), (String)row.getObject(i));
                    continue block13;
                }
                case BOOLEAN: {
                    builder.setBoolean(column.getName(), ((Boolean)row.getObject(i)).booleanValue());
                    continue block13;
                }
                case TINYINT: 
                case SMALLINT: 
                case INTEGER: {
                    builder.setInt32(column.getName(), ((Integer)row.getObject(i)).intValue());
                    continue block13;
                }
                case BIGINT: {
                    builder.setInt64(column.getName(), ((Long)row.getObject(i)).longValue());
                    continue block13;
                }
                case DECIMAL: {
                    builder.setDecimal(column.getName(), (BigDecimal)row.getObject(i));
                    continue block13;
                }
                case REAL: {
                    builder.setFloat32(column.getName(), ((Float)row.getObject(i)).floatValue());
                    continue block13;
                }
                case DOUBLE: {
                    builder.setFloat64(column.getName(), ((Double)row.getObject(i)).doubleValue());
                    continue block13;
                }
                case DATE: {
                    builder.setDate(column.getName(), (LocalDate)row.getObject(i));
                    continue block13;
                }
                case TIME: {
                    builder.setTime(column.getName(), (LocalTime)row.getObject(i));
                    continue block13;
                }
                case TIMESTAMP: {
                    builder.setTimestamp(column.getName(), (LocalDateTime)row.getObject(i));
                    continue block13;
                }
                case TIMESTAMP_WITH_TIME_ZONE: {
                    builder.setTimestampWithTimezone(column.getName(), (OffsetDateTime)row.getObject(i));
                    continue block13;
                }
                default: {
                    throw new HazelcastException("Column type " + column.getType() + " not supported");
                }
            }
        }
        return builder.build();
    }

    public Map<K, GenericRecord> loadAll(Collection<K> keys) {
        this.awaitInitFinished();
        Object[] keysArray = keys.toArray();
        try (SqlResult queryResult = this.sql.execute(this.queries.loadAll(keys.size()), keysArray);){
            Iterator it = queryResult.iterator();
            HashMap<Object, GenericRecord> result = new HashMap<Object, GenericRecord>();
            while (it.hasNext()) {
                SqlRow row = (SqlRow)it.next();
                Object id = row.getObject(this.properties.idColumn);
                GenericRecord record = this.convertRowToGenericRecord(id, row);
                result.put(id, record);
            }
            HashMap<Object, GenericRecord> hashMap = result;
            return hashMap;
        }
    }

    public Iterable<K> loadAllKeys() {
        this.awaitInitFinished();
        SqlResult keysResult = this.sql.execute(this.queries.loadAllKeys(), new Object[0]);
        return () -> new MappingClosingIterator<SqlRow, Object>(keysResult.iterator(), row -> row.getObject(this.properties.idColumn), () -> ((SqlResult)keysResult).close());
    }

    public void store(K key, GenericRecord record) {
        SqlColumnMetadata columnMetadata;
        this.awaitInitFinished();
        int idPos = -1;
        Object[] params = new Object[this.columnMetadataList.size()];
        block19: for (int i = 0; i < this.columnMetadataList.size(); ++i) {
            columnMetadata = this.columnMetadataList.get(i);
            if (columnMetadata.getName().equals(this.properties.idColumn)) {
                idPos = i;
            }
            switch (columnMetadata.getType()) {
                case VARCHAR: {
                    params[i] = record.getString(columnMetadata.getName());
                    continue block19;
                }
                case BOOLEAN: {
                    params[i] = record.getBoolean(columnMetadata.getName());
                    continue block19;
                }
                case TINYINT: {
                    params[i] = record.getInt8(columnMetadata.getName());
                    continue block19;
                }
                case SMALLINT: {
                    params[i] = record.getInt16(columnMetadata.getName());
                    continue block19;
                }
                case INTEGER: {
                    params[i] = record.getInt32(columnMetadata.getName());
                    continue block19;
                }
                case BIGINT: {
                    params[i] = record.getInt64(columnMetadata.getName());
                    continue block19;
                }
                case REAL: {
                    params[i] = Float.valueOf(record.getFloat32(columnMetadata.getName()));
                    continue block19;
                }
                case DOUBLE: {
                    params[i] = record.getFloat64(columnMetadata.getName());
                    continue block19;
                }
                case DATE: {
                    params[i] = record.getDate(columnMetadata.getName());
                    continue block19;
                }
                case TIME: {
                    params[i] = record.getTime(columnMetadata.getName());
                    continue block19;
                }
                case TIMESTAMP: {
                    params[i] = record.getTimestamp(columnMetadata.getName());
                    continue block19;
                }
                case TIMESTAMP_WITH_TIME_ZONE: {
                    params[i] = record.getTimestampWithTimezone(columnMetadata.getName());
                    continue block19;
                }
                case DECIMAL: {
                    params[i] = record.getDecimal(columnMetadata.getName());
                    continue block19;
                }
                default: {
                    throw new HazelcastException("Column type " + columnMetadata.getType() + " not supported");
                }
            }
        }
        try {
            SqlResult ignored = this.sql.execute(this.queries.storeInsert(), params);
            columnMetadata = null;
            if (ignored != null) {
                if (columnMetadata != null) {
                    try {
                        ignored.close();
                    }
                    catch (Throwable throwable) {
                        columnMetadata.addSuppressed(throwable);
                    }
                } else {
                    ignored.close();
                }
            }
        }
        catch (Exception e) {
            if (e.getMessage() != null && (e.getMessage().contains(H2_PK_VIOLATION) || e.getMessage().contains(PG_PK_VIOLATION) || e.getMessage().contains(MYSQL_PK_VIOLATION))) {
                Object tmp = params[idPos];
                params[idPos] = params[params.length - 1];
                params[params.length - 1] = tmp;
                this.sql.execute(this.queries.storeUpdate(), params).close();
            }
            throw e;
        }
    }

    public void storeAll(Map<K, GenericRecord> map) {
        this.awaitInitFinished();
        for (Map.Entry<K, GenericRecord> entry : map.entrySet()) {
            this.store(entry.getKey(), entry.getValue());
        }
    }

    public void delete(K key) {
        this.awaitInitFinished();
        this.sql.execute(this.queries.delete(), new Object[]{key}).close();
    }

    public void deleteAll(Collection<K> keys) {
        this.awaitInitFinished();
        if (keys.isEmpty()) {
            return;
        }
        this.sql.execute(this.queries.deleteAll(keys.size()), keys.toArray()).close();
    }

    private void dropMapping(String mappingName) {
        this.sql.execute("DROP MAPPING IF EXISTS \"" + mappingName + "\"", new Object[0]).close();
    }

    private void awaitInitFinished() {
        try {
            boolean finished = this.initFinished.await(this.initTimeoutMillis, TimeUnit.MILLISECONDS);
            if (!finished) {
                throw new HazelcastException("MapStore init for map: " + this.mapName + " timed out after " + this.initTimeoutMillis + " ms", (Throwable)this.initFailure);
            }
            if (this.initFailure != null) {
                throw new HazelcastException("MapStore init failed for map: " + this.mapName, (Throwable)this.initFailure);
            }
        }
        catch (InterruptedException e) {
            throw new HazelcastException((Throwable)e);
        }
    }

    private static class GenericMapStoreProperties {
        final String externalDataStoreRef;
        final String tableName;
        final String mappingType;
        final String idColumn;
        final Collection<String> columns;
        final boolean idColumnInColumns;
        final String compactTypeName;

        GenericMapStoreProperties(Properties properties, String mapName) {
            this.externalDataStoreRef = properties.getProperty(GenericMapStore.EXTERNAL_REF_ID_PROPERTY);
            this.tableName = properties.getProperty(GenericMapStore.TABLE_NAME_PROPERTY, mapName);
            this.mappingType = properties.getProperty(GenericMapStore.MAPPING_TYPE_PROPERTY);
            this.idColumn = properties.getProperty(GenericMapStore.ID_COLUMN_PROPERTY, GenericMapStore.ID_COLUMN_DEFAULT);
            String columnsProperty = properties.getProperty(GenericMapStore.COLUMNS_PROPERTY);
            if (columnsProperty != null) {
                ArrayList columns = new ArrayList();
                Collections.addAll(columns, columnsProperty.split(","));
                this.columns = Collections.unmodifiableList(columns);
            } else {
                this.columns = Collections.emptyList();
            }
            this.idColumnInColumns = this.columns.isEmpty() || this.columns.contains(this.idColumn);
            this.compactTypeName = properties.getProperty(GenericMapStore.TYPE_NAME_PROPERTY, mapName);
        }

        public boolean hasColumns() {
            return !this.columns.isEmpty();
        }
    }
}

