/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.org.apache.calcite.util;

import com.hazelcast.org.apache.calcite.linq4j.Nullness;
import com.hazelcast.org.checkerframework.checker.nullness.qual.Nullable;
import com.hazelcast.org.checkerframework.checker.nullness.qual.PolyNull;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.util.Locale;

public class NumberUtil {
    private static final DecimalFormat FLOAT_FORMATTER = NumberUtil.decimalFormat("0.######E0");
    private static final DecimalFormat DOUBLE_FORMATTER = NumberUtil.decimalFormat("0.###############E0");
    private static final BigInteger[] BIG_INT_TEN_POW = new BigInteger[20];
    private static final BigInteger[] BIG_INT_MIN_UNSCALED = new BigInteger[20];
    private static final BigInteger[] BIG_INT_MAX_UNSCALED = new BigInteger[20];

    private NumberUtil() {
    }

    public static DecimalFormat decimalFormat(String pattern) {
        return new DecimalFormat(pattern, DecimalFormatSymbols.getInstance(Locale.ROOT));
    }

    public static BigInteger powTen(int exponent) {
        if (exponent >= 0 && exponent < BIG_INT_TEN_POW.length) {
            return BIG_INT_TEN_POW[exponent];
        }
        return BigInteger.TEN.pow(exponent);
    }

    public static BigInteger getMaxUnscaled(int precision) {
        return BIG_INT_MAX_UNSCALED[precision];
    }

    public static BigInteger getMinUnscaled(int precision) {
        return BIG_INT_MIN_UNSCALED[precision];
    }

    public static @PolyNull BigDecimal rescaleBigDecimal(@PolyNull BigDecimal bd, int scale) {
        if (bd != null) {
            bd = bd.setScale(scale, RoundingMode.HALF_UP);
        }
        return bd;
    }

    public static BigDecimal toBigDecimal(Number number, int scale) {
        BigDecimal bd = NumberUtil.toBigDecimal(number);
        return NumberUtil.rescaleBigDecimal(bd, scale);
    }

    public static @PolyNull BigDecimal toBigDecimal(@PolyNull Number number) {
        if (number == null) {
            return Nullness.castNonNull(null);
        }
        if (number instanceof BigDecimal) {
            return (BigDecimal)number;
        }
        if (number instanceof Double || number instanceof Float) {
            return BigDecimal.valueOf(number.doubleValue());
        }
        if (number instanceof BigInteger) {
            return new BigDecimal((BigInteger)number);
        }
        return new BigDecimal(number.longValue());
    }

    public static boolean isValidDecimal(BigDecimal bd) {
        BigInteger usv = bd.unscaledValue();
        long usvl = usv.longValue();
        return usv.equals(BigInteger.valueOf(usvl));
    }

    public static NumberFormat getApproxFormatter(boolean isFloat) {
        return isFloat ? FLOAT_FORMATTER : DOUBLE_FORMATTER;
    }

    public static long round(double d) {
        if (d < 0.0) {
            return (long)(d - 0.5);
        }
        return (long)(d + 0.5);
    }

    public static @PolyNull Double add(@PolyNull Double a, @PolyNull Double b) {
        if (a == null || b == null) {
            return null;
        }
        return a + b;
    }

    public static @PolyNull Double subtract(@PolyNull Double a, @PolyNull Double b) {
        if (a == null || b == null) {
            return Nullness.castNonNull(null);
        }
        return a - b;
    }

    public static @Nullable Double divide(@Nullable Double a, @Nullable Double b) {
        if (a == null || b == null || b == 0.0) {
            return Nullness.castNonNull(null);
        }
        return a / b;
    }

    public static @PolyNull Double multiply(@PolyNull Double a, @PolyNull Double b) {
        if (a == null || b == null) {
            return Nullness.castNonNull(null);
        }
        return a * b;
    }

    public static @PolyNull Double min(@PolyNull Double a, @PolyNull Double b) {
        if (a == null) {
            return b;
        }
        if (b == null) {
            return a;
        }
        return Math.min(a, b);
    }

    public static @PolyNull Double max(@PolyNull Double a, @PolyNull Double b) {
        if (a == null || b == null) {
            return Nullness.castNonNull(null);
        }
        return Math.max(a, b);
    }

    static {
        for (int i = 0; i < BIG_INT_TEN_POW.length; ++i) {
            NumberUtil.BIG_INT_TEN_POW[i] = BigInteger.TEN.pow(i);
            if (i < 19) {
                NumberUtil.BIG_INT_MAX_UNSCALED[i] = BIG_INT_TEN_POW[i].subtract(BigInteger.ONE);
                NumberUtil.BIG_INT_MIN_UNSCALED[i] = BIG_INT_MAX_UNSCALED[i].negate();
                continue;
            }
            NumberUtil.BIG_INT_MAX_UNSCALED[i] = BigInteger.valueOf(Long.MAX_VALUE);
            NumberUtil.BIG_INT_MIN_UNSCALED[i] = BigInteger.valueOf(Long.MIN_VALUE);
        }
    }
}

