/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.org.apache.calcite.sql2rel;

import com.hazelcast.com.google.common.base.Preconditions;
import com.hazelcast.org.apache.calcite.avatica.util.ByteString;
import com.hazelcast.org.apache.calcite.rel.type.RelDataType;
import com.hazelcast.org.apache.calcite.rel.type.RelDataTypeFactory;
import com.hazelcast.org.apache.calcite.rex.RexBuilder;
import com.hazelcast.org.apache.calcite.rex.RexLiteral;
import com.hazelcast.org.apache.calcite.rex.RexNode;
import com.hazelcast.org.apache.calcite.sql.SqlCall;
import com.hazelcast.org.apache.calcite.sql.SqlIntervalQualifier;
import com.hazelcast.org.apache.calcite.sql.SqlLiteral;
import com.hazelcast.org.apache.calcite.sql.SqlTimeLiteral;
import com.hazelcast.org.apache.calcite.sql.SqlTimestampLiteral;
import com.hazelcast.org.apache.calcite.sql.type.SqlTypeName;
import com.hazelcast.org.apache.calcite.sql.validate.SqlValidator;
import com.hazelcast.org.apache.calcite.sql2rel.SqlNodeToRexConverter;
import com.hazelcast.org.apache.calcite.sql2rel.SqlRexContext;
import com.hazelcast.org.apache.calcite.sql2rel.SqlRexConvertlet;
import com.hazelcast.org.apache.calcite.sql2rel.SqlRexConvertletTable;
import com.hazelcast.org.apache.calcite.util.BitString;
import com.hazelcast.org.apache.calcite.util.DateString;
import com.hazelcast.org.apache.calcite.util.NlsString;
import com.hazelcast.org.apache.calcite.util.TimeString;
import com.hazelcast.org.apache.calcite.util.TimestampString;
import com.hazelcast.org.apache.calcite.util.Util;
import java.math.BigDecimal;

public class SqlNodeToRexConverterImpl
implements SqlNodeToRexConverter {
    private final SqlRexConvertletTable convertletTable;

    SqlNodeToRexConverterImpl(SqlRexConvertletTable convertletTable) {
        this.convertletTable = convertletTable;
    }

    @Override
    public RexNode convertCall(SqlRexContext cx, SqlCall call) {
        SqlRexConvertlet convertlet = this.convertletTable.get(call);
        if (convertlet != null) {
            return convertlet.convertCall(cx, call);
        }
        throw Util.needToImplement(call);
    }

    @Override
    public RexLiteral convertInterval(SqlRexContext cx, SqlIntervalQualifier intervalQualifier) {
        RexBuilder rexBuilder = cx.getRexBuilder();
        return rexBuilder.makeIntervalLiteral(intervalQualifier);
    }

    @Override
    public RexNode convertLiteral(SqlRexContext cx, SqlLiteral literal) {
        RexBuilder rexBuilder = cx.getRexBuilder();
        RelDataTypeFactory typeFactory = cx.getTypeFactory();
        SqlValidator validator = cx.getValidator();
        if (literal.getValue() == null) {
            RelDataType type;
            if (literal.getTypeName() == SqlTypeName.BOOLEAN) {
                type = typeFactory.createSqlType(SqlTypeName.BOOLEAN);
                type = typeFactory.createTypeWithNullability(type, true);
            } else {
                type = validator.getValidatedNodeType(literal);
            }
            return rexBuilder.makeNullLiteral(type);
        }
        switch (literal.getTypeName()) {
            case DECIMAL: {
                BigDecimal bd = literal.getValueAs(BigDecimal.class);
                return rexBuilder.makeExactLiteral(bd, literal.createSqlType(typeFactory));
            }
            case DOUBLE: {
                return rexBuilder.makeApproxLiteral(literal.getValueAs(BigDecimal.class));
            }
            case CHAR: {
                return rexBuilder.makeCharLiteral(literal.getValueAs(NlsString.class));
            }
            case BOOLEAN: {
                return rexBuilder.makeLiteral(literal.getValueAs(Boolean.class));
            }
            case BINARY: {
                BitString bitString = literal.getValueAs(BitString.class);
                Preconditions.checkArgument(bitString.getBitCount() % 8 == 0, "incomplete octet");
                ByteString byteString = new ByteString(bitString.getAsByteArray());
                return rexBuilder.makeBinaryLiteral(byteString);
            }
            case SYMBOL: {
                return rexBuilder.makeFlag(literal.getValueAs(Enum.class));
            }
            case TIMESTAMP: {
                return rexBuilder.makeTimestampLiteral(literal.getValueAs(TimestampString.class), ((SqlTimestampLiteral)literal).getPrec());
            }
            case TIME: {
                return rexBuilder.makeTimeLiteral(literal.getValueAs(TimeString.class), ((SqlTimeLiteral)literal).getPrec());
            }
            case DATE: {
                return rexBuilder.makeDateLiteral(literal.getValueAs(DateString.class));
            }
            case INTERVAL_YEAR: 
            case INTERVAL_YEAR_MONTH: 
            case INTERVAL_MONTH: 
            case INTERVAL_DAY: 
            case INTERVAL_DAY_HOUR: 
            case INTERVAL_DAY_MINUTE: 
            case INTERVAL_DAY_SECOND: 
            case INTERVAL_HOUR: 
            case INTERVAL_HOUR_MINUTE: 
            case INTERVAL_HOUR_SECOND: 
            case INTERVAL_MINUTE: 
            case INTERVAL_MINUTE_SECOND: 
            case INTERVAL_SECOND: {
                SqlIntervalQualifier sqlIntervalQualifier = literal.getValueAs(SqlIntervalQualifier.class);
                return rexBuilder.makeIntervalLiteral(literal.getValueAs(BigDecimal.class), sqlIntervalQualifier);
            }
        }
        throw Util.unexpected(literal.getTypeName());
    }
}

