/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.org.apache.calcite.sql.ddl;

import com.hazelcast.com.google.common.collect.ImmutableList;
import com.hazelcast.org.apache.calcite.sql.SqlCall;
import com.hazelcast.org.apache.calcite.sql.SqlCollation;
import com.hazelcast.org.apache.calcite.sql.SqlDataTypeSpec;
import com.hazelcast.org.apache.calcite.sql.SqlIdentifier;
import com.hazelcast.org.apache.calcite.sql.SqlKind;
import com.hazelcast.org.apache.calcite.sql.SqlNode;
import com.hazelcast.org.apache.calcite.sql.SqlOperator;
import com.hazelcast.org.apache.calcite.sql.SqlSpecialOperator;
import com.hazelcast.org.apache.calcite.sql.SqlWriter;
import com.hazelcast.org.apache.calcite.sql.ddl.SqlColumnDeclaration;
import com.hazelcast.org.apache.calcite.sql.parser.SqlParserPos;
import com.hazelcast.org.checkerframework.checker.nullness.qual.Nullable;
import java.util.List;

public class SqlAttributeDefinition
extends SqlCall {
    private static final SqlSpecialOperator OPERATOR = new SqlSpecialOperator("ATTRIBUTE_DEF", SqlKind.ATTRIBUTE_DEF);
    public final SqlIdentifier name;
    public final SqlDataTypeSpec dataType;
    final @Nullable SqlNode expression;
    final @Nullable SqlCollation collation;

    SqlAttributeDefinition(SqlParserPos pos, SqlIdentifier name, SqlDataTypeSpec dataType, @Nullable SqlNode expression, @Nullable SqlCollation collation) {
        super(pos);
        this.name = name;
        this.dataType = dataType;
        this.expression = expression;
        this.collation = collation;
    }

    @Override
    public SqlOperator getOperator() {
        return OPERATOR;
    }

    @Override
    public List<SqlNode> getOperandList() {
        return ImmutableList.of(this.name, this.dataType);
    }

    @Override
    public void unparse(SqlWriter writer, int leftPrec, int rightPrec) {
        SqlNode expression;
        this.name.unparse(writer, 0, 0);
        this.dataType.unparse(writer, 0, 0);
        if (this.collation != null) {
            writer.keyword("COLLATE");
            this.collation.unparse(writer);
        }
        if (Boolean.FALSE.equals(this.dataType.getNullable())) {
            writer.keyword("NOT NULL");
        }
        if ((expression = this.expression) != null) {
            writer.keyword("DEFAULT");
            SqlColumnDeclaration.exp(writer, expression);
        }
    }
}

