/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.org.apache.calcite.rel.rules;

import com.hazelcast.org.apache.calcite.plan.RelOptRuleCall;
import com.hazelcast.org.apache.calcite.plan.RelRule;
import com.hazelcast.org.apache.calcite.rel.RelCollation;
import com.hazelcast.org.apache.calcite.rel.RelCollationTraitDef;
import com.hazelcast.org.apache.calcite.rel.RelCollations;
import com.hazelcast.org.apache.calcite.rel.RelFieldCollation;
import com.hazelcast.org.apache.calcite.rel.RelNode;
import com.hazelcast.org.apache.calcite.rel.core.Join;
import com.hazelcast.org.apache.calcite.rel.core.Sort;
import com.hazelcast.org.apache.calcite.rel.logical.LogicalJoin;
import com.hazelcast.org.apache.calcite.rel.logical.LogicalSort;
import com.hazelcast.org.apache.calcite.rel.metadata.RelMdUtil;
import com.hazelcast.org.apache.calcite.rel.metadata.RelMetadataQuery;
import com.hazelcast.org.apache.calcite.rel.rules.ImmutableSortJoinCopyRule;
import com.hazelcast.org.apache.calcite.rel.rules.TransformationRule;
import com.hazelcast.org.apache.calcite.tools.RelBuilderFactory;
import java.util.ArrayList;
import org.immutables.value.Value;

@Value.Enclosing
public class SortJoinCopyRule
extends RelRule<Config>
implements TransformationRule {
    protected SortJoinCopyRule(Config config) {
        super(config);
    }

    @Deprecated
    public SortJoinCopyRule(Class<? extends Sort> sortClass, Class<? extends Join> joinClass, RelBuilderFactory relBuilderFactory) {
        this(Config.DEFAULT.withOperandFor(sortClass, joinClass).withRelBuilderFactory(relBuilderFactory).as(Config.class));
    }

    @Override
    public void onMatch(RelOptRuleCall call) {
        RelNode newRightInput;
        RelNode newLeftInput;
        Sort sort = (Sort)call.rel(0);
        Join join = (Join)call.rel(1);
        RelMetadataQuery metadataQuery = call.getMetadataQuery();
        ArrayList<RelFieldCollation> leftFieldCollation = new ArrayList<RelFieldCollation>();
        ArrayList<RelFieldCollation> rightFieldCollation = new ArrayList<RelFieldCollation>();
        for (RelFieldCollation relFieldCollation : sort.getCollation().getFieldCollations()) {
            if (relFieldCollation.getFieldIndex() >= join.getLeft().getRowType().getFieldCount()) {
                rightFieldCollation.add(relFieldCollation);
                continue;
            }
            leftFieldCollation.add(relFieldCollation);
        }
        if (leftFieldCollation.isEmpty()) {
            newLeftInput = join.getLeft();
        } else {
            RelCollation leftCollation = RelCollationTraitDef.INSTANCE.canonize(RelCollations.of(leftFieldCollation));
            newLeftInput = RelMdUtil.checkInputForCollationAndLimit(metadataQuery, join.getLeft(), leftCollation, null, null) ? join.getLeft() : sort.copy(sort.getTraitSet().replaceIf(RelCollationTraitDef.INSTANCE, () -> leftCollation), join.getLeft(), leftCollation, null, null);
        }
        if (rightFieldCollation.isEmpty()) {
            newRightInput = join.getRight();
        } else {
            RelCollation rightCollation = RelCollationTraitDef.INSTANCE.canonize(RelCollations.shift(RelCollations.of(rightFieldCollation), -join.getLeft().getRowType().getFieldCount()));
            newRightInput = RelMdUtil.checkInputForCollationAndLimit(metadataQuery, join.getRight(), rightCollation, null, null) ? join.getRight() : sort.copy(sort.getTraitSet().replaceIf(RelCollationTraitDef.INSTANCE, () -> rightCollation), join.getRight(), rightCollation, null, null);
        }
        if (newLeftInput == join.getLeft() && newRightInput == join.getRight()) {
            return;
        }
        Join joinCopy = join.copy(join.getTraitSet(), join.getCondition(), newLeftInput, newRightInput, join.getJoinType(), join.isSemiJoinDone());
        Sort sortCopy = sort.copy(sort.getTraitSet(), joinCopy, sort.getCollation(), sort.offset, sort.fetch);
        call.transformTo(sortCopy);
    }

    @Value.Immutable
    public static interface Config
    extends RelRule.Config {
        public static final Config DEFAULT = ImmutableSortJoinCopyRule.Config.of().withOperandFor(LogicalSort.class, LogicalJoin.class);

        @Override
        default public SortJoinCopyRule toRule() {
            return new SortJoinCopyRule(this);
        }

        default public Config withOperandFor(Class<? extends Sort> sortClass, Class<? extends Join> joinClass) {
            return this.withOperandSupplier(b0 -> b0.operand(sortClass).oneInput(b1 -> b1.operand(joinClass).anyInputs())).as(Config.class);
        }
    }
}

