/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.org.apache.calcite.rel.rules;

import com.hazelcast.org.apache.calcite.plan.RelOptRuleCall;
import com.hazelcast.org.apache.calcite.plan.RelRule;
import com.hazelcast.org.apache.calcite.rel.RelNode;
import com.hazelcast.org.apache.calcite.rel.core.Aggregate;
import com.hazelcast.org.apache.calcite.rel.core.AggregateCall;
import com.hazelcast.org.apache.calcite.rel.core.RelFactories;
import com.hazelcast.org.apache.calcite.rel.logical.LogicalAggregate;
import com.hazelcast.org.apache.calcite.rel.metadata.RelMetadataQuery;
import com.hazelcast.org.apache.calcite.rel.rules.ImmutableAggregateRemoveRule;
import com.hazelcast.org.apache.calcite.rel.rules.SubstitutionRule;
import com.hazelcast.org.apache.calcite.rex.RexBuilder;
import com.hazelcast.org.apache.calcite.rex.RexNode;
import com.hazelcast.org.apache.calcite.runtime.SqlFunctions;
import com.hazelcast.org.apache.calcite.sql.SqlAggFunction;
import com.hazelcast.org.apache.calcite.sql.SqlKind;
import com.hazelcast.org.apache.calcite.sql.SqlSplittableAggFunction;
import com.hazelcast.org.apache.calcite.tools.RelBuilder;
import com.hazelcast.org.apache.calcite.tools.RelBuilderFactory;
import java.util.ArrayList;
import org.immutables.value.Value;

@Value.Enclosing
public class AggregateRemoveRule
extends RelRule<Config>
implements SubstitutionRule {
    protected AggregateRemoveRule(Config config) {
        super(config);
    }

    @Deprecated
    public AggregateRemoveRule(Class<? extends Aggregate> aggregateClass) {
        this(aggregateClass, RelFactories.LOGICAL_BUILDER);
    }

    @Deprecated
    public AggregateRemoveRule(Class<? extends Aggregate> aggregateClass, RelBuilderFactory relBuilderFactory) {
        this(Config.DEFAULT.withRelBuilderFactory(relBuilderFactory).as(Config.class).withOperandFor(aggregateClass));
    }

    private static boolean isAggregateSupported(Aggregate aggregate) {
        if (aggregate.getGroupType() != Aggregate.Group.SIMPLE || aggregate.getGroupCount() == 0) {
            return false;
        }
        for (AggregateCall aggregateCall : aggregate.getAggCallList()) {
            if (aggregateCall.filterArg < 0 && aggregateCall.getAggregation().maybeUnwrap(SqlSplittableAggFunction.class).isPresent()) continue;
            return false;
        }
        return true;
    }

    @Override
    public void onMatch(RelOptRuleCall call) {
        Aggregate aggregate = (Aggregate)call.rel(0);
        RelNode input = aggregate.getInput();
        RelMetadataQuery mq = call.getMetadataQuery();
        if (!SqlFunctions.isTrue(mq.areColumnsUnique(input, aggregate.getGroupSet()))) {
            return;
        }
        RelBuilder relBuilder = call.builder();
        RexBuilder rexBuilder = relBuilder.getRexBuilder();
        ArrayList<RexNode> projects = new ArrayList<RexNode>();
        for (AggregateCall aggCall : aggregate.getAggCallList()) {
            SqlAggFunction aggregation = aggCall.getAggregation();
            if (aggregation.getKind() == SqlKind.SUM0) {
                return;
            }
            SqlSplittableAggFunction splitter = aggregation.unwrapOrThrow(SqlSplittableAggFunction.class);
            RexNode singleton = splitter.singleton(rexBuilder, input.getRowType(), aggCall);
            RexNode cast = rexBuilder.ensureType(aggCall.type, singleton, false);
            projects.add(cast);
        }
        RelNode newInput = AggregateRemoveRule.convert(input, aggregate.getTraitSet().simplify());
        relBuilder.push(newInput);
        if (!projects.isEmpty()) {
            projects.addAll(0, relBuilder.fields(aggregate.getGroupSet()));
            relBuilder.project(projects);
        } else if (newInput.getRowType().getFieldCount() > aggregate.getRowType().getFieldCount()) {
            relBuilder.project(relBuilder.fields(aggregate.getGroupSet()));
        }
        call.getPlanner().prune(aggregate);
        call.transformTo(relBuilder.build());
    }

    @Value.Immutable
    public static interface Config
    extends RelRule.Config {
        public static final Config DEFAULT = ImmutableAggregateRemoveRule.Config.of().withRelBuilderFactory(RelFactories.LOGICAL_BUILDER).withOperandFor(LogicalAggregate.class);

        @Override
        default public AggregateRemoveRule toRule() {
            return new AggregateRemoveRule(this);
        }

        default public Config withOperandFor(Class<? extends Aggregate> aggregateClass) {
            return this.withOperandSupplier(b -> b.operand(aggregateClass).predicate(x$0 -> AggregateRemoveRule.isAggregateSupported(x$0)).anyInputs()).as(Config.class);
        }
    }
}

