/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.org.apache.calcite.prepare;

import com.hazelcast.com.google.common.collect.ImmutableList;
import com.hazelcast.com.google.common.collect.Iterables;
import com.hazelcast.org.apache.calcite.config.CalciteConnectionConfig;
import com.hazelcast.org.apache.calcite.jdbc.CalciteSchema;
import com.hazelcast.org.apache.calcite.jdbc.JavaTypeFactoryImpl;
import com.hazelcast.org.apache.calcite.linq4j.function.Hints;
import com.hazelcast.org.apache.calcite.model.ModelHandler;
import com.hazelcast.org.apache.calcite.plan.RelOptPlanner;
import com.hazelcast.org.apache.calcite.plan.RelOptSchema;
import com.hazelcast.org.apache.calcite.prepare.Prepare;
import com.hazelcast.org.apache.calcite.prepare.RelOptTableImpl;
import com.hazelcast.org.apache.calcite.rel.type.RelDataType;
import com.hazelcast.org.apache.calcite.rel.type.RelDataTypeFactory;
import com.hazelcast.org.apache.calcite.rel.type.RelDataTypeFactoryImpl;
import com.hazelcast.org.apache.calcite.rel.type.RelDataTypeField;
import com.hazelcast.org.apache.calcite.schema.AggregateFunction;
import com.hazelcast.org.apache.calcite.schema.ScalarFunction;
import com.hazelcast.org.apache.calcite.schema.Table;
import com.hazelcast.org.apache.calcite.schema.TableFunction;
import com.hazelcast.org.apache.calcite.schema.TableMacro;
import com.hazelcast.org.apache.calcite.schema.Wrapper;
import com.hazelcast.org.apache.calcite.schema.impl.ScalarFunctionImpl;
import com.hazelcast.org.apache.calcite.sql.SqlFunctionCategory;
import com.hazelcast.org.apache.calcite.sql.SqlIdentifier;
import com.hazelcast.org.apache.calcite.sql.SqlKind;
import com.hazelcast.org.apache.calcite.sql.SqlOperator;
import com.hazelcast.org.apache.calcite.sql.SqlOperatorTable;
import com.hazelcast.org.apache.calcite.sql.SqlSyntax;
import com.hazelcast.org.apache.calcite.sql.parser.SqlParserPos;
import com.hazelcast.org.apache.calcite.sql.type.InferTypes;
import com.hazelcast.org.apache.calcite.sql.type.OperandTypes;
import com.hazelcast.org.apache.calcite.sql.type.ReturnTypes;
import com.hazelcast.org.apache.calcite.sql.type.SqlOperandMetadata;
import com.hazelcast.org.apache.calcite.sql.type.SqlOperandTypeInference;
import com.hazelcast.org.apache.calcite.sql.type.SqlReturnTypeInference;
import com.hazelcast.org.apache.calcite.sql.type.SqlTypeFamily;
import com.hazelcast.org.apache.calcite.sql.type.SqlTypeName;
import com.hazelcast.org.apache.calcite.sql.util.SqlOperatorTables;
import com.hazelcast.org.apache.calcite.sql.validate.SqlMoniker;
import com.hazelcast.org.apache.calcite.sql.validate.SqlMonikerImpl;
import com.hazelcast.org.apache.calcite.sql.validate.SqlMonikerType;
import com.hazelcast.org.apache.calcite.sql.validate.SqlNameMatcher;
import com.hazelcast.org.apache.calcite.sql.validate.SqlNameMatchers;
import com.hazelcast.org.apache.calcite.sql.validate.SqlUserDefinedAggFunction;
import com.hazelcast.org.apache.calcite.sql.validate.SqlUserDefinedFunction;
import com.hazelcast.org.apache.calcite.sql.validate.SqlUserDefinedTableFunction;
import com.hazelcast.org.apache.calcite.sql.validate.SqlUserDefinedTableMacro;
import com.hazelcast.org.apache.calcite.sql.validate.SqlValidatorUtil;
import com.hazelcast.org.apache.calcite.util.Optionality;
import com.hazelcast.org.apache.calcite.util.Util;
import com.hazelcast.org.checkerframework.checker.nullness.qual.Nullable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.NavigableMap;
import java.util.NavigableSet;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;

public class CalciteCatalogReader
implements Prepare.CatalogReader {
    protected final CalciteSchema rootSchema;
    protected final RelDataTypeFactory typeFactory;
    private final List<List<String>> schemaPaths;
    protected final SqlNameMatcher nameMatcher;
    protected final CalciteConnectionConfig config;

    public CalciteCatalogReader(CalciteSchema rootSchema, List<String> defaultSchema, RelDataTypeFactory typeFactory, CalciteConnectionConfig config) {
        this(rootSchema, SqlNameMatchers.withCaseSensitive(config != null && config.caseSensitive()), ImmutableList.of(Objects.requireNonNull(defaultSchema, "defaultSchema"), ImmutableList.of()), typeFactory, config);
    }

    protected CalciteCatalogReader(CalciteSchema rootSchema, SqlNameMatcher nameMatcher, List<List<String>> schemaPaths, RelDataTypeFactory typeFactory, CalciteConnectionConfig config) {
        this.rootSchema = Objects.requireNonNull(rootSchema, "rootSchema");
        this.nameMatcher = nameMatcher;
        this.schemaPaths = Util.immutableCopy(Util.isDistinct(schemaPaths) ? schemaPaths : new LinkedHashSet<List<String>>(schemaPaths));
        this.typeFactory = typeFactory;
        this.config = config;
    }

    @Override
    public CalciteCatalogReader withSchemaPath(List<String> schemaPath) {
        return new CalciteCatalogReader(this.rootSchema, this.nameMatcher, ImmutableList.of(schemaPath, ImmutableList.of()), this.typeFactory, this.config);
    }

    @Override
    public  @Nullable Prepare.PreparingTable getTable(List<String> names) {
        CalciteSchema.TableEntry entry = SqlValidatorUtil.getTableEntry(this, names);
        if (entry != null) {
            Prepare.PreparingTable relOptTable;
            Table table = entry.getTable();
            if (table instanceof Wrapper && (relOptTable = ((Wrapper)((Object)table)).unwrap(Prepare.PreparingTable.class)) != null) {
                return relOptTable;
            }
            return RelOptTableImpl.create((RelOptSchema)this, table.getRowType(this.typeFactory), entry, null);
        }
        return null;
    }

    @Override
    public CalciteConnectionConfig getConfig() {
        return this.config;
    }

    private Collection<com.hazelcast.org.apache.calcite.schema.Function> getFunctionsFrom(List<String> names) {
        CalciteSchema schema;
        ArrayList<com.hazelcast.org.apache.calcite.schema.Function> functions2 = new ArrayList<com.hazelcast.org.apache.calcite.schema.Function>();
        ArrayList<List<String>> schemaNameList = new ArrayList<List<String>>();
        if (names.size() > 1) {
            if (this.schemaPaths.size() > 1) {
                schemaNameList.addAll(Util.skip(this.schemaPaths));
            } else {
                schemaNameList.addAll(this.schemaPaths);
            }
        } else {
            for (List<String> schemaPath : this.schemaPaths) {
                schema = SqlValidatorUtil.getSchema(this.rootSchema, schemaPath, this.nameMatcher);
                if (schema == null) continue;
                schemaNameList.addAll(schema.getPath());
            }
        }
        for (List<String> schemaNames : schemaNameList) {
            schema = SqlValidatorUtil.getSchema(this.rootSchema, Iterables.concat(schemaNames, Util.skipLast(names)), this.nameMatcher);
            if (schema == null) continue;
            String name = Util.last(names);
            boolean caseSensitive = this.nameMatcher.isCaseSensitive();
            functions2.addAll(schema.getFunctions(name, caseSensitive));
        }
        return functions2;
    }

    @Override
    public @Nullable RelDataType getNamedType(SqlIdentifier typeName) {
        CalciteSchema.TypeEntry typeEntry = SqlValidatorUtil.getTypeEntry(this.getRootSchema(), typeName);
        if (typeEntry != null) {
            return (RelDataType)typeEntry.getType().apply(this.typeFactory);
        }
        return null;
    }

    @Override
    public List<SqlMoniker> getAllSchemaObjectNames(List<String> names) {
        CalciteSchema schema = SqlValidatorUtil.getSchema(this.rootSchema, names, this.nameMatcher);
        if (schema == null) {
            return ImmutableList.of();
        }
        ImmutableList.Builder result = new ImmutableList.Builder();
        if (!schema.name.equals("")) {
            result.add(CalciteCatalogReader.moniker(schema, null, SqlMonikerType.SCHEMA));
        }
        NavigableMap<String, CalciteSchema> schemaMap = schema.getSubSchemaMap();
        for (String subSchema : schemaMap.keySet()) {
            result.add(CalciteCatalogReader.moniker(schema, subSchema, SqlMonikerType.SCHEMA));
        }
        for (String table : schema.getTableNames()) {
            result.add(CalciteCatalogReader.moniker(schema, table, SqlMonikerType.TABLE));
        }
        NavigableSet<String> functions = schema.getFunctionNames();
        for (String function : functions) {
            result.add(CalciteCatalogReader.moniker(schema, function, SqlMonikerType.FUNCTION));
        }
        return result.build();
    }

    private static SqlMonikerImpl moniker(CalciteSchema schema, @Nullable String name, SqlMonikerType type) {
        List<String> path = schema.path(name);
        if (path.size() == 1 && !schema.root().name.equals("") && type == SqlMonikerType.SCHEMA) {
            type = SqlMonikerType.CATALOG;
        }
        return new SqlMonikerImpl(path, type);
    }

    @Override
    public List<List<String>> getSchemaPaths() {
        return this.schemaPaths;
    }

    @Override
    public  @Nullable Prepare.PreparingTable getTableForMember(List<String> names) {
        return this.getTable((List)names);
    }

    @Override
    public @Nullable RelDataTypeField field(RelDataType rowType, String alias) {
        return this.nameMatcher.field(rowType, alias);
    }

    @Override
    public boolean matches(String string, String name) {
        return this.nameMatcher.matches(string, name);
    }

    @Override
    public RelDataType createTypeFromProjection(RelDataType type, List<String> columnNameList) {
        return SqlValidatorUtil.createTypeFromProjection(type, columnNameList, this.typeFactory, this.nameMatcher.isCaseSensitive());
    }

    @Override
    public void lookupOperatorOverloads(SqlIdentifier opName, @Nullable SqlFunctionCategory category, SqlSyntax syntax, List<SqlOperator> operatorList, SqlNameMatcher nameMatcher) {
        if (syntax != SqlSyntax.FUNCTION) {
            return;
        }
        Predicate<com.hazelcast.org.apache.calcite.schema.Function> predicate = category == null ? function -> true : (category.isTableFunction() ? function -> function instanceof TableMacro || function instanceof TableFunction : function -> !(function instanceof TableMacro) && !(function instanceof TableFunction));
        this.getFunctionsFrom(opName.names).stream().filter(predicate).map(function -> CalciteCatalogReader.toOp(opName, function)).forEachOrdered(operatorList::add);
    }

    public static SqlOperatorTable operatorTable(String ... classNames) {
        CalciteSchema schema = CalciteSchema.createRootSchema(false, false);
        for (String className : classNames) {
            ModelHandler.addFunctions(schema.plus(), null, ImmutableList.of(), className, "*", true);
        }
        ArrayList list = new ArrayList();
        for (String name : schema.getFunctionNames()) {
            schema.getFunctions(name, true).forEach(function -> {
                SqlIdentifier id = new SqlIdentifier(name, SqlParserPos.ZERO);
                list.add(CalciteCatalogReader.toOp(id, function));
            });
        }
        return SqlOperatorTables.of(list);
    }

    private static SqlOperator toOp(SqlIdentifier name, com.hazelcast.org.apache.calcite.schema.Function function) {
        Function<RelDataTypeFactory, List> argTypesFactory = typeFactory -> function.getParameters().stream().map(o -> o.getType((RelDataTypeFactory)typeFactory)).collect(Util.toImmutableList());
        Function<RelDataTypeFactory, List> typeFamiliesFactory = typeFactory -> ((List)argTypesFactory.apply((RelDataTypeFactory)typeFactory)).stream().map(type -> Util.first(type.getSqlTypeName().getFamily(), SqlTypeFamily.ANY)).collect(Util.toImmutableList());
        Function<RelDataTypeFactory, List<RelDataType>> paramTypesFactory = typeFactory -> ((List)argTypesFactory.apply((RelDataTypeFactory)typeFactory)).stream().map(type -> CalciteCatalogReader.toSql(typeFactory, type)).collect(Util.toImmutableList());
        JavaTypeFactoryImpl dummyTypeFactory = new JavaTypeFactoryImpl();
        List argTypes = argTypesFactory.apply(dummyTypeFactory);
        List typeFamilies = typeFamiliesFactory.apply(dummyTypeFactory);
        SqlOperandTypeInference operandTypeInference = InferTypes.explicit(argTypes);
        SqlOperandMetadata operandMetadata = OperandTypes.operandMetadata(typeFamilies, paramTypesFactory, i -> function.getParameters().get(i).getName(), i -> function.getParameters().get((int)i).isOptional());
        SqlKind kind = CalciteCatalogReader.kind(function);
        if (function instanceof ScalarFunction) {
            SqlReturnTypeInference returnTypeInference = CalciteCatalogReader.infer((ScalarFunction)function);
            return new SqlUserDefinedFunction(name, kind, returnTypeInference, operandTypeInference, operandMetadata, function);
        }
        if (function instanceof AggregateFunction) {
            SqlReturnTypeInference returnTypeInference = CalciteCatalogReader.infer((AggregateFunction)function);
            return new SqlUserDefinedAggFunction(name, kind, returnTypeInference, operandTypeInference, operandMetadata, (AggregateFunction)function, false, false, Optionality.FORBIDDEN);
        }
        if (function instanceof TableMacro) {
            return new SqlUserDefinedTableMacro(name, kind, ReturnTypes.CURSOR, operandTypeInference, operandMetadata, (TableMacro)function);
        }
        if (function instanceof TableFunction) {
            return new SqlUserDefinedTableFunction(name, kind, ReturnTypes.CURSOR, operandTypeInference, operandMetadata, (TableFunction)function);
        }
        throw new AssertionError((Object)("unknown function type " + function));
    }

    private static SqlKind kind(com.hazelcast.org.apache.calcite.schema.Function function) {
        Hints hints;
        if (function instanceof ScalarFunctionImpl && (hints = ((ScalarFunctionImpl)function).method.getAnnotation(Hints.class)) != null) {
            for (String hint : hints.value()) {
                if (!hint.startsWith("SqlKind:")) continue;
                return SqlKind.valueOf(hint.substring("SqlKind:".length()));
            }
        }
        return SqlKind.OTHER_FUNCTION;
    }

    private static SqlReturnTypeInference infer(ScalarFunction function) {
        return opBinding -> {
            RelDataTypeFactory typeFactory = opBinding.getTypeFactory();
            RelDataType type = function instanceof ScalarFunctionImpl ? ((ScalarFunctionImpl)function).getReturnType(typeFactory, opBinding) : function.getReturnType(typeFactory);
            return CalciteCatalogReader.toSql(typeFactory, type);
        };
    }

    private static SqlReturnTypeInference infer(AggregateFunction function) {
        return opBinding -> {
            RelDataTypeFactory typeFactory = opBinding.getTypeFactory();
            RelDataType type = function.getReturnType(typeFactory);
            return CalciteCatalogReader.toSql(typeFactory, type);
        };
    }

    private static RelDataType toSql(RelDataTypeFactory typeFactory, RelDataType type) {
        if (type instanceof RelDataTypeFactoryImpl.JavaType && ((RelDataTypeFactoryImpl.JavaType)type).getJavaClass() == Object.class) {
            return typeFactory.createTypeWithNullability(typeFactory.createSqlType(SqlTypeName.ANY), true);
        }
        return JavaTypeFactoryImpl.toSql(typeFactory, type);
    }

    @Override
    public List<SqlOperator> getOperatorList() {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (List<String> schemaPath : this.schemaPaths) {
            CalciteSchema schema = SqlValidatorUtil.getSchema(this.rootSchema, schemaPath, this.nameMatcher);
            if (schema == null) continue;
            for (String name : schema.getFunctionNames()) {
                schema.getFunctions(name, true).forEach(f -> builder.add(CalciteCatalogReader.toOp(new SqlIdentifier(name, SqlParserPos.ZERO), f)));
            }
        }
        return builder.build();
    }

    @Override
    public CalciteSchema getRootSchema() {
        return this.rootSchema;
    }

    @Override
    public RelDataTypeFactory getTypeFactory() {
        return this.typeFactory;
    }

    @Override
    public void registerRules(RelOptPlanner planner) {
    }

    @Override
    public boolean isCaseSensitive() {
        return this.nameMatcher.isCaseSensitive();
    }

    @Override
    public SqlNameMatcher nameMatcher() {
        return this.nameMatcher;
    }

    @Override
    public <C> @Nullable C unwrap(Class<C> aClass) {
        if (aClass.isInstance(this)) {
            return aClass.cast(this);
        }
        return null;
    }
}

