/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.org.apache.calcite.plan;

import com.hazelcast.org.apache.calcite.plan.RelOptListener;
import com.hazelcast.org.apache.calcite.plan.RelOptRuleCall;
import com.hazelcast.org.apache.calcite.plan.RelOptUtil;
import com.hazelcast.org.apache.calcite.rel.RelNode;
import com.hazelcast.org.apache.calcite.util.trace.CalciteTrace;
import com.hazelcast.org.slf4j.Logger;
import com.hazelcast.org.slf4j.Marker;
import com.hazelcast.org.slf4j.MarkerFactory;
import java.util.Arrays;
import java.util.stream.Collectors;

public class RuleEventLogger
implements RelOptListener {
    private static final Logger LOG = CalciteTrace.getPlannerTracer();
    private static final Marker FULL = MarkerFactory.getMarker("FULL_PLAN");

    @Override
    public void relEquivalenceFound(RelOptListener.RelEquivalenceEvent event) {
    }

    @Override
    public void ruleAttempted(RelOptListener.RuleAttemptedEvent event) {
        if (event.isBefore() && LOG.isDebugEnabled()) {
            RelOptRuleCall call = event.getRuleCall();
            String ruleArgs = Arrays.stream(call.rels).map(rel -> "rel#" + rel.getId() + ":" + rel.getRelTypeName()).collect(Collectors.joining(","));
            LOG.debug("call#{}: Apply rule [{}] to [{}]", call.id, call.getRule(), ruleArgs);
        }
    }

    @Override
    public void ruleProductionSucceeded(RelOptListener.RuleProductionEvent event) {
        if (event.isBefore() && LOG.isDebugEnabled()) {
            RelOptRuleCall call = event.getRuleCall();
            Arrays.stream(call.rels).forEach(rel -> LOG.debug(FULL, "call#{}: Full plan for rule input [rel#{}:{}]: {}", call.id, rel.getId(), rel.getRelTypeName(), System.lineSeparator() + RelOptUtil.toString(rel)));
            RelNode newRel = event.getRel();
            String description = newRel == null ? "null" : "rel#" + newRel.getId() + ":" + newRel.getRelTypeName();
            LOG.debug("call#{}: Rule [{}] produced [{}]", call.id, call.getRule(), description);
            if (newRel != null) {
                LOG.debug(FULL, "call#{}: Full plan for [{}]:{}", call.id, description, System.lineSeparator() + RelOptUtil.toString(newRel));
            }
        }
    }

    @Override
    public void relDiscarded(RelOptListener.RelDiscardedEvent event) {
    }

    @Override
    public void relChosen(RelOptListener.RelChosenEvent event) {
    }
}

