/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.org.apache.calcite.linq4j.tree;

import com.hazelcast.org.apache.calcite.linq4j.tree.BlockStatement;
import com.hazelcast.org.apache.calcite.linq4j.tree.Expression;
import com.hazelcast.org.apache.calcite.linq4j.tree.Expressions;
import com.hazelcast.org.apache.calcite.linq4j.tree.GotoStatement;
import com.hazelcast.org.apache.calcite.linq4j.tree.Node;
import com.hazelcast.org.apache.calcite.linq4j.tree.Statement;
import java.util.Objects;

public final class Blocks {
    private Blocks() {
        throw new AssertionError((Object)"no blocks for you!");
    }

    private static BlockStatement toFunctionBlock(Node body, boolean function) {
        Statement statement;
        if (body instanceof BlockStatement) {
            return (BlockStatement)body;
        }
        if (body instanceof Statement) {
            statement = (Statement)body;
        } else if (body instanceof Expression) {
            statement = ((Expression)body).getType() == Void.TYPE && function ? Expressions.statement((Expression)body) : Expressions.return_(null, (Expression)body);
        } else {
            throw new AssertionError((Object)("block cannot contain node that is neither statement nor expression: " + body));
        }
        return Expressions.block(statement);
    }

    public static BlockStatement toFunctionBlock(Node body) {
        return Blocks.toFunctionBlock(body, true);
    }

    public static BlockStatement toBlock(Node body) {
        return Blocks.toFunctionBlock(body, false);
    }

    public static BlockStatement create(Statement statement, BlockStatement block) {
        return Expressions.block(Expressions.list(statement).appendAll((Iterable<Statement>)block.statements));
    }

    public static Expression simple(BlockStatement block) {
        Statement statement;
        if (block.statements.size() == 1 && (statement = block.statements.get(0)) instanceof GotoStatement) {
            return Objects.requireNonNull(((GotoStatement)statement).expression);
        }
        throw new AssertionError((Object)("not a simple block: " + block));
    }
}

