/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.schema;

import com.hazelcast.cluster.Address;
import com.hazelcast.cluster.Member;
import com.hazelcast.cluster.memberselector.MemberSelectors;
import com.hazelcast.core.EntryEvent;
import com.hazelcast.core.EntryListener;
import com.hazelcast.internal.cluster.Versions;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.logging.ILogger;
import com.hazelcast.map.IMap;
import com.hazelcast.map.MapEvent;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.replicatedmap.ReplicatedMap;
import com.hazelcast.replicatedmap.impl.operation.GetOperation;
import com.hazelcast.spi.impl.NodeEngine;
import com.hazelcast.spi.impl.operationservice.Operation;
import com.hazelcast.spi.impl.operationservice.OperationService;
import com.hazelcast.sql.impl.schema.Mapping;
import com.hazelcast.sql.impl.schema.type.Type;
import com.hazelcast.sql.impl.schema.view.View;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;

public class TablesStorage {
    private static final int MAX_CHECK_ATTEMPTS = 5;
    private static final long SLEEP_MILLIS = 100L;
    private final NodeEngine nodeEngine;
    private final Object mergingMutex = new Object();
    private final ILogger logger;
    private volatile boolean storageMovedToNew;

    public TablesStorage(NodeEngine nodeEngine) {
        this.nodeEngine = nodeEngine;
        this.logger = nodeEngine.getLogger(this.getClass());
    }

    void put(String name, Mapping mapping) {
        this.newStorage().put((Object)name, (Object)mapping);
        if (this.useOldStorage()) {
            this.oldStorage().put((Object)name, (Object)mapping);
            this.awaitMappingOnAllMembers(name, (IdentifiedDataSerializable)mapping);
        }
    }

    void put(String name, View view) {
        this.newStorage().put((Object)name, (Object)view);
        if (this.useOldStorage()) {
            this.oldStorage().put((Object)name, (Object)view);
            this.awaitMappingOnAllMembers(name, (IdentifiedDataSerializable)view);
        }
    }

    void put(String name, Type type) {
        this.newStorage().put((Object)name, (Object)type);
        if (this.useOldStorage()) {
            this.oldStorage().put((Object)name, (Object)type);
            this.awaitMappingOnAllMembers(name, (IdentifiedDataSerializable)type);
        }
    }

    boolean putIfAbsent(String name, Mapping mapping) {
        Object previousNew = this.newStorage().putIfAbsent((Object)name, (Object)mapping);
        Object previousOld = null;
        if (this.useOldStorage()) {
            previousOld = this.oldStorage().putIfAbsent((Object)name, (Object)mapping);
        }
        return previousNew == null && previousOld == null;
    }

    boolean putIfAbsent(String name, View view) {
        Object previousNew = this.newStorage().putIfAbsent((Object)name, (Object)view);
        Object previousOld = null;
        if (this.useOldStorage()) {
            previousOld = this.oldStorage().putIfAbsent((Object)name, (Object)view);
        }
        return previousNew == null && previousOld == null;
    }

    boolean putIfAbsent(String name, Type type) {
        Object previousNew = this.newStorage().putIfAbsent((Object)name, (Object)type);
        Object previousOld = null;
        if (this.useOldStorage()) {
            previousOld = this.oldStorage().putIfAbsent((Object)name, (Object)type);
        }
        return previousNew == null && previousOld == null;
    }

    Mapping removeMapping(String name) {
        Mapping removedNew = (Mapping)this.newStorage().remove((Object)name);
        Mapping removedOld = null;
        if (this.useOldStorage()) {
            removedOld = (Mapping)this.oldStorage().remove((Object)name);
        }
        return removedNew == null ? removedOld : removedNew;
    }

    public Collection<Type> getAllTypes() {
        return this.mergedStorage().values().stream().filter(o -> o instanceof Type).map(o -> (Type)o).collect(Collectors.toList());
    }

    public Type getType(String name) {
        Object obj = this.mergedStorage().get(name);
        if (obj instanceof Type) {
            return (Type)obj;
        }
        return null;
    }

    public Type removeType(String name) {
        Type removedNew = (Type)this.newStorage().remove((Object)name);
        Type removedOld = null;
        if (this.useOldStorage()) {
            removedOld = (Type)this.oldStorage().remove((Object)name);
        }
        return removedNew == null ? removedOld : removedNew;
    }

    View getView(String name) {
        Object obj = this.mergedStorage().get(name);
        if (obj instanceof View) {
            return (View)obj;
        }
        return null;
    }

    View removeView(String name) {
        View removedNew = (View)this.newStorage().remove((Object)name);
        View removedOld = null;
        if (this.useOldStorage()) {
            removedOld = (View)this.oldStorage().remove((Object)name);
        }
        return removedNew == null ? removedOld : removedNew;
    }

    Collection<Object> allObjects() {
        return this.mergedStorage().values();
    }

    Collection<String> mappingNames() {
        return this.mergedStorage().values().stream().filter(m4 -> m4 instanceof Mapping).map(m4 -> ((Mapping)m4).name()).collect(Collectors.toList());
    }

    Collection<String> viewNames() {
        return this.mergedStorage().values().stream().filter(v -> v instanceof View).map(v -> ((View)v).name()).collect(Collectors.toList());
    }

    Collection<String> typeNames() {
        return this.mergedStorage().values().stream().filter(t2 -> t2 instanceof Type).map(t2 -> ((Type)t2).getName()).collect(Collectors.toList());
    }

    void initializeWithListener(EntryListener<String, Object> listener) {
        boolean useOldStorage = this.useOldStorage();
        if (!useOldStorage) {
            this.storageMovedToNew = true;
        }
        if (!this.nodeEngine.getLocalMember().isLiteMember()) {
            this.newStorage().addEntryListener(listener, false);
            if (useOldStorage) {
                this.oldStorage().addEntryListener(listener);
            }
        }
    }

    ReplicatedMap<String, Object> oldStorage() {
        return this.nodeEngine.getHazelcastInstance().getReplicatedMap("__sql.catalog");
    }

    IMap<String, Object> newStorage() {
        return this.nodeEngine.getHazelcastInstance().getMap("__sql.catalog");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, Object> mergedStorage() {
        IMap<String, Object> newStorage = this.newStorage();
        if (this.useOldStorage()) {
            HashMap<String, Object> mergedCatalog = new HashMap<String, Object>();
            mergedCatalog.putAll((Map<String, Object>)newStorage);
            mergedCatalog.putAll((Map<String, Object>)this.oldStorage());
            return mergedCatalog;
        }
        if (!this.storageMovedToNew) {
            Object object = this.mergingMutex;
            synchronized (object) {
                if (!this.storageMovedToNew) {
                    ReplicatedMap<String, Object> oldStorage = this.oldStorage();
                    oldStorage.forEach((arg_0, arg_1) -> newStorage.putIfAbsent(arg_0, arg_1));
                    oldStorage.destroy();
                    this.storageMovedToNew = true;
                }
            }
        }
        return newStorage;
    }

    private boolean useOldStorage() {
        return !this.nodeEngine.getClusterService().getClusterVersion().isGreaterOrEqual(Versions.V5_2);
    }

    private Collection<Address> getMemberAddresses() {
        return this.nodeEngine.getClusterService().getMembers(MemberSelectors.DATA_MEMBER_SELECTOR).stream().filter(member -> !member.localMember() && !member.isLiteMember()).map(Member::getAddress).collect(Collectors.toSet());
    }

    private void awaitMappingOnAllMembers(String name, IdentifiedDataSerializable metadata) {
        Data keyData = this.nodeEngine.getSerializationService().toData((Object)name);
        int keyPartitionId = this.nodeEngine.getPartitionService().getPartitionId(keyData);
        OperationService operationService = this.nodeEngine.getOperationService();
        Collection<Address> memberAddresses = this.getMemberAddresses();
        for (int i = 0; i < 5 && !memberAddresses.isEmpty(); ++i) {
            List futures = memberAddresses.stream().map(memberAddress -> {
                Operation operation = new GetOperation("__sql.catalog", keyData).setPartitionId(keyPartitionId).setValidateTarget(false);
                return operationService.createInvocationBuilder("hz:impl:replicatedMapService", operation, memberAddress).setTryCount(1).invoke().toCompletableFuture().thenApply(result -> Objects.equals(metadata, result) ? memberAddress : null);
            }).collect(Collectors.toList());
            for (CompletableFuture future : futures) {
                try {
                    memberAddresses.remove(future.join());
                }
                catch (Exception e) {
                    this.logger.warning("Error occurred while trying to fetch mapping: " + e.getMessage(), (Throwable)e);
                }
            }
            if (memberAddresses.isEmpty()) continue;
            try {
                Thread.sleep(100L);
                continue;
            }
            catch (InterruptedException e) {
                break;
            }
        }
    }

    static abstract class EntryListenerAdapter
    implements EntryListener<String, Object> {
        EntryListenerAdapter() {
        }

        public final void entryAdded(EntryEvent<String, Object> event) {
        }

        public abstract void entryUpdated(EntryEvent<String, Object> var1);

        public abstract void entryRemoved(EntryEvent<String, Object> var1);

        public final void entryEvicted(EntryEvent<String, Object> event) {
            throw new UnsupportedOperationException("SQL catalog entries must never be evicted - " + event);
        }

        public void entryExpired(EntryEvent<String, Object> event) {
            throw new UnsupportedOperationException("SQL catalog entries must never be expired - " + event);
        }

        public final void mapCleared(MapEvent event) {
            throw new UnsupportedOperationException("SQL catalog must never be cleared - " + event);
        }

        public final void mapEvicted(MapEvent event) {
            throw new UnsupportedOperationException("SQL catalog must never be evicted - " + event);
        }
    }
}

