/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.processors;

import com.hazelcast.function.ToLongFunctionEx;
import com.hazelcast.internal.serialization.InternalSerializationService;
import com.hazelcast.internal.serialization.SerializationService;
import com.hazelcast.internal.serialization.impl.SerializationUtil;
import com.hazelcast.internal.util.CollectionUtil;
import com.hazelcast.internal.util.collection.Object2LongHashMap;
import com.hazelcast.jet.core.AbstractProcessor;
import com.hazelcast.jet.core.Processor;
import com.hazelcast.jet.core.ProcessorSupplier;
import com.hazelcast.jet.core.Watermark;
import com.hazelcast.jet.datamodel.Tuple2;
import com.hazelcast.jet.impl.memory.AccumulationLimitExceededException;
import com.hazelcast.jet.impl.util.Util;
import com.hazelcast.jet.sql.impl.ExpressionUtil;
import com.hazelcast.jet.sql.impl.JetJoinInfo;
import com.hazelcast.logging.ILogger;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.DataSerializable;
import com.hazelcast.sql.impl.expression.ConstantExpression;
import com.hazelcast.sql.impl.expression.Expression;
import com.hazelcast.sql.impl.expression.ExpressionEvalContext;
import com.hazelcast.sql.impl.row.JetSqlRow;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import javax.annotation.Nonnull;

public class StreamToStreamJoinP
extends AbstractProcessor {
    final Object2LongHashMap<Byte> wmState = new Object2LongHashMap(Long.MIN_VALUE);
    final Object2LongHashMap<Byte> lastReceivedWm = new Object2LongHashMap(Long.MIN_VALUE);
    final Object2LongHashMap<Byte> lastEmittedWm = new Object2LongHashMap(Long.MIN_VALUE);
    final Object2LongHashMap<Byte> minimumBufferTimes = new Object2LongHashMap(Long.MIN_VALUE);
    final List<JetSqlRow>[] buffer = new List[]{new LinkedList(), new LinkedList()};
    private final JetJoinInfo joinInfo;
    private final int outerJoinSide;
    private final List<Map.Entry<Byte, ToLongFunctionEx<JetSqlRow>>> leftTimeExtractors;
    private final List<Map.Entry<Byte, ToLongFunctionEx<JetSqlRow>>> rightTimeExtractors;
    private final Map<Byte, Map<Byte, Long>> postponeTimeMap;
    private final Tuple2<Integer, Integer> columnCounts;
    private long maxProcessorAccumulatedRecords;
    private ExpressionEvalContext evalContext;
    private Iterator<JetSqlRow> iterator;
    private JetSqlRow currItem;
    private final Set<JetSqlRow> unusedEventsTracker = Collections.newSetFromMap(new IdentityHashMap());
    private final Queue<Object> pendingOutput = new ArrayDeque<Object>();
    private JetSqlRow emptyLeftRow;
    private JetSqlRow emptyRightRow;

    public StreamToStreamJoinP(JetJoinInfo joinInfo, Map<Byte, ToLongFunctionEx<JetSqlRow>> leftTimeExtractors, Map<Byte, ToLongFunctionEx<JetSqlRow>> rightTimeExtractors, Map<Byte, Map<Byte, Long>> postponeTimeMap, Tuple2<Integer, Integer> columnCounts) {
        this.joinInfo = joinInfo;
        this.leftTimeExtractors = new ArrayList<Map.Entry<Byte, ToLongFunctionEx<JetSqlRow>>>(leftTimeExtractors.entrySet());
        this.rightTimeExtractors = new ArrayList<Map.Entry<Byte, ToLongFunctionEx<JetSqlRow>>>(rightTimeExtractors.entrySet());
        this.postponeTimeMap = postponeTimeMap;
        this.columnCounts = columnCounts;
        switch (joinInfo.getJoinType()) {
            case INNER: {
                this.outerJoinSide = -1;
                break;
            }
            case LEFT: {
                this.outerJoinSide = 0;
                break;
            }
            case RIGHT: {
                this.outerJoinSide = 1;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported join type: " + (Object)((Object)joinInfo.getJoinType()));
            }
        }
        for (Byte wmKey : postponeTimeMap.keySet()) {
            this.wmState.put((Object)wmKey, -9223372036854775807L);
            this.lastEmittedWm.put((Object)wmKey, -9223372036854775807L);
            this.lastReceivedWm.put((Object)wmKey, -9223372036854775807L);
            this.minimumBufferTimes.put((Object)wmKey, Long.MAX_VALUE);
        }
        if (CollectionUtil.hasNonEmptyIntersection(leftTimeExtractors.keySet(), rightTimeExtractors.keySet())) {
            throw new IllegalArgumentException("Some watermark key is found on both inputs. Left=" + leftTimeExtractors.keySet() + ", right=" + rightTimeExtractors.keySet());
        }
        boolean[] found = new boolean[2];
        for (Map.Entry<Byte, Map<Byte, Long>> outerEntry : postponeTimeMap.entrySet()) {
            for (Byte innerKey : outerEntry.getValue().keySet()) {
                boolean outerOrdinal;
                int innerOrdinal = leftTimeExtractors.containsKey(innerKey) ? 0 : 1;
                if (innerOrdinal == (outerOrdinal = !leftTimeExtractors.containsKey(outerEntry.getKey()))) continue;
                found[innerOrdinal] = true;
            }
        }
        if (!found[0] || !found[1]) {
            throw new IllegalArgumentException("Not enough time bounds in postponeTimeMap");
        }
    }

    protected void init(@Nonnull Processor.Context context) throws Exception {
        this.evalContext = ExpressionEvalContext.from((ProcessorSupplier.Context)context);
        InternalSerializationService ss = this.evalContext.getSerializationService();
        this.emptyLeftRow = new JetSqlRow((SerializationService)ss, new Object[((Integer)this.columnCounts.f0()).intValue()]);
        this.emptyRightRow = new JetSqlRow((SerializationService)ss, new Object[((Integer)this.columnCounts.f1()).intValue()]);
        this.maxProcessorAccumulatedRecords = context.maxProcessorAccumulatedRecords();
    }

    public boolean tryProcess(int ordinal, @Nonnull Object item) {
        JetSqlRow joinedRow;
        assert (ordinal == 0 || ordinal == 1);
        if (!this.processPendingOutput()) {
            return false;
        }
        if ((long)(this.buffer[0].size() + this.buffer[1].size()) >= this.maxProcessorAccumulatedRecords) {
            throw new AccumulationLimitExceededException();
        }
        boolean avoidBuffer = false;
        if (this.currItem == null) {
            int i;
            List<Map.Entry<Byte, ToLongFunctionEx<JetSqlRow>>> extractors = this.timeExtractors(ordinal);
            long[] times = new long[extractors.size()];
            for (i = 0; i < extractors.size(); ++i) {
                long wmValue = this.lastReceivedWm.getValue((Object)extractors.get(i).getKey());
                times[i] = extractors.get(i).getValue().applyAsLong((Object)((JetSqlRow)item));
                if (times[i] >= wmValue) continue;
                Util.logLateEvent((ILogger)this.getLogger(), (byte)extractors.get(i).getKey(), (long)wmValue, (Object)item);
                return true;
            }
            for (i = 0; i < extractors.size(); ++i) {
                long time = times[i];
                long joinTimeLimit = this.wmState.get((Object)extractors.get(i).getKey());
                avoidBuffer |= time < joinTimeLimit;
            }
            this.currItem = (JetSqlRow)item;
            if (!avoidBuffer) {
                this.buffer[ordinal].add(this.currItem);
                for (i = 0; i < extractors.size(); ++i) {
                    Byte wmKey = extractors.get(i).getKey();
                    if (times[i] >= this.minimumBufferTimes.get((Object)wmKey)) continue;
                    this.minimumBufferTimes.put((Object)wmKey, times[i]);
                }
            }
            this.iterator = this.buffer[1 - ordinal].iterator();
            if (ordinal == this.outerJoinSide) {
                this.unusedEventsTracker.add(this.currItem);
            }
        }
        while (this.iterator.hasNext()) {
            JetSqlRow oppositeBufferItem = this.iterator.next();
            JetSqlRow preparedOutput = ExpressionUtil.join(ordinal == 0 ? this.currItem : oppositeBufferItem, ordinal == 0 ? oppositeBufferItem : this.currItem, this.joinInfo.isEquiJoin() ? this.joinInfo.condition() : this.joinInfo.nonEquiCondition(), this.evalContext);
            if (preparedOutput == null) continue;
            if (ordinal == this.outerJoinSide) {
                this.unusedEventsTracker.remove(this.currItem);
            } else if (ordinal == 1 - this.outerJoinSide) {
                this.unusedEventsTracker.remove(oppositeBufferItem);
            }
            if (this.tryEmit(preparedOutput)) continue;
            this.pendingOutput.add(preparedOutput);
            return false;
        }
        if (avoidBuffer && !this.joinInfo.isInner() && this.unusedEventsTracker.remove(this.currItem) && (joinedRow = this.composeRowWithNulls(this.currItem, ordinal)) != null && !this.tryEmit(joinedRow)) {
            this.pendingOutput.add(joinedRow);
            return false;
        }
        this.iterator = null;
        this.currItem = null;
        return true;
    }

    public boolean tryProcessWatermark(int ordinal, @Nonnull Watermark watermark) {
        if (!this.pendingOutput.isEmpty()) {
            return this.processPendingOutput();
        }
        assert (this.wmState.containsKey((Object)watermark.key())) : "unexpected watermark key: " + watermark.key();
        assert (this.lastReceivedWm.get((Object)watermark.key()) < watermark.timestamp()) : "non-monotonic watermark: " + watermark + " when state is " + this.lastReceivedWm.get((Object)watermark.key());
        this.lastReceivedWm.put((Object)watermark.key(), watermark.timestamp());
        boolean modified = this.applyToWmState(watermark);
        if (modified) {
            this.clearExpiredItemsInBuffer(0);
            this.clearExpiredItemsInBuffer(1);
        }
        for (Byte wmKey : this.wmState.keySet()) {
            long lastReceivedWm;
            long minimumBufferTime = this.minimumBufferTimes.get((Object)wmKey);
            long newWmTime = Math.min(minimumBufferTime, lastReceivedWm = this.lastReceivedWm.getValue((Object)wmKey));
            if (newWmTime <= this.lastEmittedWm.getValue((Object)wmKey)) continue;
            this.pendingOutput.add(new Watermark(newWmTime, wmKey.byteValue()));
            this.lastEmittedWm.put((Object)wmKey, newWmTime);
        }
        return this.processPendingOutput();
    }

    public boolean tryProcessWatermark(@Nonnull Watermark watermark) {
        return true;
    }

    private boolean processPendingOutput() {
        while (!this.pendingOutput.isEmpty()) {
            if (!this.tryEmit(this.pendingOutput.peek())) {
                return false;
            }
            this.pendingOutput.remove();
        }
        return true;
    }

    private boolean applyToWmState(Watermark watermark) {
        boolean modified = false;
        Byte inputWmKey = watermark.key();
        Map<Byte, Long> wmKeyMapping = this.postponeTimeMap.get(inputWmKey);
        for (Map.Entry<Byte, Long> entry : wmKeyMapping.entrySet()) {
            Long newLimit = watermark.timestamp() - entry.getValue();
            Long oldLimit = this.wmState.get((Object)entry.getKey());
            if (newLimit <= oldLimit) continue;
            this.wmState.put((Object)entry.getKey(), newLimit);
            modified = true;
        }
        return modified;
    }

    private void clearExpiredItemsInBuffer(int ordinal) {
        List<Map.Entry<Byte, ToLongFunctionEx<JetSqlRow>>> extractors = this.timeExtractors(ordinal);
        long[] limits = new long[extractors.size()];
        long[] newMinimums = new long[extractors.size()];
        Arrays.fill(newMinimums, Long.MAX_VALUE);
        for (int i = 0; i < extractors.size(); ++i) {
            limits[i] = (Long)this.wmState.getOrDefault((Object)extractors.get(i).getKey(), (Object)Long.MIN_VALUE);
        }
        Iterator<JetSqlRow> iterator = this.buffer[ordinal].iterator();
        long[] times = new long[extractors.size()];
        while (iterator.hasNext()) {
            JetSqlRow row = iterator.next();
            boolean remove = false;
            for (int idx = 0; idx < extractors.size(); ++idx) {
                JetSqlRow joinedRow;
                times[idx] = extractors.get(idx).getValue().applyAsLong((Object)row);
                if (times[idx] >= limits[idx]) continue;
                remove = true;
                if (this.outerJoinSide != ordinal || !this.unusedEventsTracker.remove(row) || (joinedRow = this.composeRowWithNulls(row, ordinal)) == null) continue;
                this.pendingOutput.add(joinedRow);
            }
            if (remove) {
                iterator.remove();
                continue;
            }
            for (int i = 0; i < times.length; ++i) {
                newMinimums[i] = Math.min(times[i], newMinimums[i]);
            }
        }
        for (int i = 0; i < extractors.size(); ++i) {
            this.minimumBufferTimes.put((Object)extractors.get(i).getKey(), newMinimums[i]);
        }
    }

    private List<Map.Entry<Byte, ToLongFunctionEx<JetSqlRow>>> timeExtractors(int ordinal) {
        return ordinal == 0 ? this.leftTimeExtractors : this.rightTimeExtractors;
    }

    private JetSqlRow composeRowWithNulls(JetSqlRow row, int ordinal) {
        JetSqlRow joinedRow = null;
        if (ordinal == 1 && this.joinInfo.isRightOuter()) {
            joinedRow = ExpressionUtil.join(this.emptyLeftRow, row, (Expression<Boolean>)ConstantExpression.TRUE, this.evalContext);
        } else if (ordinal == 0 && this.joinInfo.isLeftOuter()) {
            joinedRow = ExpressionUtil.join(row, this.emptyRightRow, (Expression<Boolean>)ConstantExpression.TRUE, this.evalContext);
        }
        return joinedRow;
    }

    public static final class StreamToStreamJoinProcessorSupplier
    implements ProcessorSupplier,
    DataSerializable {
        private JetJoinInfo joinInfo;
        private Map<Byte, ToLongFunctionEx<JetSqlRow>> leftTimeExtractors;
        private Map<Byte, ToLongFunctionEx<JetSqlRow>> rightTimeExtractors;
        private Map<Byte, Map<Byte, Long>> postponeTimeMap;
        private int leftInputColumnCount;
        private int rightInputColumnCount;

        private StreamToStreamJoinProcessorSupplier() {
        }

        public StreamToStreamJoinProcessorSupplier(JetJoinInfo joinInfo, Map<Byte, ToLongFunctionEx<JetSqlRow>> leftTimeExtractors, Map<Byte, ToLongFunctionEx<JetSqlRow>> rightTimeExtractors, Map<Byte, Map<Byte, Long>> postponeTimeMap, int leftInputColumnCount, int rightInputColumnCount) {
            this.joinInfo = joinInfo;
            this.leftTimeExtractors = leftTimeExtractors;
            this.rightTimeExtractors = rightTimeExtractors;
            this.postponeTimeMap = postponeTimeMap;
            this.leftInputColumnCount = leftInputColumnCount;
            this.rightInputColumnCount = rightInputColumnCount;
        }

        @Nonnull
        public Collection<? extends Processor> get(int count) {
            ArrayList<StreamToStreamJoinP> processors = new ArrayList<StreamToStreamJoinP>(count);
            for (int i = 0; i < count; ++i) {
                processors.add(new StreamToStreamJoinP(this.joinInfo, this.leftTimeExtractors, this.rightTimeExtractors, this.postponeTimeMap, (Tuple2<Integer, Integer>)Tuple2.tuple2((Object)this.leftInputColumnCount, (Object)this.rightInputColumnCount)));
            }
            return processors;
        }

        public void writeData(ObjectDataOutput out) throws IOException {
            out.writeObject((Object)this.joinInfo);
            SerializationUtil.writeMap(this.leftTimeExtractors, (ObjectDataOutput)out);
            SerializationUtil.writeMap(this.rightTimeExtractors, (ObjectDataOutput)out);
            SerializationUtil.writeMap(this.postponeTimeMap, (ObjectDataOutput)out);
            out.writeInt(this.leftInputColumnCount);
            out.writeInt(this.rightInputColumnCount);
        }

        public void readData(ObjectDataInput in) throws IOException {
            this.joinInfo = (JetJoinInfo)in.readObject();
            this.leftTimeExtractors = SerializationUtil.readMap((ObjectDataInput)in);
            this.rightTimeExtractors = SerializationUtil.readMap((ObjectDataInput)in);
            this.postponeTimeMap = SerializationUtil.readMap((ObjectDataInput)in);
            this.leftInputColumnCount = in.readInt();
            this.rightInputColumnCount = in.readInt();
        }
    }
}

