/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.opt.physical;

import com.hazelcast.jet.core.Vertex;
import com.hazelcast.jet.sql.impl.opt.FieldCollation;
import com.hazelcast.jet.sql.impl.opt.OptUtils;
import com.hazelcast.jet.sql.impl.opt.physical.CreateDagVisitor;
import com.hazelcast.jet.sql.impl.opt.physical.PhysicalRel;
import com.hazelcast.org.apache.calcite.plan.RelOptCluster;
import com.hazelcast.org.apache.calcite.plan.RelOptCost;
import com.hazelcast.org.apache.calcite.plan.RelOptPlanner;
import com.hazelcast.org.apache.calcite.plan.RelTraitSet;
import com.hazelcast.org.apache.calcite.rel.RelCollation;
import com.hazelcast.org.apache.calcite.rel.RelNode;
import com.hazelcast.org.apache.calcite.rel.RelWriter;
import com.hazelcast.org.apache.calcite.rel.core.Sort;
import com.hazelcast.org.apache.calcite.rel.metadata.RelMetadataQuery;
import com.hazelcast.org.apache.calcite.rel.type.RelDataType;
import com.hazelcast.org.apache.calcite.rex.RexLiteral;
import com.hazelcast.org.apache.calcite.rex.RexNode;
import com.hazelcast.org.apache.calcite.rex.RexVisitor;
import com.hazelcast.org.apache.calcite.util.Util;
import com.hazelcast.org.checkerframework.checker.nullness.qual.Nullable;
import com.hazelcast.sql.impl.QueryParameterMetadata;
import com.hazelcast.sql.impl.expression.Expression;
import com.hazelcast.sql.impl.plan.node.PlanNodeFieldTypeProvider;
import com.hazelcast.sql.impl.plan.node.PlanNodeSchema;
import java.util.List;
import java.util.stream.Collectors;

public class SortPhysicalRel
extends Sort
implements PhysicalRel {
    private final boolean requiresSort;

    SortPhysicalRel(RelOptCluster cluster, RelTraitSet traits, RelNode input, RelCollation collation, RexNode offset, RexNode fetch, RelDataType rowType, boolean requiresSort) {
        super(cluster, traits, input, collation, offset, fetch);
        this.rowType = rowType;
        this.requiresSort = requiresSort;
    }

    public boolean requiresSort() {
        return this.requiresSort;
    }

    @Override
    public RelOptCost computeSelfCost(RelOptPlanner planner, RelMetadataQuery mq) {
        double readCount;
        double offsetValue = Util.first(SortPhysicalRel.doubleValue(this.offset), 0.0);
        double inCount = mq.getRowCount(this.input);
        Double fetchValue = SortPhysicalRel.doubleValue(this.fetch);
        if (fetchValue == null) {
            readCount = inCount;
        } else {
            if (fetchValue <= 0.0) {
                return planner.getCostFactory().makeCost(inCount, 0.0, 0.0);
            }
            readCount = Math.min(inCount, offsetValue + fetchValue);
        }
        double bytesPerRow = (3 + this.getRowType().getFieldCount()) * 4;
        double cpu = this.collation.getFieldCollations().isEmpty() || !this.requiresSort ? readCount * bytesPerRow : Util.nLogM(inCount, readCount) * bytesPerRow;
        return planner.getCostFactory().makeCost(readCount, cpu, 0.0);
    }

    public List<FieldCollation> getCollations() {
        return this.getCollation().getFieldCollations().stream().map(FieldCollation::new).collect(Collectors.toList());
    }

    public Expression<?> fetch(QueryParameterMetadata parameterMetadata) {
        PlanNodeSchema schema = this.schema(parameterMetadata);
        RexVisitor<Expression<?>> visitor = OptUtils.createRexToExpressionVisitor((PlanNodeFieldTypeProvider)schema, parameterMetadata);
        return this.fetch.accept(visitor);
    }

    public Expression<?> offset(QueryParameterMetadata parameterMetadata) {
        PlanNodeSchema schema = this.schema(parameterMetadata);
        RexVisitor<Expression<?>> visitor = OptUtils.createRexToExpressionVisitor((PlanNodeFieldTypeProvider)schema, parameterMetadata);
        return this.offset.accept(visitor);
    }

    @Override
    public PlanNodeSchema schema(QueryParameterMetadata parameterMetadata) {
        return OptUtils.schema(this.rowType);
    }

    @Override
    public Vertex accept(CreateDagVisitor visitor) {
        return visitor.onSort(this);
    }

    @Override
    public final RelWriter explainTerms(RelWriter pw) {
        return super.explainTerms(pw).item("requiresSort", this.requiresSort);
    }

    @Override
    public Sort copy(RelTraitSet traitSet, RelNode input, RelCollation collation, RexNode offset, RexNode fetch) {
        return new SortPhysicalRel(this.getCluster(), traitSet, input, collation, offset, fetch, this.rowType, this.requiresSort);
    }

    private static @Nullable Double doubleValue(@Nullable RexNode r) {
        return r instanceof RexLiteral ? ((RexLiteral)r).getValueAs(Double.class) : null;
    }
}

